/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.session;

import com.hierynomus.smbj.share.TreeConnect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class TreeConnectTable {
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<Long, TreeConnect> lookupById = new HashMap<Long, TreeConnect>();
    private Map<String, TreeConnect> lookupByShareName = new HashMap<String, TreeConnect>();

    TreeConnectTable() {
    }

    void register(TreeConnect treeConnect) {
        this.lock.writeLock().lock();
        try {
            this.lookupById.put(treeConnect.getTreeId(), treeConnect);
            this.lookupByShareName.put(treeConnect.getShareName(), treeConnect);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    Collection<TreeConnect> getOpenTreeConnects() {
        this.lock.readLock().lock();
        try {
            ArrayList<TreeConnect> arrayList = new ArrayList<TreeConnect>(this.lookupById.values());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TreeConnect getTreeConnect(long treeConnectId) {
        this.lock.readLock().lock();
        try {
            TreeConnect treeConnect = this.lookupById.get(treeConnectId);
            return treeConnect;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    TreeConnect getTreeConnect(String shareName) {
        this.lock.readLock().lock();
        try {
            TreeConnect treeConnect = this.lookupByShareName.get(shareName);
            return treeConnect;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closed(long treeConnectId) {
        this.lock.writeLock().lock();
        try {
            TreeConnect treeConnect = this.lookupById.remove(treeConnectId);
            if (treeConnect != null) {
                this.lookupByShareName.remove(treeConnect.getShareName());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

