/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.share;

import com.hierynomus.mserref.NtStatus;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2CreateOptions;
import com.hierynomus.mssmb2.SMB2FileId;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.mssmb2.messages.SMB2Close;
import com.hierynomus.mssmb2.messages.SMB2CreateRequest;
import com.hierynomus.mssmb2.messages.SMB2CreateResponse;
import com.hierynomus.protocol.commons.concurrent.Futures;
import com.hierynomus.smbj.common.SMBApiException;
import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.common.SmbPath;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.TreeConnect;
import com.hierynomus.smbj.transport.TransportException;
import java.io.IOException;
import java.util.EnumSet;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Share
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Share.class);
    protected SmbPath smbPath;
    protected final TreeConnect treeConnect;
    private AtomicBoolean disconnected = new AtomicBoolean(false);

    Share(SmbPath smbPath, TreeConnect treeConnect) {
        this.smbPath = smbPath;
        this.treeConnect = treeConnect;
        treeConnect.setHandle(this);
    }

    @Override
    public void close() throws IOException {
        if (!this.disconnected.getAndSet(true)) {
            this.treeConnect.close(this);
        }
    }

    public boolean isConnected() {
        return !this.disconnected.get();
    }

    public TreeConnect getTreeConnect() {
        return this.treeConnect;
    }

    public SMB2FileId open(String path, long accessMask, EnumSet<FileAttributes> fileAttributes, EnumSet<SMB2ShareAccess> shareAccess, SMB2CreateDisposition createDisposition, EnumSet<SMB2CreateOptions> createOptions) throws SMBApiException {
        logger.info("open {},{}", (Object)path);
        Session session = this.treeConnect.getSession();
        SMB2CreateRequest cr = Share.openFileRequest(this.treeConnect, path, accessMask, shareAccess, fileAttributes, createDisposition, createOptions);
        try {
            Future responseFuture = session.send(cr);
            SMB2CreateResponse cresponse = (SMB2CreateResponse)Futures.get(responseFuture, SMBRuntimeException.Wrapper);
            if (cresponse.getHeader().getStatus() != NtStatus.STATUS_SUCCESS) {
                throw new SMBApiException(cresponse.getHeader(), "Create failed for " + path);
            }
            return cresponse.getFileId();
        }
        catch (TransportException e) {
            throw SMBRuntimeException.Wrapper.wrap(e);
        }
    }

    protected static SMB2CreateRequest openFileRequest(TreeConnect treeConnect, String path, long accessMask, EnumSet<SMB2ShareAccess> shareAccess, EnumSet<FileAttributes> fileAttributes, SMB2CreateDisposition createDisposition, EnumSet<SMB2CreateOptions> createOptions) {
        Session session = treeConnect.getSession();
        SMB2CreateRequest cr = new SMB2CreateRequest(session.getConnection().getNegotiatedProtocol().getDialect(), session.getSessionId(), treeConnect.getTreeId(), accessMask, fileAttributes, shareAccess, createDisposition, createOptions, path);
        return cr;
    }

    public void close(SMB2FileId fileId) throws TransportException, SMBApiException {
        Connection connection;
        SMB2Close closeReq;
        Session session = this.treeConnect.getSession();
        Future closeFuture = session.send(closeReq = new SMB2Close((connection = session.getConnection()).getNegotiatedProtocol().getDialect(), this.treeConnect.getSession().getSessionId(), this.treeConnect.getTreeId(), fileId));
        SMB2Close closeResp = (SMB2Close)Futures.get(closeFuture, TransportException.Wrapper);
        if (closeResp.getHeader().getStatus() != NtStatus.STATUS_SUCCESS) {
            throw new SMBApiException(closeResp.getHeader(), "Close failed for " + fileId);
        }
    }
}

