/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.smb;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.mserref.NtStatus;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.msfscc.fileinformation.FileInfo;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.smbj.common.SMBApiException;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import com.hierynomus.smbj.transport.TransportException;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.smb.SmbConnection;
import com.xebialabs.overthere.smb.SmbPaths;
import com.xebialabs.overthere.spi.BaseOverthereFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbFile
extends BaseOverthereFile<SmbConnection> {
    private final String hostPath;
    private boolean overwrite = true;
    private Map<String, String> pathMappings;
    private static Logger logger = LoggerFactory.getLogger(SmbFile.class);

    public SmbFile(SmbConnection connection, String hostPath, Map<String, String> pathMappings) {
        super(connection);
        this.hostPath = SmbPaths.escapeForwardSlashes(hostPath);
        this.pathMappings = pathMappings;
    }

    @Override
    public String getPath() {
        return this.hostPath;
    }

    @Override
    public String getName() {
        return SmbPaths.getFileName(this.getPathOnShare());
    }

    @Override
    public OverthereFile getFile(String child) {
        return new SmbFile((SmbConnection)this.getConnection(), SmbPaths.join(this.hostPath, child), this.pathMappings);
    }

    @Override
    public OverthereFile getParentFile() {
        SmbFile f = null;
        String parentPath = SmbPaths.getParentPath(this.hostPath);
        if (parentPath != null) {
            f = this.getFileForAbsolutePath(parentPath);
        }
        return f;
    }

    @Override
    public boolean exists() {
        return this.isFile() || this.isDirectory();
    }

    @Override
    public boolean canRead() {
        logger.debug("Checking whether {} can be read", (Object)this.getPath());
        return this.getShare().checkAccessMask(AccessMask.FILE_READ_DATA, this.getPathOnShare());
    }

    @Override
    public boolean canWrite() {
        logger.debug("Checking whether {} can be write", (Object)this.getPath());
        return this.getShare().checkAccessMask(AccessMask.FILE_WRITE_DATA, this.getPathOnShare());
    }

    @Override
    public boolean canExecute() {
        logger.debug("Checking whether {} can execute", (Object)this.getPath());
        return this.getShare().checkAccessMask(AccessMask.FILE_READ_DATA, this.getPathOnShare());
    }

    @Override
    public boolean isFile() {
        try {
            return this.getShare().fileExists(this.getPathOnShare());
        }
        catch (SMBApiException e) {
            if (e.getStatus().equals((Object)NtStatus.STATUS_FILE_IS_A_DIRECTORY) || e.getStatus().equals((Object)NtStatus.STATUS_OBJECT_PATH_NOT_FOUND)) {
                return false;
            }
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.getShare().folderExists(this.getPathOnShare());
        }
        catch (SMBApiException e) {
            if (e.getStatus().equals((Object)NtStatus.STATUS_NOT_A_DIRECTORY) || e.getStatus().equals((Object)NtStatus.STATUS_OBJECT_PATH_NOT_FOUND)) {
                return false;
            }
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public boolean isHidden() {
        return this.checkAttributes(FileAttributes.FILE_ATTRIBUTE_HIDDEN);
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public long length() {
        return this.getShare().getFileInformation(this.getPathOnShare()).getFileSize();
    }

    @Override
    public InputStream getInputStream() throws RuntimeIOException {
        logger.debug("Opening SMB input stream for {}", (Object)this.getSharePath());
        try {
            final File file = this.getShare().openFile(this.getPathOnShare(), EnumSet.of(AccessMask.GENERIC_READ), SMB2CreateDisposition.FILE_OPEN);
            final InputStream wrapped = file.getInputStream();
            return this.asBuffered(new InputStream(){

                @Override
                public int read() throws IOException {
                    return wrapped.read();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return wrapped.read(b);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return wrapped.read(b, off, len);
                }

                @Override
                public long skip(long n) throws IOException {
                    return wrapped.skip(n);
                }

                @Override
                public void close() throws IOException {
                    logger.debug("Closing SMB input stream for {}", (Object)SmbFile.this.getSharePath());
                    wrapped.close();
                    SmbFile.this.getShare().close(file.getFileId());
                }
            });
        }
        catch (TransportException e) {
            throw new RuntimeIOException(String.format("Cannot open %s for reading: %s", this.getSharePath(), e.toString()), e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        logger.debug("Opening SMB output stream for {}", (Object)this.getSharePath());
        try {
            SMB2CreateDisposition createDisposition = SMB2CreateDisposition.FILE_OVERWRITE_IF;
            if (!this.overwrite) {
                createDisposition = SMB2CreateDisposition.FILE_CREATE;
            }
            final File file = this.getShare().openFile(this.getPathOnShare(), EnumSet.of(AccessMask.GENERIC_WRITE), createDisposition);
            final OutputStream wrapped = file.getOutputStream();
            return this.asBuffered(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    wrapped.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    wrapped.write(b, off, len);
                }

                @Override
                public void write(byte[] b) throws IOException {
                    wrapped.write(b);
                }

                @Override
                public void flush() throws IOException {
                    wrapped.flush();
                }

                @Override
                public void close() throws IOException {
                    logger.debug("Closing SMB output stream for {}", (Object)SmbFile.this.getSharePath());
                    wrapped.close();
                    SmbFile.this.getShare().close(file.getFileId());
                }
            });
        }
        catch (TransportException e) {
            throw new RuntimeIOException(String.format("Cannot open %s for writing: %s", this.getSharePath(), e.toString()), e);
        }
    }

    @Override
    public void setExecutable(boolean executable) {
    }

    @Override
    public void delete() {
        this.delete(false);
    }

    @Override
    public void deleteRecursively() {
        this.delete(true);
    }

    @Override
    public List<OverthereFile> listFiles() {
        String sharePath = this.getPathOnShare();
        logger.debug("Listing directory {}", (Object)sharePath);
        try {
            ArrayList<OverthereFile> files = new ArrayList<OverthereFile>();
            for (FileInfo info : this.getShare().list(sharePath)) {
                files.add(this.getFile(info.getFileName()));
            }
            return files;
        }
        catch (TransportException e) {
            throw new RuntimeIOException(String.format("Cannot list directory %s: %s", sharePath, e.toString()), e);
        }
        catch (SMBApiException e) {
            throw new RuntimeIOException(String.format("Cannot list directory %s: %s", sharePath, e.toString()), e);
        }
    }

    @Override
    public void mkdir() {
        this.makeDirectory(this.getPathOnShare());
    }

    private void makeDirectory(String path) {
        String sharePath = this.getPathOnShare();
        logger.debug("Creating directory {}", (Object)sharePath);
        try {
            this.getShare().mkdir(path);
        }
        catch (TransportException e) {
            throw new RuntimeIOException(String.format("Cannot create directory %s: %s", sharePath, e.toString()), e);
        }
        catch (SMBApiException e) {
            throw new RuntimeIOException(String.format("Cannot create directory %s: %s", sharePath, e.toString()), e);
        }
    }

    @Override
    public void mkdirs() {
        String[] paths;
        String sharePath = this.getPathOnShare();
        logger.debug("Creating directories {}", (Object)sharePath);
        for (String p : paths = SmbPaths.getPathListFromOuterToInner(sharePath)) {
            if (this.getShare().folderExists(p)) continue;
            this.makeDirectory(p);
        }
    }

    @Override
    public void renameTo(OverthereFile dest) {
        throw new RuntimeException("Operation not supported");
    }

    public boolean equals(Object that) {
        if (!(that instanceof SmbFile)) {
            return false;
        }
        return this.getPath().equals(((SmbFile)that).getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    @Override
    public String toString() {
        return this.getConnection() + "/" + this.getPath();
    }

    private void delete(boolean recursive) {
        String sharePath = this.getPathOnShare();
        try {
            if (this.isFile()) {
                logger.debug("deleting file {}", (Object)sharePath);
                this.getShare().rm(sharePath);
            } else {
                logger.debug("deleting directory {}", (Object)sharePath);
                this.getShare().rmdir(sharePath, recursive);
            }
        }
        catch (TransportException e) {
            throw new RuntimeIOException(String.format("Cannot delete %s: %s", sharePath, e.toString()), e);
        }
        catch (SMBApiException e) {
            throw new RuntimeIOException(String.format("Cannot delete %s: %s", sharePath, e.toString()), e);
        }
    }

    private String getSharePath() {
        return SmbPaths.getSharePath(this.hostPath, this.pathMappings);
    }

    private String getPathOnShare() {
        return SmbPaths.getPathOnShare(this.getSharePath());
    }

    private DiskShare getShare() {
        String shareName = SmbPaths.getShareName(this.getSharePath());
        return ((SmbConnection)this.connection).getShare(shareName);
    }

    private boolean checkAttributes(FileAttributes mask) {
        long attrMask = this.getShare().getFileInformation(this.getPathOnShare()).getFileAttributes();
        return EnumWithValue.EnumUtils.isSet((long)attrMask, (EnumWithValue)mask);
    }

    private SmbFile getFileForAbsolutePath(String path) {
        return new SmbFile((SmbConnection)this.getConnection(), path, this.pathMappings);
    }
}

