/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.driver.ClientProxy;
import io.aeron.driver.Configuration;
import io.aeron.driver.CongestionControlSupplier;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.FlowControlSupplier;
import io.aeron.driver.ReceiveChannelEndpointSupplier;
import io.aeron.driver.Receiver;
import io.aeron.driver.ReceiverProxy;
import io.aeron.driver.SendChannelEndpointSupplier;
import io.aeron.driver.Sender;
import io.aeron.driver.SenderProxy;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.buffer.RawLogFactory;
import io.aeron.driver.cmd.DriverConductorCmd;
import io.aeron.driver.cmd.ReceiverCmd;
import io.aeron.driver.cmd.SenderCmd;
import io.aeron.driver.exceptions.ActiveDriverException;
import io.aeron.driver.exceptions.ConfigurationException;
import io.aeron.driver.media.ControlTransportPoller;
import io.aeron.driver.media.DataTransportPoller;
import io.aeron.driver.media.ReceiveChannelEndpointThreadLocals;
import io.aeron.driver.reports.LossReport;
import io.aeron.driver.reports.LossReportUtil;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.DatagramChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.SystemUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.CompositeAgent;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.HighResolutionTimer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.ShutdownSignalBarrier;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.broadcast.BroadcastTransmitter;
import org.agrona.concurrent.errors.DistinctErrorLog;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.StatusIndicator;
import org.agrona.concurrent.status.UnsafeBufferStatusIndicator;

public final class MediaDriver
implements AutoCloseable {
    public static final String DIRS_DELETE_ON_START_PROP_NAME = "aeron.dir.delete.on.start";
    private final AgentRunner sharedRunner;
    private final AgentRunner sharedNetworkRunner;
    private final AgentRunner conductorRunner;
    private final AgentRunner receiverRunner;
    private final AgentRunner senderRunner;
    private final Context ctx;

    public static void loadPropertiesFile(String filenameOrUrl) {
        Throwable throwable;
        InputStream in2;
        Properties properties = new Properties(System.getProperties());
        try {
            in2 = MediaDriver.class.getClassLoader().getResourceAsStream(filenameOrUrl);
            throwable = null;
            try {
                properties.load(in2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in2 != null) {
                    if (throwable != null) {
                        try {
                            in2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        in2.close();
                    }
                }
            }
        }
        catch (Exception in2) {
            // empty catch block
        }
        try {
            in2 = new FileInputStream(filenameOrUrl);
            throwable = null;
            try {
                properties.load(in2);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (in2 != null) {
                    if (throwable != null) {
                        try {
                            ((FileInputStream)in2).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((FileInputStream)in2).close();
                    }
                }
            }
        }
        catch (Exception in3) {
            // empty catch block
        }
        try {
            in2 = new URL(filenameOrUrl).openStream();
            throwable = null;
            try {
                properties.load(in2);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (in2 != null) {
                    if (throwable != null) {
                        try {
                            in2.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        in2.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperties(properties);
    }

    public static void loadPropertiesFiles(String[] filenamesOrUrls) {
        for (String filenameOrUrl : filenamesOrUrls) {
            MediaDriver.loadPropertiesFile(filenameOrUrl);
        }
    }

    public static void main(String[] args) throws Exception {
        MediaDriver.loadPropertiesFiles(args);
        try (MediaDriver ignored = MediaDriver.launch();){
            new ShutdownSignalBarrier().await();
            System.out.println("Shutdown Driver...");
        }
    }

    private MediaDriver(Context ctx) {
        this.ctx = ctx;
        ctx.concludeAeronDirectory();
        MediaDriver.ensureDirectoryIsRecreated(ctx);
        MediaDriver.validateSufficientSocketBufferLengths(ctx);
        ctx.toConductorFromReceiverCommandQueue((OneToOneConcurrentArrayQueue<DriverConductorCmd>)new OneToOneConcurrentArrayQueue(1024)).toConductorFromSenderCommandQueue((OneToOneConcurrentArrayQueue<DriverConductorCmd>)new OneToOneConcurrentArrayQueue(1024)).receiverCommandQueue((OneToOneConcurrentArrayQueue<ReceiverCmd>)new OneToOneConcurrentArrayQueue(1024)).senderCommandQueue((OneToOneConcurrentArrayQueue<SenderCmd>)new OneToOneConcurrentArrayQueue(1024)).conclude();
        Receiver receiver = new Receiver(ctx);
        Sender sender = new Sender(ctx);
        DriverConductor conductor = new DriverConductor(ctx);
        ctx.receiverProxy().receiver(receiver);
        ctx.senderProxy().sender(sender);
        ctx.fromReceiverDriverConductorProxy().driverConductor(conductor);
        ctx.fromSenderDriverConductorProxy().driverConductor(conductor);
        ctx.toDriverCommands().consumerHeartbeatTime(ctx.epochClock().time());
        AtomicCounter errorCounter = ctx.systemCounters().get(SystemCounterDescriptor.ERRORS);
        ErrorHandler errorHandler = ctx.errorHandler();
        switch (ctx.threadingMode) {
            case SHARED: {
                this.sharedRunner = new AgentRunner(ctx.sharedIdleStrategy, errorHandler, errorCounter, (Agent)new CompositeAgent(new Agent[]{sender, receiver, conductor}));
                this.sharedNetworkRunner = null;
                this.conductorRunner = null;
                this.receiverRunner = null;
                this.senderRunner = null;
                break;
            }
            case SHARED_NETWORK: {
                this.sharedNetworkRunner = new AgentRunner(ctx.sharedNetworkIdleStrategy, errorHandler, errorCounter, (Agent)new CompositeAgent(new Agent[]{sender, receiver}));
                this.conductorRunner = new AgentRunner(ctx.conductorIdleStrategy, errorHandler, errorCounter, (Agent)conductor);
                this.sharedRunner = null;
                this.receiverRunner = null;
                this.senderRunner = null;
                break;
            }
            default: {
                this.senderRunner = new AgentRunner(ctx.senderIdleStrategy, errorHandler, errorCounter, (Agent)sender);
                this.receiverRunner = new AgentRunner(ctx.receiverIdleStrategy, errorHandler, errorCounter, (Agent)receiver);
                this.conductorRunner = new AgentRunner(ctx.conductorIdleStrategy, errorHandler, errorCounter, (Agent)conductor);
                this.sharedNetworkRunner = null;
                this.sharedRunner = null;
            }
        }
    }

    public static MediaDriver launchEmbedded() {
        return MediaDriver.launchEmbedded(new Context());
    }

    public static MediaDriver launchEmbedded(Context ctx) {
        if (CommonContext.AERON_DIR_PROP_DEFAULT.equals(ctx.aeronDirectoryName())) {
            ctx.aeronDirectoryName(CommonContext.generateRandomDirName());
        }
        return MediaDriver.launch(ctx);
    }

    public static MediaDriver launch() {
        return MediaDriver.launch(new Context());
    }

    public static MediaDriver launch(Context ctx) {
        return new MediaDriver(ctx).start();
    }

    @Override
    public void close() {
        CloseHelper.quietClose((AutoCloseable)this.sharedRunner);
        CloseHelper.quietClose((AutoCloseable)this.sharedNetworkRunner);
        CloseHelper.quietClose((AutoCloseable)this.receiverRunner);
        CloseHelper.quietClose((AutoCloseable)this.senderRunner);
        CloseHelper.quietClose((AutoCloseable)this.conductorRunner);
        this.ctx.close();
    }

    public String aeronDirectoryName() {
        return this.ctx.aeronDirectoryName();
    }

    private MediaDriver start() {
        if (SystemUtil.osName().startsWith("win") && !HighResolutionTimer.isEnabled()) {
            HighResolutionTimer.enable();
        }
        if (null != this.conductorRunner) {
            AgentRunner.startOnThread((AgentRunner)this.conductorRunner, (ThreadFactory)this.ctx.conductorThreadFactory);
        }
        if (null != this.senderRunner) {
            AgentRunner.startOnThread((AgentRunner)this.senderRunner, (ThreadFactory)this.ctx.senderThreadFactory);
        }
        if (null != this.receiverRunner) {
            AgentRunner.startOnThread((AgentRunner)this.receiverRunner, (ThreadFactory)this.ctx.receiverThreadFactory);
        }
        if (null != this.sharedNetworkRunner) {
            AgentRunner.startOnThread((AgentRunner)this.sharedNetworkRunner, (ThreadFactory)this.ctx.sharedNetworkThreadFactory);
        }
        if (null != this.sharedRunner) {
            AgentRunner.startOnThread((AgentRunner)this.sharedRunner, (ThreadFactory)this.ctx.sharedThreadFactory);
        }
        return this;
    }

    private static void validateSufficientSocketBufferLengths(Context ctx) {
        try (DatagramChannel probe = DatagramChannel.open();){
            int soSndBuf;
            int defaultSoSndBuf = probe.getOption(StandardSocketOptions.SO_SNDBUF);
            probe.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)Integer.MAX_VALUE);
            int maxSoSndBuf = probe.getOption(StandardSocketOptions.SO_SNDBUF);
            if (maxSoSndBuf < Configuration.SOCKET_SNDBUF_LENGTH) {
                System.err.format("WARNING: Could not get desired SO_SNDBUF, adjust OS buffer to match %s: attempted=%d, actual=%d%n", "aeron.socket.so_sndbuf", Configuration.SOCKET_SNDBUF_LENGTH, maxSoSndBuf);
            }
            probe.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)Integer.MAX_VALUE);
            int maxSoRcvBuf = probe.getOption(StandardSocketOptions.SO_RCVBUF);
            if (maxSoRcvBuf < Configuration.SOCKET_RCVBUF_LENGTH) {
                System.err.format("WARNING: Could not get desired SO_RCVBUF, adjust OS buffer to match %s: attempted=%d, actual=%d%n", "aeron.socket.so_rcvbuf", Configuration.SOCKET_RCVBUF_LENGTH, maxSoRcvBuf);
            }
            int n = soSndBuf = 0 == Configuration.SOCKET_SNDBUF_LENGTH ? defaultSoSndBuf : Configuration.SOCKET_SNDBUF_LENGTH;
            if (ctx.mtuLength() > soSndBuf) {
                throw new ConfigurationException(String.format("MTU greater than socket SO_SNDBUF, adjust %s to match MTU: mtuLength=%d, SO_SNDBUF=%d", "aeron.socket.so_sndbuf", ctx.mtuLength(), soSndBuf));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("probe socket: " + ex.toString(), ex);
        }
    }

    private static void ensureDirectoryIsRecreated(Context ctx) {
        if (ctx.aeronDirectory().isDirectory()) {
            if (ctx.warnIfDirectoriesExist()) {
                System.err.println("WARNING: " + ctx.aeronDirectory() + " already exists.");
            }
            if (!ctx.dirsDeleteOnStart()) {
                Consumer<String> logProgress = ctx.warnIfDirectoriesExist() ? System.err::println : s -> {};
                MappedByteBuffer cncByteBuffer = ctx.mapExistingCncFile(logProgress);
                try {
                    if (CommonContext.isDriverActive((long)ctx.driverTimeoutMs(), logProgress, (MappedByteBuffer)cncByteBuffer)) {
                        throw new ActiveDriverException("Active driver detected");
                    }
                    MediaDriver.reportExistingErrors(ctx, cncByteBuffer);
                }
                finally {
                    IoUtil.unmap((MappedByteBuffer)cncByteBuffer);
                }
            }
            ctx.deleteAeronDirectory();
        }
        IoUtil.ensureDirectoryExists((File)ctx.aeronDirectory(), (String)"aeron");
    }

    private static void reportExistingErrors(Context ctx, MappedByteBuffer cncByteBuffer) {
        block14: {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int observations = ctx.saveErrorLog(new PrintStream((OutputStream)baos, false, "UTF-8"), cncByteBuffer);
                if (observations <= 0) break block14;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSSZ");
                String errorLogFilename = ctx.aeronDirectoryName() + '-' + dateFormat.format(new Date()) + "-error.log";
                System.err.println("WARNING: Existing errors saved to: " + errorLogFilename);
                try (FileOutputStream out = new FileOutputStream(errorLogFilename);){
                    baos.writeTo(out);
                }
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
        }
    }

    public static class Context
    extends CommonContext {
        private RawLogFactory rawLogFactory;
        private DataTransportPoller dataTransportPoller;
        private ControlTransportPoller controlTransportPoller;
        private FlowControlSupplier unicastFlowControlSupplier;
        private FlowControlSupplier multicastFlowControlSupplier;
        private EpochClock epochClock;
        private NanoClock nanoClock;
        private OneToOneConcurrentArrayQueue<DriverConductorCmd> toConductorFromReceiverCommandQueue;
        private OneToOneConcurrentArrayQueue<DriverConductorCmd> toConductorFromSenderCommandQueue;
        private OneToOneConcurrentArrayQueue<ReceiverCmd> receiverCommandQueue;
        private OneToOneConcurrentArrayQueue<SenderCmd> senderCommandQueue;
        private ReceiverProxy receiverProxy;
        private SenderProxy senderProxy;
        private DriverConductorProxy fromReceiverDriverConductorProxy;
        private DriverConductorProxy fromSenderDriverConductorProxy;
        private IdleStrategy conductorIdleStrategy;
        private IdleStrategy senderIdleStrategy;
        private IdleStrategy receiverIdleStrategy;
        private IdleStrategy sharedNetworkIdleStrategy;
        private IdleStrategy sharedIdleStrategy;
        private ClientProxy clientProxy;
        private RingBuffer toDriverCommands;
        private DistinctErrorLog errorLog;
        private ErrorHandler errorHandler;
        private MappedByteBuffer lossReportBuffer;
        private LossReport lossReport;
        private MappedByteBuffer cncByteBuffer;
        private UnsafeBuffer cncMetaDataBuffer;
        private CountersManager countersManager;
        private SystemCounters systemCounters;
        private long imageLivenessTimeoutNs = Configuration.IMAGE_LIVENESS_TIMEOUT_NS;
        private long clientLivenessTimeoutNs = Configuration.CLIENT_LIVENESS_TIMEOUT_NS;
        private long publicationUnblockTimeoutNs = Configuration.PUBLICATION_UNBLOCK_TIMEOUT_NS;
        private Boolean termBufferSparseFile;
        private int publicationTermBufferLength;
        private int ipcPublicationTermBufferLength;
        private int maxTermBufferLength;
        private int initialWindowLength;
        private long statusMessageTimeout;
        private int mtuLength;
        private boolean warnIfDirectoriesExist;
        private boolean dirsDeleteOnStart;
        private ThreadingMode threadingMode;
        private ThreadFactory conductorThreadFactory;
        private ThreadFactory senderThreadFactory;
        private ThreadFactory receiverThreadFactory;
        private ThreadFactory sharedThreadFactory;
        private ThreadFactory sharedNetworkThreadFactory;
        private SendChannelEndpointSupplier sendChannelEndpointSupplier;
        private ReceiveChannelEndpointSupplier receiveChannelEndpointSupplier;
        private ReceiveChannelEndpointThreadLocals receiveChannelEndpointThreadLocals;
        private byte[] applicationSpecificFeedback = Configuration.SM_APPLICATION_SPECIFIC_FEEDBACK;
        private CongestionControlSupplier congestionControlSupplier;

        public Context() {
            this.publicationTermBufferLength(Configuration.termBufferLength());
            this.maxTermBufferLength(Configuration.maxTermBufferLength());
            this.initialWindowLength(Configuration.initialWindowLength());
            this.statusMessageTimeout(Configuration.statusMessageTimeout());
            this.mtuLength(Configuration.MTU_LENGTH);
            this.warnIfDirectoriesExist = true;
            this.dirsDeleteOnStart(Boolean.getBoolean(MediaDriver.DIRS_DELETE_ON_START_PROP_NAME));
        }

        public Context conclude() {
            super.conclude();
            try {
                this.concludeNullProperties();
                Configuration.validateTermBufferLength(this.maxTermBufferLength);
                Configuration.validateTermBufferLength(this.publicationTermBufferLength);
                Configuration.validateTermBufferLength(this.ipcPublicationTermBufferLength);
                if (this.publicationTermBufferLength > this.maxTermBufferLength) {
                    throw new ConfigurationException(String.format("publication term buffer length %d greater than max length %d", this.publicationTermBufferLength, this.maxTermBufferLength));
                }
                if (this.ipcPublicationTermBufferLength > this.maxTermBufferLength) {
                    throw new ConfigurationException(String.format("IPC publication term buffer length %d greater than max length %d", this.ipcPublicationTermBufferLength, this.maxTermBufferLength));
                }
                Configuration.validateInitialWindowLength(this.initialWindowLength(), this.mtuLength());
                this.cncByteBuffer = IoUtil.mapNewFile((File)this.cncFile(), (long)CncFileDescriptor.computeCncFileLength((int)(Configuration.CONDUCTOR_BUFFER_LENGTH + Configuration.TO_CLIENTS_BUFFER_LENGTH + Configuration.COUNTERS_METADATA_BUFFER_LENGTH + Configuration.COUNTERS_VALUES_BUFFER_LENGTH + Configuration.ERROR_BUFFER_LENGTH)));
                this.cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer((ByteBuffer)this.cncByteBuffer);
                CncFileDescriptor.fillMetaData((UnsafeBuffer)this.cncMetaDataBuffer, (int)Configuration.CONDUCTOR_BUFFER_LENGTH, (int)Configuration.TO_CLIENTS_BUFFER_LENGTH, (int)Configuration.COUNTERS_METADATA_BUFFER_LENGTH, (int)Configuration.COUNTERS_VALUES_BUFFER_LENGTH, (long)this.clientLivenessTimeoutNs, (int)Configuration.ERROR_BUFFER_LENGTH);
                BroadcastTransmitter transmitter = new BroadcastTransmitter((AtomicBuffer)CncFileDescriptor.createToClientsBuffer((ByteBuffer)this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
                this.clientProxy(new ClientProxy(transmitter));
                this.toDriverCommands((RingBuffer)new ManyToOneRingBuffer((AtomicBuffer)CncFileDescriptor.createToDriverBuffer((ByteBuffer)this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer)));
                if (null == this.errorLog) {
                    this.errorLog = new DistinctErrorLog((AtomicBuffer)CncFileDescriptor.createErrorLogBuffer((ByteBuffer)this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer), this.epochClock);
                }
                if (null == this.errorHandler) {
                    this.errorHandler = throwable -> {
                        if (!this.errorLog.record(throwable)) {
                            System.err.println("Error Log is full, consider increasing aeron.error.buffer.length");
                            throwable.printStackTrace(System.err);
                        }
                    };
                }
                this.concludeCounters();
                this.receiverProxy(new ReceiverProxy(this.threadingMode, (Queue<ReceiverCmd>)this.receiverCommandQueue(), this.systemCounters.get(SystemCounterDescriptor.RECEIVER_PROXY_FAILS)));
                this.senderProxy(new SenderProxy(this.threadingMode, (Queue<SenderCmd>)this.senderCommandQueue(), this.systemCounters.get(SystemCounterDescriptor.SENDER_PROXY_FAILS)));
                this.fromReceiverDriverConductorProxy(new DriverConductorProxy(this.threadingMode, (Queue<DriverConductorCmd>)this.toConductorFromReceiverCommandQueue, this.systemCounters.get(SystemCounterDescriptor.CONDUCTOR_PROXY_FAILS)));
                this.fromSenderDriverConductorProxy(new DriverConductorProxy(this.threadingMode, (Queue<DriverConductorCmd>)this.toConductorFromSenderCommandQueue, this.systemCounters.get(SystemCounterDescriptor.CONDUCTOR_PROXY_FAILS)));
                this.rawLogBuffersFactory(new RawLogFactory(this.aeronDirectoryName(), this.maxTermBufferLength, this.termBufferSparseFile, this.errorLog));
                if (null == this.lossReport) {
                    this.lossReportBuffer = LossReportUtil.mapLossReport(this.aeronDirectoryName(), Configuration.LOSS_REPORT_BUFFER_LENGTH);
                    this.lossReport = new LossReport((AtomicBuffer)new UnsafeBuffer((ByteBuffer)this.lossReportBuffer));
                }
                this.concludeIdleStrategies();
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
            return this;
        }

        private void concludeNullProperties() {
            if (null == this.epochClock) {
                this.epochClock = new SystemEpochClock();
            }
            if (null == this.nanoClock) {
                this.nanoClock = new SystemNanoClock();
            }
            if (null == this.threadingMode) {
                this.threadingMode = Configuration.THREADING_MODE_DEFAULT;
            }
            if (null == this.unicastFlowControlSupplier) {
                this.unicastFlowControlSupplier = Configuration.unicastFlowControlSupplier();
            }
            if (null == this.multicastFlowControlSupplier) {
                this.multicastFlowControlSupplier = Configuration.multicastFlowControlSupplier();
            }
            if (0 == this.ipcPublicationTermBufferLength) {
                this.ipcPublicationTermBufferLength = Configuration.ipcTermBufferLength(this.publicationTermBufferLength());
            }
            if (null == this.sendChannelEndpointSupplier) {
                this.sendChannelEndpointSupplier = Configuration.sendChannelEndpointSupplier();
            }
            if (null == this.receiveChannelEndpointSupplier) {
                this.receiveChannelEndpointSupplier = Configuration.receiveChannelEndpointSupplier();
            }
            if (null == this.dataTransportPoller) {
                this.dataTransportPoller = new DataTransportPoller();
            }
            if (null == this.controlTransportPoller) {
                this.controlTransportPoller = new ControlTransportPoller();
            }
            if (null == this.termBufferSparseFile) {
                this.termBufferSparseFile = null != Configuration.TERM_BUFFER_SPARSE_FILE ? Boolean.valueOf(Configuration.TERM_BUFFER_SPARSE_FILE) : Boolean.FALSE;
            }
            if (null == this.conductorThreadFactory) {
                this.conductorThreadFactory = Thread::new;
            }
            if (null == this.senderThreadFactory) {
                this.senderThreadFactory = Thread::new;
            }
            if (null == this.receiverThreadFactory) {
                this.receiverThreadFactory = Thread::new;
            }
            if (null == this.sharedThreadFactory) {
                this.sharedThreadFactory = Thread::new;
            }
            if (null == this.sharedNetworkThreadFactory) {
                this.sharedNetworkThreadFactory = Thread::new;
            }
            if (null == this.receiveChannelEndpointThreadLocals) {
                this.receiveChannelEndpointThreadLocals = new ReceiveChannelEndpointThreadLocals(this);
            }
            if (null == this.congestionControlSupplier) {
                this.congestionControlSupplier = Configuration.congestionControlSupplier();
            }
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public Context nanoClock(NanoClock clock) {
            this.nanoClock = clock;
            return this;
        }

        public Context toConductorFromReceiverCommandQueue(OneToOneConcurrentArrayQueue<DriverConductorCmd> queue) {
            this.toConductorFromReceiverCommandQueue = queue;
            return this;
        }

        public Context toConductorFromSenderCommandQueue(OneToOneConcurrentArrayQueue<DriverConductorCmd> queue) {
            this.toConductorFromSenderCommandQueue = queue;
            return this;
        }

        public Context rawLogBuffersFactory(RawLogFactory rawLogFactory) {
            this.rawLogFactory = rawLogFactory;
            return this;
        }

        public Context dataTransportPoller(DataTransportPoller transportPoller) {
            this.dataTransportPoller = transportPoller;
            return this;
        }

        public Context controlTransportPoller(ControlTransportPoller transportPoller) {
            this.controlTransportPoller = transportPoller;
            return this;
        }

        public Context unicastFlowControlSupplier(FlowControlSupplier senderFlowControl) {
            this.unicastFlowControlSupplier = senderFlowControl;
            return this;
        }

        public Context multicastFlowControlSupplier(FlowControlSupplier senderFlowControl) {
            this.multicastFlowControlSupplier = senderFlowControl;
            return this;
        }

        public Context receiverCommandQueue(OneToOneConcurrentArrayQueue<ReceiverCmd> receiverCommandQueue) {
            this.receiverCommandQueue = receiverCommandQueue;
            return this;
        }

        public Context senderCommandQueue(OneToOneConcurrentArrayQueue<SenderCmd> senderCommandQueue) {
            this.senderCommandQueue = senderCommandQueue;
            return this;
        }

        public Context receiverProxy(ReceiverProxy receiverProxy) {
            this.receiverProxy = receiverProxy;
            return this;
        }

        public Context senderProxy(SenderProxy senderProxy) {
            this.senderProxy = senderProxy;
            return this;
        }

        public Context fromReceiverDriverConductorProxy(DriverConductorProxy driverConductorProxy) {
            this.fromReceiverDriverConductorProxy = driverConductorProxy;
            return this;
        }

        public Context fromSenderDriverConductorProxy(DriverConductorProxy driverConductorProxy) {
            this.fromSenderDriverConductorProxy = driverConductorProxy;
            return this;
        }

        public Context conductorIdleStrategy(IdleStrategy strategy) {
            this.conductorIdleStrategy = strategy;
            return this;
        }

        public Context senderIdleStrategy(IdleStrategy strategy) {
            this.senderIdleStrategy = strategy;
            return this;
        }

        public Context receiverIdleStrategy(IdleStrategy strategy) {
            this.receiverIdleStrategy = strategy;
            return this;
        }

        public Context sharedNetworkIdleStrategy(IdleStrategy strategy) {
            this.sharedNetworkIdleStrategy = strategy;
            return this;
        }

        public Context sharedIdleStrategy(IdleStrategy strategy) {
            this.sharedIdleStrategy = strategy;
            return this;
        }

        public Context clientProxy(ClientProxy clientProxy) {
            this.clientProxy = clientProxy;
            return this;
        }

        public Context toDriverCommands(RingBuffer toDriverCommands) {
            this.toDriverCommands = toDriverCommands;
            return this;
        }

        public Context countersManager(CountersManager countersManager) {
            this.countersManager = countersManager;
            return this;
        }

        public Context termBufferSparseFile(Boolean termBufferSparseFile) {
            this.termBufferSparseFile = termBufferSparseFile;
            return this;
        }

        public Context publicationTermBufferLength(int termBufferLength) {
            this.publicationTermBufferLength = termBufferLength;
            return this;
        }

        public Context maxTermBufferLength(int maxTermBufferLength) {
            this.maxTermBufferLength = maxTermBufferLength;
            return this;
        }

        public Context ipcTermBufferLength(int ipcTermBufferLength) {
            this.ipcPublicationTermBufferLength = ipcTermBufferLength;
            return this;
        }

        public Context initialWindowLength(int initialWindowLength) {
            this.initialWindowLength = initialWindowLength;
            return this;
        }

        public Context statusMessageTimeout(long statusMessageTimeout) {
            this.statusMessageTimeout = statusMessageTimeout;
            return this;
        }

        public Context warnIfDirectoriesExist(boolean value) {
            this.warnIfDirectoriesExist = value;
            return this;
        }

        public Context errorLog(DistinctErrorLog errorLog) {
            this.errorLog = errorLog;
            return this;
        }

        public Context lossReport(LossReport lossReport) {
            this.lossReport = lossReport;
            return this;
        }

        public Context imageLivenessTimeoutNs(long timeout) {
            this.imageLivenessTimeoutNs = timeout;
            return this;
        }

        public Context clientLivenessTimeoutNs(long timeout) {
            this.clientLivenessTimeoutNs = timeout;
            return this;
        }

        public Context publicationUnblockTimeoutNs(long timeout) {
            this.publicationUnblockTimeoutNs = timeout;
            return this;
        }

        public Context systemCounters(SystemCounters systemCounters) {
            this.systemCounters = systemCounters;
            return this;
        }

        public Context threadingMode(ThreadingMode threadingMode) {
            this.threadingMode = threadingMode;
            return this;
        }

        public Context senderThreadFactory(ThreadFactory factory) {
            this.senderThreadFactory = factory;
            return this;
        }

        public Context receiverThreadFactory(ThreadFactory factory) {
            this.receiverThreadFactory = factory;
            return this;
        }

        public Context conductorThreadFactory(ThreadFactory factory) {
            this.conductorThreadFactory = factory;
            return this;
        }

        public Context sharedThreadFactory(ThreadFactory factory) {
            this.sharedThreadFactory = factory;
            return this;
        }

        public Context sharedNetworkThreadFactory(ThreadFactory factory) {
            this.sharedNetworkThreadFactory = factory;
            return this;
        }

        public Context dirsDeleteOnStart(boolean dirsDeleteOnStart) {
            this.dirsDeleteOnStart = dirsDeleteOnStart;
            return this;
        }

        public Context aeronDirectoryName(String dirName) {
            super.aeronDirectoryName(dirName);
            return this;
        }

        public Context sendChannelEndpointSupplier(SendChannelEndpointSupplier supplier) {
            this.sendChannelEndpointSupplier = supplier;
            return this;
        }

        public Context receiveChannelEndpointSupplier(ReceiveChannelEndpointSupplier supplier) {
            this.receiveChannelEndpointSupplier = supplier;
            return this;
        }

        public Context receiveChannelEndpointThreadLocals(ReceiveChannelEndpointThreadLocals threadLocals) {
            this.receiveChannelEndpointThreadLocals = threadLocals;
            return this;
        }

        public Context applicationSpecificFeedback(byte[] bytes) {
            this.applicationSpecificFeedback = bytes;
            return this;
        }

        public Context congestControlSupplier(CongestionControlSupplier supplier) {
            this.congestionControlSupplier = supplier;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public NanoClock nanoClock() {
            return this.nanoClock;
        }

        public OneToOneConcurrentArrayQueue<DriverConductorCmd> toConductorFromReceiverCommandQueue() {
            return this.toConductorFromReceiverCommandQueue;
        }

        public OneToOneConcurrentArrayQueue<DriverConductorCmd> toConductorFromSenderCommandQueue() {
            return this.toConductorFromSenderCommandQueue;
        }

        public RawLogFactory rawLogBuffersFactory() {
            return this.rawLogFactory;
        }

        public DataTransportPoller dataTransportPoller() {
            return this.dataTransportPoller;
        }

        public ControlTransportPoller controlTransportPoller() {
            return this.controlTransportPoller;
        }

        public FlowControlSupplier unicastFlowControlSupplier() {
            return this.unicastFlowControlSupplier;
        }

        public FlowControlSupplier multicastFlowControlSupplier() {
            return this.multicastFlowControlSupplier;
        }

        public OneToOneConcurrentArrayQueue<ReceiverCmd> receiverCommandQueue() {
            return this.receiverCommandQueue;
        }

        public OneToOneConcurrentArrayQueue<SenderCmd> senderCommandQueue() {
            return this.senderCommandQueue;
        }

        public ReceiverProxy receiverProxy() {
            return this.receiverProxy;
        }

        public SenderProxy senderProxy() {
            return this.senderProxy;
        }

        public DriverConductorProxy fromReceiverDriverConductorProxy() {
            return this.fromReceiverDriverConductorProxy;
        }

        public DriverConductorProxy fromSenderDriverConductorProxy() {
            return this.fromSenderDriverConductorProxy;
        }

        public IdleStrategy conductorIdleStrategy() {
            return this.conductorIdleStrategy;
        }

        public IdleStrategy senderIdleStrategy() {
            return this.senderIdleStrategy;
        }

        public IdleStrategy receiverIdleStrategy() {
            return this.receiverIdleStrategy;
        }

        public IdleStrategy sharedNetworkIdleStrategy() {
            return this.sharedNetworkIdleStrategy;
        }

        public IdleStrategy sharedIdleStrategy() {
            return this.sharedIdleStrategy;
        }

        public ThreadFactory senderThreadFactory() {
            return this.senderThreadFactory;
        }

        public ThreadFactory receiverThreadFactory() {
            return this.receiverThreadFactory;
        }

        public ThreadFactory conductorThreadFactory() {
            return this.conductorThreadFactory;
        }

        public ThreadFactory sharedThreadFactory() {
            return this.sharedThreadFactory;
        }

        public ThreadFactory sharedNetworkThreadFactory() {
            return this.sharedNetworkThreadFactory;
        }

        public ClientProxy clientProxy() {
            return this.clientProxy;
        }

        public RingBuffer toDriverCommands() {
            return this.toDriverCommands;
        }

        public CountersManager countersManager() {
            return this.countersManager;
        }

        public long imageLivenessTimeoutNs() {
            return this.imageLivenessTimeoutNs;
        }

        public long clientLivenessTimeoutNs() {
            return this.clientLivenessTimeoutNs;
        }

        public long publicationUnblockTimeoutNs() {
            return this.publicationUnblockTimeoutNs;
        }

        public int publicationTermBufferLength() {
            return this.publicationTermBufferLength;
        }

        public int maxTermBufferLength() {
            return this.maxTermBufferLength;
        }

        public int ipcTermBufferLength() {
            return this.ipcPublicationTermBufferLength;
        }

        public int initialWindowLength() {
            return this.initialWindowLength;
        }

        public long statusMessageTimeout() {
            return this.statusMessageTimeout;
        }

        public boolean warnIfDirectoriesExist() {
            return this.warnIfDirectoriesExist;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public DistinctErrorLog errorLog() {
            return this.errorLog;
        }

        public LossReport lossReport() {
            return this.lossReport;
        }

        public int mtuLength() {
            return this.mtuLength;
        }

        public CommonContext mtuLength(int mtuLength) {
            Configuration.validateMtuLength(mtuLength);
            this.mtuLength = mtuLength;
            return this;
        }

        public SystemCounters systemCounters() {
            return this.systemCounters;
        }

        public boolean dirsDeleteOnStart() {
            return this.dirsDeleteOnStart;
        }

        public SendChannelEndpointSupplier sendChannelEndpointSupplier() {
            return this.sendChannelEndpointSupplier;
        }

        public ReceiveChannelEndpointSupplier receiveChannelEndpointSupplier() {
            return this.receiveChannelEndpointSupplier;
        }

        public ReceiveChannelEndpointThreadLocals receiveChannelEndpointThreadLocals() {
            return this.receiveChannelEndpointThreadLocals;
        }

        public byte[] applicationSpecificFeedback() {
            return this.applicationSpecificFeedback;
        }

        public CongestionControlSupplier congestionControlSupplier() {
            return this.congestionControlSupplier;
        }

        public void close() {
            IoUtil.unmap((MappedByteBuffer)this.cncByteBuffer);
            IoUtil.unmap((MappedByteBuffer)this.lossReportBuffer);
            super.close();
        }

        private void concludeCounters() {
            if (this.countersManager() == null) {
                if (this.countersMetaDataBuffer() == null) {
                    this.countersMetaDataBuffer(CncFileDescriptor.createCountersMetaDataBuffer((ByteBuffer)this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
                }
                if (this.countersValuesBuffer() == null) {
                    this.countersValuesBuffer(CncFileDescriptor.createCountersValuesBuffer((ByteBuffer)this.cncByteBuffer, (DirectBuffer)this.cncMetaDataBuffer));
                }
                this.countersManager(new CountersManager((AtomicBuffer)this.countersMetaDataBuffer(), (AtomicBuffer)this.countersValuesBuffer()));
            }
            if (null == this.systemCounters) {
                this.systemCounters = new SystemCounters(this.countersManager);
            }
        }

        private void concludeIdleStrategies() {
            UnsafeBufferStatusIndicator controllableIdleStrategyStatus = new UnsafeBufferStatusIndicator(this.countersManager.valuesBuffer(), SystemCounterDescriptor.CONTROLLABLE_IDLE_STRATEGY.id());
            if (null == this.conductorIdleStrategy) {
                this.conductorIdleStrategy(Configuration.conductorIdleStrategy((StatusIndicator)controllableIdleStrategyStatus));
            }
            if (null == this.senderIdleStrategy) {
                this.senderIdleStrategy(Configuration.senderIdleStrategy((StatusIndicator)controllableIdleStrategyStatus));
            }
            if (null == this.receiverIdleStrategy) {
                this.receiverIdleStrategy(Configuration.receiverIdleStrategy((StatusIndicator)controllableIdleStrategyStatus));
            }
            if (null == this.sharedNetworkIdleStrategy) {
                this.sharedNetworkIdleStrategy(Configuration.sharedNetworkIdleStrategy((StatusIndicator)controllableIdleStrategyStatus));
            }
            if (null == this.sharedIdleStrategy) {
                this.sharedIdleStrategy(Configuration.sharedIdleStrategy((StatusIndicator)controllableIdleStrategyStatus));
            }
        }
    }
}

