/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.core.api.DeployfileService;
import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.deployfile.DirectorySpec;
import com.xebialabs.deployit.deployfile.ForDirectories;
import com.xebialabs.deployit.deployfile.XldSpec;
import com.xebialabs.deployit.deployfile.execute.CiCommand;
import com.xebialabs.deployit.deployfile.execute.CiCommandCreator;
import com.xebialabs.deployit.deployfile.execute.CommandExecutor;
import com.xebialabs.deployit.deployfile.execute.DeleteCiCommand;
import com.xebialabs.deployit.deployfile.execute.DeployfileCommand;
import com.xebialabs.deployit.deployfile.execute.DeployfileExecutor;
import com.xebialabs.deployit.deployfile.execute.DeployfileResolver;
import com.xebialabs.deployit.deployfile.export.DeployfileGenerator;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.security.permission.DeployitPermissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.service.validation.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Controller
@ScalaSignature(bytes="\u0006\u0001\tUa\u0001B\u0001\u0003\u00015\u0011!\u0003R3qY>Lh-\u001b7f%\u0016\u001cx.\u001e:dK*\u00111\u0001B\u0001\u0005e\u0016\u001cHO\u0003\u0002\u0006\r\u0005!1m\u001c:f\u0015\t9\u0001\"\u0001\u0005eKBdw._5u\u0015\tI!\"A\u0005yK\nL\u0017\r\\1cg*\t1\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ!!\u0005\u0002\u0002\u000fM,7-\u001e:fI&\u00111\u0003\u0005\u0002\u0018\u0003\n\u001cHO]1diN+7-\u001e:fIJ+7o\\;sG\u0016\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002\u001a-\t\tB)\u001a9m_f4\u0017\u000e\\3TKJ4\u0018nY3\t\u0011m\u0001!\u0011!Q\u0001\nq\t\u0011C]3q_NLGo\u001c:z'\u0016\u0014h/[2f!\ti\u0002%D\u0001\u001f\u0015\tyb!\u0001\u0006sKB|7/\u001b;pefL!!\t\u0010\u0003#I+\u0007o\\:ji>\u0014\u0018pU3sm&\u001cW\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003M!W\r\u001d7ps\u001aLG.Z$f]\u0016\u0014\u0018\r^8s!\t)#&D\u0001'\u0015\t9\u0003&\u0001\u0004fqB|'\u000f\u001e\u0006\u0003S\u0019\t!\u0002Z3qY>Lh-\u001b7f\u0013\tYcEA\nEKBdw.\u001f4jY\u0016<UM\\3sCR|'\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003I!W\r\u001d7ps\u001aLG.Z#yK\u000e,Ho\u001c:\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005EB\u0013aB3yK\u000e,H/Z\u0005\u0003gA\u0012!\u0003R3qY>Lh-\u001b7f\u000bb,7-\u001e;pe\"AQ\u0007\u0001B\u0001B\u0003%a'\u0001\neKBdw.\u001f4jY\u0016\u0014Vm]8mm\u0016\u0014\bCA\u00188\u0013\tA\u0004G\u0001\nEKBdw.\u001f4jY\u0016\u0014Vm]8mm\u0016\u0014\b\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\u0002\u001d\r|W.\\1oI\u000e\u0013X-\u0019;peB\u0011q\u0006P\u0005\u0003{A\u0012\u0001cQ5D_6l\u0017M\u001c3De\u0016\fGo\u001c:\t\u0011}\u0002!\u0011!Q\u0001\n\u0001\u000bqbY8n[\u0006tG-\u0012=fGV$xN\u001d\t\u0003_\u0005K!A\u0011\u0019\u0003\u001f\r{W.\\1oI\u0016CXmY;u_JD\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!R\u0001\nm\u0006d\u0017\u000eZ1u_J\u0004\"AR&\u000e\u0003\u001dS!\u0001S%\u0002\u0015Y\fG.\u001b3bi&|gN\u0003\u0002K\r\u000591/\u001a:wS\u000e,\u0017B\u0001'H\u0005%1\u0016\r\\5eCR|'\u000fC\u0003O\u0001\u0011\u0005q*\u0001\u0004=S:LGO\u0010\u000b\t!J\u001bF+\u0016,X1B\u0011\u0011\u000bA\u0007\u0002\u0005!)1$\u0014a\u00019!)1%\u0014a\u0001I!)Q&\u0014a\u0001]!)Q'\u0014a\u0001m!)!(\u0014a\u0001w!)q(\u0014a\u0001\u0001\")A)\u0014a\u0001\u000b\"\u0012QJ\u0017\t\u00037\u001al\u0011\u0001\u0018\u0006\u0003;z\u000b!\"\u00198o_R\fG/[8o\u0015\ty\u0006-A\u0004gC\u000e$xN]=\u000b\u0005\u0005\u0014\u0017!\u00022fC:\u001c(BA2e\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A3\u0002\u0007=\u0014x-\u0003\u0002h9\nI\u0011)\u001e;po&\u0014X\r\u001a\u0005\u0006S\u0002!\tE[\u0001\tO\u0016tWM]1uKR\u00111\u000e\u001f\t\u0003YVt!!\\:\u0011\u00059\fX\"A8\u000b\u0005Ad\u0011A\u0002\u001fs_>$hHC\u0001s\u0003\u0015\u00198-\u00197b\u0013\t!\u0018/\u0001\u0004Qe\u0016$WMZ\u0005\u0003m^\u0014aa\u0015;sS:<'B\u0001;r\u0011\u0015I\b\u000e1\u0001{\u0003\u001d1w\u000e\u001c3feN\u0004Ba_A\u0001W6\tAP\u0003\u0002~}\u0006!Q\u000f^5m\u0015\u0005y\u0018\u0001\u00026bm\u0006L1!a\u0001}\u0005\u0011a\u0015n\u001d;\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n\u0005)\u0011\r\u001d9msR!\u00111BA\n!\u0011\ti!a\u0004\u000e\u0003EL1!!\u0005r\u0005\u0011)f.\u001b;\t\u000f\u0005U\u0011Q\u0001a\u0001W\u0006QA-\u001a9m_f4\u0015\u000e\\3\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\u001aQ!\u00111BA\u000e\u0011!\ti\"a\u0006A\u0002\u0005}\u0011\u0001\u00034pe6$\u0015\r^1\u0011\t\u0005\u0005\u0012qG\u0007\u0003\u0003GQA!!\n\u0002(\u0005IQ.\u001e7uSB\f'\u000f\u001e\u0006\u0005\u0003S\tY#A\u0005qe>4\u0018\u000eZ3sg*!\u0011QFA\u0018\u0003\u001d\u0001H.^4j]NTA!!\r\u00024\u0005A!/Z:uK\u0006\u001c\u0018PC\u0002\u00026\u0011\fQA\u001b2pgNLA!!\u000f\u0002$\t1R*\u001e7uSB\f'\u000f\u001e$pe6$\u0015\r^1J]B,H\u000fC\u0004\u0002>\u0001!I!a\u0010\u0002\u000f\u0011|\u0017\t\u001d9msR1\u00111BA!\u0003\u0007Bq!!\u0006\u0002<\u0001\u00071\u000e\u0003\u0005\u0002F\u0005m\u0002\u0019AA$\u0003%\t'\u000f^5gC\u000e$8\u000f\u0005\u0004\u0002J\u0005M\u0013\u0011\f\b\u0005\u0003\u0017\nyED\u0002o\u0003\u001bJ\u0011A]\u0005\u0004\u0003#\n\u0018a\u00029bG.\fw-Z\u0005\u0005\u0003+\n9FA\u0002TKFT1!!\u0015r!\u0011\t\t#a\u0017\n\t\u0005u\u00131\u0005\u0002\n\u0013:\u0004X\u000f\u001e)beRDq!!\u0019\u0001\t\u0003\t\u0019'\u0001\rdQ\u0016\u001c7nQ8oI&$\u0018n\u001c8P]bcGm\u00159fGN$b!a\u0003\u0002f\u0005m\u0004\u0002CA4\u0003?\u0002\r!!\u001b\u0002\u0013\r|g\u000eZ5uS>t\u0007\u0003CA\u0007\u0003W\ny'a\u0003\n\u0007\u00055\u0014OA\u0005Gk:\u001cG/[8ocA1\u0011\u0011JA9\u0003gJA!a\u0001\u0002XA!\u0011QOA<\u001b\u0005A\u0013bAA=Q\tiA)\u001b:fGR|'/_*qK\u000eD\u0001\"! \u0002`\u0001\u0007\u0011qP\u0001\tq2$7\u000b]3dgB1\u0011\u0011JA9\u0003\u0003\u0003B!!\u001e\u0002\u0004&\u0019\u0011Q\u0011\u0015\u0003\u000facGm\u00159fG\"9\u0011\u0011\u0012\u0001\u0005\u0002\u0005-\u0015!H2iK\u000e\\\u0007+\u001a:nSN\u001c\u0018n\u001c8G_J$\u0015N]3di>\u0014\u0018.Z:\u0015\t\u0005-\u0011Q\u0012\u0005\t\u0003\u001f\u000b9\t1\u0001\u0002p\u0005!A-\u001b:t\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+\u000b1d\u00195fG.\u0004VM]7jgNLwN\u001c$pe\u0012K'/Z2u_JLH\u0003BA\u0006\u0003/C\u0001\"!'\u0002\u0012\u0002\u0007\u00111O\u0001\u0004I&\u0014\bbBAO\u0001\u0011\u0005\u0011qT\u0001\u001fG\",7m[*fGV\u0014\u0018\u000e^=QKJl\u0017n]:j_:4uN]+tKJ$B!a\u0003\u0002\"\"A\u0011qRAN\u0001\u0004\ty\u0007C\u0004\u0002&\u0002!I!a*\u0002\u0019\r\f7\u000f^!oI\u000eCWmY6\u0016\t\u0005%\u0016q\u0016\u000b\u0007\u0003W\u000bi-!5\u0011\t\u00055\u0016q\u0016\u0007\u0001\t!\t\t,a)C\u0002\u0005M&!\u0001+\u0012\t\u0005U\u00161\u0018\t\u0005\u0003\u001b\t9,C\u0002\u0002:F\u0014qAT8uQ&tw\r\u0005\u0003\u0002>\u0006%WBAA`\u0015\u0011\t\t-a1\u0002\u0007U$WNC\u0002\u0018\u0003\u000bT1!a2\u0007\u0003\u0019\u0001H.^4j]&!\u00111ZA`\u0005E\u0019uN\u001c4jOV\u0014\u0018\r^5p]&#X-\u001c\u0005\t\u0003\u001f\f\u0019\u000b1\u0001\u0002<\u0006\u00111-\u001b\u0005\t\u0003'\f\u0019\u000b1\u0001\u0002V\u0006)1\r\\1{uB)A.a6\u0002,&\u0019\u0011\u0011\\<\u0003\u000b\rc\u0017m]:\t\u0019\u0005u\u0007\u0001%A\u0001\u0002\u0003%\t!a8\u00023A\u0014x\u000e^3di\u0016$Ge\u00195fG.\u0004VM]7jgNLwN\u001c\u000b\u0005\u0003C\u0014)\u0001\u0006\u0004\u0002\f\u0005\r\u0018q\u001f\u0005\u000b\u0003K\fY.!AA\u0002\u0005\u001d\u0018a\u0001=%cA!\u0011\u0011^Az\u001b\t\tYO\u0003\u0003\u0002n\u0006=\u0018A\u00039fe6L7o]5p]*\u0019\u0011\u0011\u001f\u0004\u0002\u0011M,7-\u001e:jifLA!!>\u0002l\nQ\u0001+\u001a:nSN\u001c\u0018n\u001c8\t\u0015\u0005e\u00181\\A\u0001\u0002\u0004\tY0A\u0002yII\u0002B!!@\u0003\u00045\u0011\u0011q \u0006\u0004\u0005\u0003q\u0018\u0001\u00027b]\u001eL1A^A\u0000\u0011%\t)/a7\u0002\u0002\u0003\u0007\u0001\u000bK\u0002\u0001\u0005\u0013\u0001BAa\u0003\u0003\u00125\u0011!Q\u0002\u0006\u0004\u0005\u001f\u0011\u0017AC:uKJ,w\u000e^=qK&!!1\u0003B\u0007\u0005)\u0019uN\u001c;s_2dWM\u001d")
public class DeployfileResource
extends AbstractSecuredResource
implements DeployfileService {
    private final RepositoryService repositoryService;
    private final DeployfileGenerator deployfileGenerator;
    private final DeployfileExecutor deployfileExecutor;
    private final DeployfileResolver deployfileResolver;
    private final CiCommandCreator commandCreator;
    private final CommandExecutor commandExecutor;
    private final Validator validator;

    public /* synthetic */ void protected$checkPermission(DeployfileResource x$1, Permission x$12, String x$2) {
        x$1.checkPermission(x$12, x$2);
    }

    public String generate(java.util.List<String> folders) {
        ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(folders).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.protected$checkPermission(this, DeployitPermissions.GENERATE_DEPLOY_FILE, x$1);
            return BoxedUnit.UNIT;
        });
        List directories = ((TraversableOnce)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(this.repositoryService.read(folders, 0, false)).map((Function1 & Serializable & scala.Serializable)x$2 -> this.castAndCheck((ConfigurationItem)x$2, (Class)Directory.class), Buffer$.MODULE$.canBuildFrom())).toList();
        return this.deployfileGenerator.generate((List<Directory>)directories);
    }

    public void apply(String deployFile) {
        Checks.checkNotNull((Object)deployFile, (String)"deployFile");
        this.doApply(deployFile, (Seq<InputPart>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public void apply(MultipartFormDataInput formData) {
        Map dataMap = formData.getFormDataMap();
        java.util.List deployFile = (java.util.List)dataMap.get("deployFile");
        Checks.checkNotNull((Object)deployFile, (String)"deployFile");
        this.doApply(((InputPart)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(deployFile).head()).getBodyAsString(), (Seq<InputPart>)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer((java.util.List)dataMap.get("artifacts")));
        formData.close();
    }

    private void doApply(String deployFile, Seq<InputPart> artifacts) {
        List<XldSpec> xldSpecs = this.deployfileExecutor.execute(deployFile);
        this.checkConditionOnXldSpecs((Function1<List<DirectorySpec>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dirs -> {
            this.checkPermissionForDirectories((List<DirectorySpec>)dirs);
            return BoxedUnit.UNIT;
        }, xldSpecs);
        this.checkConditionOnXldSpecs((Function1<List<DirectorySpec>, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dirs -> {
            this.checkSecurityPermissionForUser((List<DirectorySpec>)dirs);
            return BoxedUnit.UNIT;
        }, xldSpecs);
        List commands = (List)xldSpecs.flatMap((Function1 & Serializable & scala.Serializable)spec -> {
            $this.deployfileResolver.resolveApplications((XldSpec)spec, artifacts);
            $this.deployfileResolver.resolveDefinitionsRef((XldSpec)spec);
            return $this.commandCreator.create((XldSpec)spec);
        }, List$.MODULE$.canBuildFrom());
        this.validator.validateCis(new ArrayList(ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)commands.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            DeployfileCommand deployfileCommand = x0$1;
            if (deployfileCommand instanceof DeleteCiCommand) {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else if (deployfileCommand instanceof CiCommand) {
                CiCommand ciCommand = (CiCommand)deployfileCommand;
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)ciCommand.ci()));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, List$.MODULE$.canBuildFrom()))));
        this.commandExecutor.execute((List<DeployfileCommand>)commands);
    }

    public void checkConditionOnXldSpecs(Function1<List<DirectorySpec>, BoxedUnit> condition, List<XldSpec> xldSpecs) {
        ((List)((List)xldSpecs.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(x$3.getDefinitions()), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getForDirectories(), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)dirs -> {
            DeployfileResource.$anonfun$checkConditionOnXldSpecs$3(condition, dirs);
            return BoxedUnit.UNIT;
        });
    }

    public void checkPermissionForDirectories(List<DirectorySpec> dirs) {
        dirs.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            this.checkPermissionForDirectory(dir);
            return BoxedUnit.UNIT;
        });
    }

    public void checkPermissionForDirectory(DirectorySpec dir) {
        block0: {
            if (dir.getId() == null) break block0;
            String idToCheck = this.repositoryService.exists(dir.getId()) ? dir.getId() : JcrPathHelper.getParentId((String)dir.getId());
            this.checkPermission(PlatformPermissions.EDIT_REPO, idToCheck);
        }
    }

    public void checkSecurityPermissionForUser(List<DirectorySpec> dirs) {
        block0: {
            if (!((TraversableOnce)dirs.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getPermissions(), List$.MODULE$.canBuildFrom())).nonEmpty()) break block0;
            this.checkPermission(PlatformPermissions.EDIT_SECURITY);
        }
    }

    private <T extends ConfigurationItem> T castAndCheck(ConfigurationItem ci, Class<T> clazz) {
        Checks.checkArgument((boolean)clazz.isAssignableFrom(ci.getClass()), (String)"%s is not a %s", (Object[])new Object[]{ci, clazz.getSimpleName()});
        return (T)((ConfigurationItem)clazz.cast(ci));
    }

    public static final /* synthetic */ void $anonfun$checkConditionOnXldSpecs$3(Function1 condition$1, ForDirectories dirs) {
        List list = Option$.MODULE$.apply((Object)dirs.getForEnvironments()).toList();
        List specs = Option$.MODULE$.apply((Object)dirs.getForInfrastructure()).toList().$colon$colon$colon(list);
        condition$1.apply((Object)specs);
    }

    @Autowired
    public DeployfileResource(RepositoryService repositoryService, DeployfileGenerator deployfileGenerator, DeployfileExecutor deployfileExecutor, DeployfileResolver deployfileResolver, CiCommandCreator commandCreator, CommandExecutor commandExecutor, Validator validator) {
        this.repositoryService = repositoryService;
        this.deployfileGenerator = deployfileGenerator;
        this.deployfileExecutor = deployfileExecutor;
        this.deployfileResolver = deployfileResolver;
        this.commandCreator = commandCreator;
        this.commandExecutor = commandExecutor;
        this.validator = validator;
    }
}

