/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.line;

import org.crsh.cli.impl.line.LineParser;
import org.crsh.cli.impl.line.Quoting;

public class MultiLineVisitor
extends LineParser.Visitor {
    private final StringBuilder raw = new StringBuilder();

    public String getRaw() {
        return this.raw.toString();
    }

    @Override
    public void openStrongQuote(int index) {
        this.raw.append('\'');
    }

    @Override
    public void closeStrongQuote(int index) {
        this.raw.append('\'');
    }

    @Override
    public void openWeakQuote(int index) {
        this.raw.append('\"');
    }

    @Override
    public void closeWeakQuote(int index) {
        this.raw.append('\"');
    }

    @Override
    public void onChar(int index, Quoting quoting, boolean backslash, char c) {
        if (backslash) {
            this.raw.append('\\');
        }
        if (quoting == null) {
            this.raw.append(c);
        } else {
            switch (quoting) {
                case STRONG: 
                case WEAK: {
                    this.raw.append(c);
                }
            }
        }
    }

    @Override
    public void reset() {
        this.raw.setLength(0);
    }
}

