/*
 * Decompiled with CFR 0.152.
 */
package akka.serialization;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.NoSerializationVerificationNeeded;
import akka.annotation.InternalApi;
import akka.event.LogMarker$;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.event.MarkerLoggingAdapter;
import akka.serialization.ByteBufferSerializer;
import akka.serialization.DisabledJavaSerializer;
import akka.serialization.JavaSerializer;
import akka.serialization.NullSerializer$;
import akka.serialization.Serialization$;
import akka.serialization.SerializationSetup;
import akka.serialization.Serializer;
import akka.serialization.SerializerDetails;
import akka.serialization.SerializerDetails$;
import akka.serialization.SerializerWithStringManifest;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015s!B\u0001\u0003\u0011\u00039\u0011!D*fe&\fG.\u001b>bi&|gN\u0003\u0002\u0004\t\u0005i1/\u001a:jC2L'0\u0019;j_:T\u0011!B\u0001\u0005C.\\\u0017m\u0001\u0001\u0011\u0005!IQ\"\u0001\u0002\u0007\u000b)\u0011\u0001\u0012A\u0006\u0003\u001bM+'/[1mSj\fG/[8o'\tIA\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006'%!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d)AAF\u0005\u0001/\ty1\t\\1tgN+'/[1mSj,'\u000f\u0005\u0003\u000e1i\t\u0014BA\r\u000f\u0005\u0019!V\u000f\u001d7feA\u00121\u0004\u000b\t\u00049\r2cBA\u000f\"!\tqb\"D\u0001 \u0015\t\u0001c!\u0001\u0004=e>|GOP\u0005\u0003E9\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0013&\u0005\u0015\u0019E.Y:t\u0015\t\u0011c\u0002\u0005\u0002(Q1\u0001A!C\u0015\u0016\u0003\u0003\u0005\tQ!\u0001+\u0005\ryF%M\t\u0003W9\u0002\"!\u0004\u0017\n\u00055r!a\u0002(pi\"Lgn\u001a\t\u0003\u001b=J!\u0001\r\b\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\te%\u00111G\u0001\u0002\u000b'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0002C\u001b\n\u0005\u0004%\t\u0001\u0002\u001c\u00027\r,(O]3oiR\u0013\u0018M\\:q_J$\u0018J\u001c4pe6\fG/[8o+\u00059\u0004c\u0001\u001d<{5\t\u0011H\u0003\u0002;\u001d\u0005!Q\u000f^5m\u0013\ta\u0014HA\bEs:\fW.[2WCJL\u0017M\u00197f!\tqt(D\u0001\n\r\u0015\u0001\u0015B\u0011\u0003B\u0005-IeNZ8s[\u0006$\u0018n\u001c8\u0014\t}b!)\u0012\t\u0003\u001b\rK!\u0001\u0012\b\u0003\u000fA\u0013x\u000eZ;diB\u0011QBR\u0005\u0003\u000f:\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"S \u0003\u0016\u0004%\tAS\u0001\bC\u0012$'/Z:t+\u0005Y\u0005C\u0001'P\u001b\u0005i%B\u0001(\u0005\u0003\u0015\t7\r^8s\u0013\t\u0001VJA\u0004BI\u0012\u0014Xm]:\t\u0011I{$\u0011#Q\u0001\n-\u000b\u0001\"\u00193ee\u0016\u001c8\u000f\t\u0005\t)~\u0012)\u001a!C\u0001+\u000611/_:uK6,\u0012A\u0016\t\u0003\u0019^K!\u0001W'\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u0005\t5~\u0012\t\u0012)A\u0005-\u000691/_:uK6\u0004\u0003\"B\n@\t\u0003aFcA\u001f^=\")\u0011j\u0017a\u0001\u0017\")Ak\u0017a\u0001-\"9\u0001mPA\u0001\n\u0003\t\u0017\u0001B2paf$2!\u00102d\u0011\u001dIu\f%AA\u0002-Cq\u0001V0\u0011\u0002\u0003\u0007a\u000bC\u0004f\u007fE\u0005I\u0011\u00014\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tqM\u000b\u0002LQ.\n\u0011\u000e\u0005\u0002k_6\t1N\u0003\u0002m[\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003]:\t!\"\u00198o_R\fG/[8o\u0013\t\u00018NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016DqA] \u0012\u0002\u0013\u00051/\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003QT#A\u00165\t\u000fY|\u0014\u0011!C!o\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012\u0001\u001f\t\u0003szl\u0011A\u001f\u0006\u0003wr\fA\u0001\\1oO*\tQ0\u0001\u0003kCZ\f\u0017BA@{\u0005\u0019\u0019FO]5oO\"I\u00111A \u0002\u0002\u0013\u0005\u0011QA\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u000f\u00012!DA\u0005\u0013\r\tYA\u0004\u0002\u0004\u0013:$\b\"CA\b\u007f\u0005\u0005I\u0011AA\t\u00039\u0001(o\u001c3vGR,E.Z7f]R$2ALA\n\u0011)\t)\"!\u0004\u0002\u0002\u0003\u0007\u0011qA\u0001\u0004q\u0012\n\u0004\"CA\r\u007f\u0005\u0005I\u0011IA\u000e\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u000f!\u0015\ty\"!\n/\u001b\t\t\tCC\u0002\u0002$9\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9#!\t\u0003\u0011%#XM]1u_JD\u0011\"a\u000b@\u0003\u0003%\t!!\f\u0002\u0011\r\fg.R9vC2$B!a\f\u00026A\u0019Q\"!\r\n\u0007\u0005MbBA\u0004C_>dW-\u00198\t\u0013\u0005U\u0011\u0011FA\u0001\u0002\u0004q\u0003\"CA\u001d\u007f\u0005\u0005I\u0011IA\u001e\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0004\u0011%\tydPA\u0001\n\u0003\n\t%\u0001\u0005u_N#(/\u001b8h)\u0005A\b\"CA#\u007f\u0005\u0005I\u0011IA$\u0003\u0019)\u0017/^1mgR!\u0011qFA%\u0011%\t)\"a\u0011\u0002\u0002\u0003\u0007a\u0006C\u0004\u0002N%\u0001\u000b\u0011B\u001c\u00029\r,(O]3oiR\u0013\u0018M\\:q_J$\u0018J\u001c4pe6\fG/[8oA\u00191\u0011\u0011K\u0005\u0001\u0003'\u0012\u0001bU3ui&twm]\n\u0004\u0003\u001fb\u0001bCA,\u0003\u001f\u0012)\u0019!C\u0001\u00033\naaY8oM&<WCAA.!\u0011\ti&!\u001b\u000e\u0005\u0005}#\u0002BA,\u0003CRA!a\u0019\u0002f\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u0002h\u0005\u00191m\\7\n\t\u0005-\u0014q\f\u0002\u0007\u0007>tg-[4\t\u0017\u0005=\u0014q\nB\u0001B\u0003%\u00111L\u0001\bG>tg-[4!\u0011\u001d\u0019\u0012q\nC\u0001\u0003g\"B!!\u001e\u0002xA\u0019a(a\u0014\t\u0011\u0005]\u0013\u0011\u000fa\u0001\u00037B!\"a\u001f\u0002P\t\u0007I\u0011AA?\u0003-\u0019VM]5bY&TXM]:\u0016\u0005\u0005}\u0004c\u0002\u000f\u0002\u0002\u0006\u0015\u0015QQ\u0005\u0004\u0003\u0007+#aA'baB\u0019A$a\"\n\u0005},\u0003\"CAF\u0003\u001f\u0002\u000b\u0011BA@\u00031\u0019VM]5bY&TXM]:!\u0011)\ty)a\u0014C\u0002\u0013\u0005\u0011QP\u0001\u0016'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8CS:$\u0017N\\4t\u0011%\t\u0019*a\u0014!\u0002\u0013\ty(\u0001\fTKJL\u0017\r\\5{CRLwN\u001c\"j]\u0012LgnZ:!\u0011!\t9*a\u0014\u0005\u000e\u0005e\u0015aC2p]\u001aLw\rV8NCB$B!a \u0002\u001c\"A\u0011QTAK\u0001\u0004\tY&A\u0002dM\u001e<!\"!)\n\u0003\u0003E\t\u0001BAR\u0003-IeNZ8s[\u0006$\u0018n\u001c8\u0011\u0007y\n)KB\u0005A\u0013\u0005\u0005\t\u0012\u0001\u0003\u0002(N)\u0011QUAU\u000bB9\u00111VAY\u0017ZkTBAAW\u0015\r\tyKD\u0001\beVtG/[7f\u0013\u0011\t\u0019,!,\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004\u0014\u0003K#\t!a.\u0015\u0005\u0005\r\u0006BCA \u0003K\u000b\t\u0011\"\u0012\u0002B!Q\u0011QXAS\u0003\u0003%\t)a0\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bu\n\t-a1\t\r%\u000bY\f1\u0001L\u0011\u0019!\u00161\u0018a\u0001-\"Q\u0011qYAS\u0003\u0003%\t)!3\u0002\u000fUt\u0017\r\u001d9msR!\u00111ZAj!\u0015i\u0011QZAi\u0013\r\tyM\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t5A2J\u0016\u0005\n\u0003+\f)-!AA\u0002u\n1\u0001\u001f\u00131\u0011)\tI.!*\u0002\u0002\u0013%\u00111\\\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002^B\u0019\u00110a8\n\u0007\u0005\u0005(P\u0001\u0004PE*,7\r\u001e\u0005\b\u0003KLA\u0011AAt\u0003M\u0019XM]5bY&TX\rZ!di>\u0014\b+\u0019;i)\u0011\t))!;\t\u0011\u0005-\u00181\u001da\u0001\u0003[\f\u0001\"Y2u_J\u0014VM\u001a\t\u0004\u0019\u0006=\u0018bAAy\u001b\nA\u0011i\u0019;peJ+gMB\u0003\u000b\u0005\u0001\t)pE\u0003\u0002t2\t9\u0010E\u0002M\u0003sL1!a?N\u0005%)\u0005\u0010^3og&|g\u000e\u0003\u0006U\u0003g\u0014)\u0019!C\u0001\u0003\u007f,\"A!\u0001\u0011\u00071\u0013\u0019!C\u0002\u0003\u00065\u00131#\u0012=uK:$W\rZ!di>\u00148+_:uK6D!BWAz\u0005\u0003\u0005\u000b\u0011\u0002B\u0001\u0011\u001d\u0019\u00121\u001fC\u0001\u0005\u0017!BA!\u0004\u0003\u0010A\u0019\u0001\"a=\t\u000fQ\u0013I\u00011\u0001\u0003\u0002!Q!1CAz\u0005\u0004%\tA!\u0006\u0002\u0011M,G\u000f^5oON,\"Aa\u0006\u0011\t\te\u0011q\n\b\u0003\u0011\u0001A\u0011B!\b\u0002t\u0002\u0006IAa\u0006\u0002\u0013M,G\u000f^5oON\u0004\u0003B\u0003B\u0011\u0003g\u0014\r\u0011\"\u0001\u0003$\u00051\u0012\t\u001c7po*\u000bg/Y*fe&\fG.\u001b>bi&|g.\u0006\u0002\u00020!I!qEAzA\u0003%\u0011qF\u0001\u0018\u00032dwn\u001e&bm\u0006\u001cVM]5bY&T\u0018\r^5p]\u0002B\u0011Ba\u000b\u0002t\u0002\u0006IA!\f\u0002\t}cwn\u001a\t\u0005\u0005_\u0011)$\u0004\u0002\u00032)\u0019!1\u0007\u0003\u0002\u000b\u00154XM\u001c;\n\t\t]\"\u0011\u0007\u0002\u0015\u001b\u0006\u00148.\u001a:M_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\t\u0015\tm\u00121\u001fb\u0001\n\u0003\u0011i$A\u0002m_\u001e,\"Aa\u0010\u0011\t\t=\"\u0011I\u0005\u0005\u0005\u0007\u0012\tD\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\t\u0013\t\u001d\u00131\u001fQ\u0001\n\t}\u0012\u0001\u00027pO\u0002B!Ba\u0013\u0002t\n\u0007I\u0011\u0002B'\u00035i\u0017M\\5gKN$8)Y2iKV\u0011!q\n\t\u0007\u0005#\u0012iF!\u0019\u000e\u0005\tM#\u0002\u0002B+\u0005/\na!\u0019;p[&\u001c'\u0002\u0002B-\u00057\n!bY8oGV\u0014(/\u001a8u\u0015\tQD0\u0003\u0003\u0003`\tM#aD!u_6L7MU3gKJ,gnY3\u0011\u0011\t\r$\u0011NAC\u0005Wj!A!\u001a\u000b\t\t\u001d\u0014\u0011E\u0001\nS6lW\u000f^1cY\u0016LA!a!\u0003fA)Q\"!4\u0003nA\"!q\u000eB;!\u0015I(\u0011\u000fB:\u0013\t!#\u0010E\u0002(\u0005k\"1Ba\u001e\u0003z\u0005\u0005\t\u0011!B\u0001U\t\u0019q\f\n\u001a\t\u0013\tm\u00141\u001fQ\u0001\n\t=\u0013AD7b]&4Wm\u001d;DC\u000eDW\r\t\u0005\t\u0005\u007f\n\u0019\u0010\"\u0001\u0003\u0002\u0006I1/\u001a:jC2L'0\u001a\u000b\u0005\u0005\u0007\u0013)\nE\u00039\u0005\u000b\u0013I)C\u0002\u0003\bf\u00121\u0001\u0016:z!\u0015i!1\u0012BH\u0013\r\u0011iI\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u001b\tE\u0015b\u0001BJ\u001d\t!!)\u001f;f\u0011\u001d\u00119J! A\u00021\t\u0011a\u001c\u0005\t\u00057\u000b\u0019\u0010\"\u0001\u0003\u001e\u0006YA-Z:fe&\fG.\u001b>f+\u0011\u0011yJ!*\u0015\u0011\t\u0005&\u0011\u0016BW\u0005c\u0003R\u0001\u000fBC\u0005G\u00032a\nBS\t\u001d\u00119K!'C\u0002)\u0012\u0011\u0001\u0016\u0005\t\u0005W\u0013I\n1\u0001\u0003\n\u0006)!-\u001f;fg\"A!q\u0016BM\u0001\u0004\t9!\u0001\u0007tKJL\u0017\r\\5{KJLE\r\u0003\u0005\u00034\ne\u0005\u0019\u0001B[\u0003\u0015\u0019G.\u0019>{!\u0015i\u0011Q\u001aB\\a\u0011\u0011IL!0\u0011\tq\u0019#1\u0018\t\u0004O\tuF\u0001\u0004B`\u0005\u0003\f\t\u0011!A\u0003\u0002\tE'aA0%i!A!1\u0017BM\u0001\u0004\u0011\u0019\rE\u0003\u000e\u0003\u001b\u0014)\r\r\u0003\u0003H\n-\u0007\u0003\u0002\u000f$\u0005\u0013\u00042a\nBf\t1\u0011yL!1\u0002\u0002\u0003\u0005)\u0011\u0001Bg#\rY#q\u001a\t\u0004O\t\u0015\u0016cA\u0016\u0003$\"A!1TAz\t\u0003\u0011)\u000e\u0006\u0005\u0003X\ne'1\u001cBo!\u0011A$Q\u0011\u0007\t\u0011\t-&1\u001ba\u0001\u0005\u0013C\u0001Ba,\u0003T\u0002\u0007\u0011q\u0001\u0005\t\u0005?\u0014\u0019\u000e1\u0001\u0002\u0006\u0006AQ.\u00198jM\u0016\u001cH\u000f\u0003\u0005\u0003d\u0006MH\u0011\u0002Bs\u0003Q!Wm]3sS\u0006d\u0017N_3CsR,\u0017I\u001d:bsR9ABa:\u0003j\n5\b\u0002\u0003BV\u0005C\u0004\rA!#\t\u000f\t-(\u0011\u001da\u0001c\u0005Q1/\u001a:jC2L'0\u001a:\t\u0011\t}'\u0011\u001da\u0001\u0003\u000bC\u0001B!=\u0002t\u0012\u0005!1_\u0001\u0016I\u0016\u001cXM]5bY&TXMQ=uK\n+hMZ3s)\u001da!Q_B\u0003\u0007\u000fA\u0001Ba>\u0003p\u0002\u0007!\u0011`\u0001\u0004EV4\u0007\u0003\u0002B~\u0007\u0003i!A!@\u000b\u0007\t}H0A\u0002oS>LAaa\u0001\u0003~\nQ!)\u001f;f\u0005V4g-\u001a:\t\u0011\t=&q\u001ea\u0001\u0003\u000fA\u0001Ba8\u0003p\u0002\u0007\u0011Q\u0011\u0015\u0007\u0005_\u001cYa!\b\u0011\u000b5\u0019ia!\u0005\n\u0007\r=aB\u0001\u0004uQJ|wo\u001d\t\u0005\u0007'\u0019I\"\u0004\u0002\u0004\u0016)\u00191q\u0003?\u0002\u0005%|\u0017\u0002BB\u000e\u0007+\u0011\u0001DT8u'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z#yG\u0016\u0004H/[8oG\t\u0019\t\u0002\u0003\u0005\u0003\u001c\u0006MH\u0011AB\u0011+\u0011\u0019\u0019c!\u000b\u0015\r\r\u001521FB\u0017!\u0015A$QQB\u0014!\r93\u0011\u0006\u0003\b\u0005O\u001byB1\u0001+\u0011!\u0011Yka\bA\u0002\t%\u0005\u0002\u0003BZ\u0007?\u0001\raa\f\u0011\tq\u00193q\u0005\u0005\t\u0007g\t\u0019\u0010\"\u0001\u00046\u0005\tb-\u001b8e'\u0016\u0014\u0018.\u00197ju\u0016\u0014hi\u001c:\u0015\u0007E\u001a9\u0004C\u0004\u0003\u0018\u000eE\u0002\u0019\u0001\u0007\t\u0011\rm\u00121\u001fC\u0001\u0007{\tQb]3sS\u0006d\u0017N_3s\r>\u0014HcA\u0019\u0004@!A!1WB\u001d\u0001\u0004\u0019\t\u0005\r\u0003\u0004D\r\u001d\u0003\u0003\u0002\u000f$\u0007\u000b\u00022aJB$\t-\u0019Iea\u0010\u0002\u0002\u0003\u0005)\u0011\u0001\u0016\u0003\u0007}#\u0003\b\u000b\u0004\u0004:\r-1Q\u0004\u0005\t\u0007\u001f\n\u0019\u0010\"\u0001\u0004R\u0005a1/\u001a:jC2L'0\u001a:PMR!11KB+!\u0011A$QQ\u0019\t\u0011\r]3Q\na\u0001\u0003\u000b\u000bQb]3sS\u0006d\u0017N_3s\rFs\u0005BCB.\u0003g\u0014\r\u0011\"\u0003\u0004^\u0005\t2/\u001a:jC2L'0\u001a:EKR\f\u0017\u000e\\:\u0016\u0005\r}\u0003C\u0002B2\u0007C\u001a)'\u0003\u0003\u0004d\t\u0015$aA*fcB\u0019\u0001ba\u001a\n\u0007\r%$AA\tTKJL\u0017\r\\5{KJ$U\r^1jYND\u0011b!\u001c\u0002t\u0002\u0006Iaa\u0018\u0002%M,'/[1mSj,'\u000fR3uC&d7\u000f\t\u0005\u000b\u0007c\n\u0019P1A\u0005\n\rM\u0014aC:fe&\fG.\u001b>feN,\"a!\u001e\u0011\rq\t\t)!\"2\u0011%\u0019I(a=!\u0002\u0013\u0019)(\u0001\u0007tKJL\u0017\r\\5{KJ\u001c\b\u0005C\u0006\u0004~\u0005M(\u0019!C\u0001\t\r}\u0014\u0001\u00032j]\u0012LgnZ:\u0016\u0005\r\u0005\u0005C\u0002B2\u0007C\u001a\u0019\tE\u0002\u0003\u001aUA\u0011ba\"\u0002t\u0002\u0006Ia!!\u0002\u0013\tLg\u000eZ5oON\u0004\u0003\u0002CBF\u0003g$Ia!$\u00029\u0015t7/\u001e:f\u001f:d\u00170\u00117m_^,GmU3sS\u0006d\u0017N_3sgR!1qRBK!\ri1\u0011S\u0005\u0004\u0007's!\u0001B+oSRD\u0001ba&\u0004\n\u0002\u00071\u0011T\u0001\u0005SR,'\u000fE\u0003\u0004\u001c\u000e\u0015\u0016G\u0004\u0003\u0004\u001e\u000e\u0005fb\u0001\u0010\u0004 &\tq\"C\u0002\u0004$:\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002(\r\u001d&bABR\u001d!A11VAz\t\u0013\u0019i+A\ndQ\u0016\u001c7nR8pO2,\u0007K]8u_\n,h\r\u0006\u0003\u00020\r=\u0006\u0002CBY\u0007S\u0003\r!!\"\u0002\u0013\rd\u0017m]:OC6,\u0007\u0002CB[\u0003g$Iaa.\u0002\tM|'\u000f\u001e\u000b\u0005\u0007\u0003\u001bI\f\u0003\u0005\u0004<\u000eM\u0006\u0019AB_\u0003\tIg\u000e\u0005\u0004\u0004\u001c\u000e}61Q\u0005\u0005\u0007\u0003\u001c9K\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011)\u0019)-a=C\u0002\u0013%1qY\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0016\u0014X*\u00199\u0016\u0005\r%\u0007cBBf\u0007\u001b\u001c\t.M\u0007\u0003\u0005/JAaa4\u0003X\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u001991\t\rM7q\u001b\t\u00059\r\u001a)\u000eE\u0002(\u0007/$1b!7\u0004\\\u0006\u0005\t\u0011!B\u0001U\t!q\fJ\u00191\u0011%\u0019i.a=!\u0002\u0013\u0019y.\u0001\btKJL\u0017\r\\5{KJl\u0015\r\u001d\u0011\u0011\u000f\r-7QZBqcA\"11]Bt!\u0011a2e!:\u0011\u0007\u001d\u001a9\u000fB\u0006\u0004Z\u000em\u0017\u0011!A\u0001\u0006\u0003Q\u0003BCBv\u0003g\u0014\r\u0011\"\u0001\u0004n\u0006!2/\u001a:jC2L'0\u001a:Cs&#WM\u001c;jif,\"aa<\u0011\rq\t\t)a\u00022\u0011%\u0019\u00190a=!\u0002\u0013\u0019y/A\u000btKJL\u0017\r\\5{KJ\u0014\u00150\u00133f]RLG/\u001f\u0011\t\u0015\r]\u00181\u001fb\u0001\n\u0013\u0019I0A\rrk&\u001c7nU3sS\u0006d\u0017N_3s\u0005fLE-\u001a8uSRLXCAB~!\u0011i!1R\u0019\t\u0013\r}\u00181\u001fQ\u0001\n\rm\u0018AG9vS\u000e\\7+\u001a:jC2L'0\u001a:Cs&#WM\u001c;jif\u0004\u0003\u0002\u0003C\u0002\u0003g$I\u0001\"\u0002\u0002#\u001d,GoU3sS\u0006d\u0017N_3s\u0005fLE\rF\u00022\t\u000fA\u0001\u0002\"\u0003\u0005\u0002\u0001\u0007\u0011qA\u0001\u0003S\u0012D!\u0002\"\u0004\u0002t\n\u0007I\u0011\u0002B\u0012\u0003\u0005J7OS1wCN+'/[1mSj\fG/[8o/\u0006\u0014h.\u001b8h\u000b:\f'\r\\3e\u0011%!\t\"a=!\u0002\u0013\ty#\u0001\u0012jg*\u000bg/Y*fe&\fG.\u001b>bi&|gnV1s]&tw-\u00128bE2,G\r\t\u0005\u000b\t+\t\u0019P1A\u0005\n\t\r\u0012\u0001I5t/\u0006\u0014h.\u001b8h\u001f:tuNV3sS\u001aL7-\u0019;j_:,e.\u00192mK\u0012D\u0011\u0002\"\u0007\u0002t\u0002\u0006I!a\f\u0002C%\u001cx+\u0019:oS:<wJ\u001c(p-\u0016\u0014\u0018NZ5dCRLwN\\#oC\ndW\r\u001a\u0011\t\u0011\u0011u\u00111\u001fC\u0005\t?\t!$[:ESN\fG\u000e\\8xK\u0012T\u0015M^1TKJL\u0017\r\\5{KJ$B!a\f\u0005\"!9!1\u001eC\u000e\u0001\u0004\t\u0004\"\u0003C\u0013\u0003g$\t\u0001\u0002C\u0014\u0003u\u0019\bn\\;mI^\u000b'O\\!c_V$(*\u0019<b'\u0016\u0014\u0018.\u00197ju\u0016\u0014HCBA\u0018\tS!9\u0004\u0003\u0005\u0005,\u0011\r\u0002\u0019\u0001C\u0017\u0003=\u0019XM]5bY&TX\rZ\"mCN\u001c\b\u0007\u0002C\u0018\tg\u0001B\u0001H\u0012\u00052A\u0019q\u0005b\r\u0005\u0017\u0011UB\u0011FA\u0001\u0002\u0003\u0015\tA\u000b\u0002\u0005?\u0012\n$\u0007C\u0004\u0003l\u0012\r\u0002\u0019A\u0019)\t\u0011\rB1\b\t\u0005\t{!\t%\u0004\u0002\u0005@)\u0011a\u000eB\u0005\u0005\t\u0007\"yDA\u0006J]R,'O\\1m\u0003BL\u0007")
public class Serialization
implements Extension {
    private final ExtendedActorSystem system;
    private final Settings settings;
    private final boolean AllowJavaSerialization;
    private final MarkerLoggingAdapter _log;
    private final LoggingAdapter log;
    private final AtomicReference<Map<String, Option<Class<?>>>> manifestCache;
    private final scala.collection.immutable.Seq<SerializerDetails> serializerDetails;
    private final Map<String, Serializer> serializers;
    private final scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings;
    private final ConcurrentHashMap<Class<?>, Serializer> serializerMap;
    private final Map<Object, Serializer> serializerByIdentity;
    private final Serializer[] quickSerializerByIdentity;
    private final boolean isJavaSerializationWarningEnabled;
    private final boolean isWarningOnNoVerificationEnabled;

    public static String serializedActorPath(ActorRef actorRef) {
        return Serialization$.MODULE$.serializedActorPath(actorRef);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public Settings settings() {
        return this.settings;
    }

    public boolean AllowJavaSerialization() {
        return this.AllowJavaSerialization;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private AtomicReference<Map<String, Option<Class<?>>>> manifestCache() {
        return this.manifestCache;
    }

    public Try<byte[]> serialize(Object o) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.findSerializerFor(o).toBinary(o));
    }

    public <T> Try<T> deserialize(byte[] bytes, int serializerId, Option<Class<? extends T>> clazz) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find serializer with id [", "]. The most probable reason is that the configuration entry "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)serializerId)})) + "akka.actor.serializers is not in synch between the two systems.");
            }
            Serializer serializer2 = serializer;
            return serializer2.fromBinary(bytes, clazz);
        });
    }

    public Try<Object> deserialize(byte[] bytes, int serializerId, String manifest) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Serializer serializer;
            try {
                serializer = this.getSerializerById(serializerId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotSerializableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find serializer with id [", "]. The most probable reason is that the configuration entry "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)serializerId)})) + "akka.actor.serializers is not in synch between the two systems.");
            }
            Serializer serializer2 = serializer;
            return this.deserializeByteArray(bytes, serializer2, manifest);
        });
    }

    private Object deserializeByteArray(byte[] bytes, Serializer serializer, String manifest) {
        Object object;
        Serializer serializer2 = serializer;
        if (serializer2 instanceof SerializerWithStringManifest) {
            SerializerWithStringManifest serializerWithStringManifest = (SerializerWithStringManifest)serializer2;
            object = serializerWithStringManifest.fromBinary(bytes, manifest);
        } else {
            Object object2;
            String string = manifest;
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                object2 = serializer2.fromBinary(bytes, (Option<Class<?>>)None$.MODULE$);
            } else {
                Object object3;
                Map<String, Option<Class<?>>> cache = this.manifestCache().get();
                Option option = cache.get((Object)manifest);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Option cachedClassManifest = (Option)some.value();
                    object3 = serializer2.fromBinary(bytes, cachedClassManifest);
                } else if (None$.MODULE$.equals(option)) {
                    Try try_ = this.system().dynamicAccess().getClassFor(manifest, ClassTag$.MODULE$.AnyRef());
                    if (!(try_ instanceof Success)) {
                        if (try_ instanceof Failure) {
                            throw new NotSerializableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find manifest class [", "] for serializer with id [", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{manifest, BoxesRunTime.boxToInteger((int)serializer.identifier())})));
                        }
                        throw new MatchError(try_);
                    }
                    Success success = (Success)try_;
                    Class classManifest = (Class)success.value();
                    Some classManifestOption = new Some((Object)classManifest);
                    this.updateCache$1(cache, manifest, (Option)classManifestOption);
                    Object object4 = serializer2.fromBinary(bytes, (Option<Class<?>>)classManifestOption);
                    object3 = object4;
                } else {
                    throw new MatchError((Object)option);
                }
                object2 = object3;
            }
            object = object2;
        }
        return object;
    }

    public Object deserializeByteBuffer(ByteBuffer buf, int serializerId, String manifest) throws NotSerializableException {
        Object object;
        Serializer serializer;
        Serializer serializer2;
        try {
            serializer2 = this.getSerializerById(serializerId);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NotSerializableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find serializer with id [", "]. The most probable reason is that the configuration entry "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)serializerId)})) + "akka.actor.serializers is not in synch between the two systems.");
        }
        Serializer serializer3 = serializer = serializer2;
        if (serializer3 instanceof ByteBufferSerializer) {
            Serializer serializer4 = serializer3;
            object = ((ByteBufferSerializer)((Object)serializer4)).fromBinary(buf, manifest);
        } else {
            byte[] bytes = new byte[buf.remaining()];
            buf.get(bytes);
            object = this.deserializeByteArray(bytes, serializer, manifest);
        }
        return object;
    }

    public <T> Try<T> deserialize(byte[] bytes, Class<T> clazz) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.serializerFor(clazz).fromBinary(bytes, (Option<Class<?>>)new Some((Object)clazz)));
    }

    public Serializer findSerializerFor(Object o) {
        return o == null ? NullSerializer$.MODULE$ : this.serializerFor(o.getClass());
    }

    public Serializer serializerFor(Class<?> clazz) throws NotSerializableException {
        Serializer serializer;
        Serializer serializer2 = this.serializerMap().get(clazz);
        if (serializer2 == null) {
            Serializer serializer3;
            Serializer serializer4;
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)this.bindings().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$3(clazz, x0$2)));
            Some some = Seq$.MODULE$.unapplySeq((Seq)seq);
            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                throw new NotSerializableException(new StringOps(Predef$.MODULE$.augmentString("No configured serialization-bindings for class [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clazz.getName()})));
            }
            if (!Serialization.unique$1(seq)) {
                this._log.warning(LogMarker$.MODULE$.Security(), "Multiple serializers found for " + clazz + ", choosing first: " + seq);
            }
            Serializer ser = serializer4 = (Serializer)((Tuple2)seq.apply(0))._2();
            Serializer serializer5 = this.serializerMap().putIfAbsent(clazz, ser);
            if (serializer5 == null) {
                if (this.shouldWarnAboutJavaSerializer(clazz, ser)) {
                    this._log.warning(LogMarker$.MODULE$.Security(), "Using the default Java serializer for class [{}] which is not recommended because of performance implications. Use another serializer or disable this warning using the setting 'akka.actor.warn-about-java-serializer-usage'", (Object)clazz.getName());
                }
                this.log().debug("Using serializer [{}] for message [{}]", ser.getClass().getName(), clazz.getName());
                serializer3 = ser;
            } else {
                serializer3 = serializer5;
            }
            serializer = serializer3;
        } else {
            serializer = serializer2;
        }
        return serializer;
    }

    /*
     * Unable to fully structure code
     */
    public Try<Serializer> serializerOf(String serializerFQN) {
        if (this.system().settings().AllowJavaSerialization()) ** GOTO lbl-1000
        v0 = serializerFQN;
        var3_2 = JavaSerializer.class.getName();
        if (!(v0 != null ? v0.equals(var3_2) == false : var3_2 != null)) {
            this.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
            v1 = DisabledJavaSerializer.class.getName();
        } else lbl-1000:
        // 2 sources

        {
            v1 = serializerFQN;
        }
        fqn = v1;
        return this.system().dynamicAccess().createInstanceFor(fqn, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class), (Object)this.system())})), ClassTag$.MODULE$.apply(Serializer.class)).recoverWith((PartialFunction)new scala.Serializable(this, fqn){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;
            private final String fqn$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Try<T> try_ = A1 instanceof NoSuchMethodException ? this.$outer.system().dynamicAccess().createInstanceFor(this.fqn$1, (scala.collection.immutable.Seq<Tuple2<Class<?>, Object>>)Nil$.MODULE$, ClassTag$.MODULE$.apply(Serializer.class)) : function1.apply(x1);
                return (B1)try_;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof NoSuchMethodException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fqn$1 = fqn$1;
            }
        });
    }

    private scala.collection.immutable.Seq<SerializerDetails> serializerDetails() {
        return this.serializerDetails;
    }

    private Map<String, Serializer> serializers() {
        return this.serializers;
    }

    public scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> bindings() {
        return this.bindings;
    }

    private void ensureOnlyAllowedSerializers(Iterator<Serializer> iter) {
        block0: {
            if (this.system().settings().AllowJavaSerialization()) break block0;
            Predef$.MODULE$.require(iter.forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$ensureOnlyAllowedSerializers$2(this, x$6))), (Function0 & Serializable & scala.Serializable)() -> "Disallowed JavaSerializer binding.");
        }
    }

    private boolean checkGoogleProtobuf(String className) {
        return !className.startsWith("com.google.protobuf") || this.system().dynamicAccess().getClassFor(className, ClassTag$.MODULE$.Any()).isSuccess();
    }

    private scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> sort(Iterable<Tuple2<Class<?>, Serializer>> in) {
        ArrayBuffer arrayBuffer = new ArrayBuffer(in.size());
        return (scala.collection.immutable.Seq)((TraversableLike)in.$div$colon((Object)arrayBuffer, (Function2 & Serializable & scala.Serializable)(buf, ca) -> {
            int n = buf.indexWhere((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$sort$2(ca, x$8)));
            switch (n) {
                case -1: {
                    buf.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    break;
                }
                default: {
                    buf.insert(n, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ca}));
                    break;
                }
            }
            return buf;
        })).to(Predef$.MODULE$.fallbackStringCanBuildFrom());
    }

    private ConcurrentHashMap<Class<?>, Serializer> serializerMap() {
        return this.serializerMap;
    }

    public Map<Object, Serializer> serializerByIdentity() {
        return this.serializerByIdentity;
    }

    private Serializer[] quickSerializerByIdentity() {
        return this.quickSerializerByIdentity;
    }

    private Serializer getSerializerById(int id) {
        Serializer serializer;
        if (0 <= id && id < this.quickSerializerByIdentity().length) {
            Serializer serializer2;
            Serializer serializer3 = this.quickSerializerByIdentity()[id];
            if (serializer3 == null) {
                throw new NoSuchElementException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key not found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
            }
            serializer = serializer2 = serializer3;
        } else {
            serializer = (Serializer)this.serializerByIdentity().apply((Object)BoxesRunTime.boxToInteger((int)id));
        }
        return serializer;
    }

    private boolean isJavaSerializationWarningEnabled() {
        return this.isJavaSerializationWarningEnabled;
    }

    private boolean isWarningOnNoVerificationEnabled() {
        return this.isWarningOnNoVerificationEnabled;
    }

    public boolean akka$serialization$Serialization$$isDisallowedJavaSerializer(Serializer serializer) {
        return serializer instanceof JavaSerializer && !this.system().settings().AllowJavaSerialization();
    }

    @InternalApi
    public boolean shouldWarnAboutJavaSerializer(Class<?> serializedClass, Serializer serializer) {
        return this.isJavaSerializationWarningEnabled() && (serializer instanceof JavaSerializer || serializer instanceof DisabledJavaSerializer) && !serializedClass.getName().startsWith("akka.") && !serializedClass.getName().startsWith("java.lang.") && !this.suppressWarningOnNonSerializationVerification$1(serializedClass);
    }

    private final boolean updateCache$1(Map cache, String key, Option value) {
        while (!this.manifestCache().compareAndSet(cache, cache.updated((Object)key, (Object)value))) {
            cache = this.manifestCache().get();
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$1(scala.collection.immutable.Seq possibilities$1, Tuple2 x$1) {
        return ((Class)x$1._1()).isAssignableFrom((Class)((Tuple2)possibilities$1.apply(0))._1());
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$2(scala.collection.immutable.Seq possibilities$1, Tuple2 x$2) {
        return BoxesRunTime.equals((Object)x$2._2(), (Object)((Tuple2)possibilities$1.apply(0))._2());
    }

    private static final boolean unique$1(scala.collection.immutable.Seq possibilities) {
        return possibilities.size() == 1 || possibilities.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$1(possibilities, x$1))) || possibilities.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializerFor$2(possibilities, x$2)));
    }

    public static final /* synthetic */ boolean $anonfun$serializerFor$3(Class clazz$3, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Class c = (Class)tuple2._1();
        boolean bl = c.isAssignableFrom(clazz$3);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$serializers$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 == null) return false;
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        if (k == null) return false;
        if (v == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$bindings$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        if (tuple2 == null) return false;
        String className = (String)tuple2._1();
        String alias = (String)tuple2._2();
        if (className == null) return false;
        if (alias == null) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$bindings$2(Serialization $this, Tuple2 x$4) {
        String string;
        String string2;
        String alias;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = x$4;
                if (tuple2 == null) break block2;
                String className = (String)tuple2._1();
                alias = (String)tuple2._2();
                if (className == null) break block2;
                string2 = className;
                if (alias != null) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        String string3 = string = alias;
        String string4 = "none";
        boolean bl = (string3 == null ? string4 != null : !string3.equals(string4)) && $this.checkGoogleProtobuf(string2);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$ensureOnlyAllowedSerializers$2(Serialization $this, Serializer x$6) {
        return !$this.akka$serialization$Serialization$$isDisallowedJavaSerializer(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$sort$2(Tuple2 ca$1, Tuple2 x$8) {
        return ((Class)x$8._1()).isAssignableFrom((Class)ca$1._1());
    }

    public static final /* synthetic */ void $anonfun$quickSerializerByIdentity$1(int size$1, Serializer[] table$1, Tuple2 x0$7) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$7;
        if (tuple2 != null) {
            int id = tuple2._1$mcI$sp();
            Serializer ser = (Serializer)tuple2._2();
            if (0 <= id && id < size$1) {
                table$1[id] = ser;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final boolean suppressWarningOnNonSerializationVerification$1(Class serializedClass) {
        return !this.isWarningOnNoVerificationEnabled() && NoSerializationVerificationNeeded.class.isAssignableFrom(serializedClass);
    }

    public Serialization(ExtendedActorSystem system) {
        Vector vector;
        this.system = system;
        this.settings = new Settings(system.settings().config());
        this.AllowJavaSerialization = system.settings().AllowJavaSerialization();
        this._log = Logging$.MODULE$.withMarker(system, this.getClass().getName(), LogSource$.MODULE$.fromString());
        this.log = this._log;
        this.manifestCache = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        Option option = system.settings().setup().get(ClassTag$.MODULE$.apply(SerializationSetup.class));
        if (None$.MODULE$.equals(option)) {
            vector = package$.MODULE$.Vector().empty();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            SerializationSetup setting = (SerializationSetup)some.value();
            vector = (scala.collection.immutable.Seq)setting.createSerializers().apply((Object)system);
        } else {
            throw new MatchError(option);
        }
        this.serializerDetails = (scala.collection.immutable.Seq)vector.collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Serialization $outer;

            public final <A1 extends SerializerDetails, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1;
                A1 A12 = x2;
                if (A12 != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((A1 = A12).serializer())) {
                    this.$outer.log().debug("Replacing JavaSerializer with DisabledJavaSerializer, due to `akka.actor.allow-java-serialization = off`.");
                    object = SerializerDetails$.MODULE$.apply(A1.alias(), new DisabledJavaSerializer(this.$outer.system()), A1.useFor());
                } else {
                    object = A12;
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SerializerDetails x2) {
                SerializerDetails serializerDetails;
                SerializerDetails serializerDetails2 = x2;
                boolean bl = serializerDetails2 != null && this.$outer.akka$serialization$Serialization$$isDisallowedJavaSerializer((serializerDetails = serializerDetails2).serializer()) ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Map fromConfig = (Map)this.settings().Serializers().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$serializers$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
            String string;
            String v;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$3;
                    if (tuple2 == null) break block2;
                    String k = (String)tuple2._1();
                    v = (String)tuple2._2();
                    if (k == null) break block2;
                    string = k;
                    if (v != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = v;
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)string), this.serializerOf(string2).get());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        Map result = fromConfig.$plus$plus((GenTraversableOnce)this.serializerDetails().map((Function1 & Serializable & scala.Serializable)d -> Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)d.alias()), (Object)d.serializer()), Seq$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)((Iterator)result.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Serializer ser;
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer serializer = ser = (Serializer)tuple2._2();
            return serializer;
        }, scala.collection.package$.MODULE$.breakOut((CanBuildFrom)Iterator$.MODULE$.IteratorCanBuildFrom()))));
        this.serializers = result;
        scala.collection.immutable.Iterable fromConfig2 = (scala.collection.immutable.Iterable)this.settings().SerializationBindings().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$1(check$ifrefutable$2))).withFilter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Serialization.$anonfun$bindings$2(this, x$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> {
            String string;
            String alias;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x$5;
                    if (tuple2 == null) break block2;
                    String className = (String)tuple2._1();
                    alias = (String)tuple2._2();
                    if (className == null) break block2;
                    string = className;
                    if (alias != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String string2 = alias;
            Tuple2 tuple2 = new Tuple2(this.system().dynamicAccess().getClassFor(string, ClassTag$.MODULE$.Any()).get(), this.serializers().apply((Object)string2));
            return tuple2;
        }, Iterable$.MODULE$.canBuildFrom());
        scala.collection.immutable.Seq fromSettings = (scala.collection.immutable.Seq)this.serializerDetails().flatMap((Function1 & Serializable & scala.Serializable)detail -> (scala.collection.immutable.Seq)detail.useFor().map((Function1 & Serializable & scala.Serializable)clazz -> Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc(clazz), (Object)detail.serializer()), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Seq<Tuple2<Class<?>, Serializer>> result2 = this.sort((Iterable)fromConfig2.$plus$plus((GenTraversableOnce)fromSettings, Iterable$.MODULE$.canBuildFrom()));
        this.ensureOnlyAllowedSerializers((Iterator<Serializer>)((Iterator)result2.map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Serializer ser;
            Tuple2 tuple2 = x0$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer serializer = ser = (Serializer)tuple2._2();
            return serializer;
        }, scala.collection.package$.MODULE$.breakOut((CanBuildFrom)Iterator$.MODULE$.IteratorCanBuildFrom()))));
        this.bindings = result2;
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        this.serializerMap = (ConcurrentHashMap)this.bindings().$div$colon(concurrentHashMap, (Function2 & Serializable & scala.Serializable)(x0$5, x1$1) -> {
            Tuple2 tuple2;
            ConcurrentHashMap map;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$5, x1$1);
                    if (tuple22 == null) break block2;
                    map = (ConcurrentHashMap)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Class c = (Class)tuple2._1();
            Serializer s = (Serializer)tuple2._2();
            map.put(c, s);
            ConcurrentHashMap concurrentHashMap = map;
            return concurrentHashMap;
        });
        this.serializerByIdentity = (Map)((TraversableLike)((TraversableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)NullSerializer$.MODULE$.identifier())), (Object)NullSerializer$.MODULE$)}))).$plus$plus(this.serializers(), Map$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$6 -> {
            Tuple2 tuple2 = x0$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Serializer v = (Serializer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)v.identifier()), (Object)v);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        int size = 1024;
        Serializer[] table = new Serializer[size];
        this.serializerByIdentity().foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
            Serialization.$anonfun$quickSerializerByIdentity$1(size, table, x0$7);
            return BoxedUnit.UNIT;
        });
        this.quickSerializerByIdentity = table;
        this.isJavaSerializationWarningEnabled = this.settings().config().getBoolean("akka.actor.warn-about-java-serializer-usage");
        this.isWarningOnNoVerificationEnabled = this.settings().config().getBoolean("akka.actor.warn-on-no-serialization-verification");
    }

    public static final class Information
    implements Product,
    scala.Serializable {
        private final Address address;
        private final ActorSystem system;

        public Address address() {
            return this.address;
        }

        public ActorSystem system() {
            return this.system;
        }

        public Information copy(Address address, ActorSystem system) {
            return new Information(address, system);
        }

        public Address copy$default$1() {
            return this.address();
        }

        public ActorSystem copy$default$2() {
            return this.system();
        }

        public String productPrefix() {
            return "Information";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.address();
                    break;
                }
                case 1: {
                    object = this.system();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Information;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Information)) return false;
            boolean bl = true;
            if (!bl) return false;
            Information information = (Information)x$1;
            Address address = this.address();
            Address address2 = information.address();
            if (address == null) {
                if (address2 != null) {
                    return false;
                }
            } else if (!((Object)address).equals(address2)) return false;
            ActorSystem actorSystem = this.system();
            ActorSystem actorSystem2 = information.system();
            if (actorSystem == null) {
                if (actorSystem2 == null) return true;
                return false;
            } else {
                if (!actorSystem.equals(actorSystem2)) return false;
                return true;
            }
        }

        public Information(Address address, ActorSystem system) {
            this.address = address;
            this.system = system;
            Product.$init$((Product)this);
        }
    }

    public static class Settings {
        private final Config config;
        private final Map<String, String> Serializers;
        private final Map<String, String> SerializationBindings;

        public Config config() {
            return this.config;
        }

        public Map<String, String> Serializers() {
            return this.Serializers;
        }

        public Map<String, String> SerializationBindings() {
            return this.SerializationBindings;
        }

        private final Map<String, String> configToMap(Config cfg) {
            return (Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(cfg.root().unwrapped()).asScala()).toMap(Predef$.MODULE$.$conforms()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$u2192$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.toString());
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }

        public Settings(Config config) {
            this.config = config;
            this.Serializers = this.configToMap(config.getConfig("akka.actor.serializers"));
            Config defaultBindings = config.getConfig("akka.actor.serialization-bindings");
            Config bindings = config.getBoolean("akka.actor.enable-additional-serialization-bindings") || !config.getBoolean("akka.actor.allow-java-serialization") || config.hasPath("akka.remote.artery.enabled") && config.getBoolean("akka.remote.artery.enabled") ? defaultBindings.withFallback((ConfigMergeable)config.getConfig("akka.actor.additional-serialization-bindings")) : defaultBindings;
            this.SerializationBindings = this.configToMap(bindings);
        }
    }
}

