/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.TermUnblocker;
import org.agrona.concurrent.UnsafeBuffer;

public class LogBufferUnblocker {
    public static boolean unblock(UnsafeBuffer[] termBuffers, UnsafeBuffer logMetaDataBuffer, long blockedPosition) {
        int termLength = termBuffers[0].capacity();
        int positionBitsToShift = Integer.numberOfTrailingZeros(termLength);
        int index = LogBufferDescriptor.indexByPosition(blockedPosition, positionBitsToShift);
        UnsafeBuffer termBuffer = termBuffers[index];
        long rawTail = LogBufferDescriptor.rawTailVolatile(logMetaDataBuffer, index);
        int termId = LogBufferDescriptor.termId(rawTail);
        int tailOffset = LogBufferDescriptor.termOffset(rawTail, termLength);
        int blockedOffset = LogBufferDescriptor.computeTermOffsetFromPosition(blockedPosition, positionBitsToShift);
        boolean result = false;
        switch (TermUnblocker.unblock(logMetaDataBuffer, termBuffer, blockedOffset, tailOffset, termId)) {
            case UNBLOCKED_TO_END: {
                LogBufferDescriptor.rotateLog(logMetaDataBuffer, index, termId + 1);
            }
            case UNBLOCKED: {
                result = true;
            }
        }
        return result;
    }
}

