/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.status;

import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;

public enum SystemCounterDescriptor {
    BYTES_SENT(0, "Bytes sent"),
    BYTES_RECEIVED(1, "Bytes received"),
    RECEIVER_PROXY_FAILS(2, "Failed offers to ReceiverProxy"),
    SENDER_PROXY_FAILS(3, "Failed offers to SenderProxy"),
    CONDUCTOR_PROXY_FAILS(4, "Failed offers to DriverConductorProxy"),
    NAK_MESSAGES_SENT(5, "NAKs sent"),
    NAK_MESSAGES_RECEIVED(6, "NAKs received"),
    STATUS_MESSAGES_SENT(7, "Status Messages sent"),
    STATUS_MESSAGES_RECEIVED(8, "Status Messages received"),
    HEARTBEATS_SENT(9, "Heartbeats sent"),
    HEARTBEATS_RECEIVED(10, "Heartbeats received"),
    RETRANSMITS_SENT(11, "Retransmits sent"),
    FLOW_CONTROL_UNDER_RUNS(12, "Flow control under runs"),
    FLOW_CONTROL_OVER_RUNS(13, "Flow control over runs"),
    INVALID_PACKETS(14, "Invalid packets"),
    ERRORS(15, "Errors"),
    SHORT_SENDS(16, "Short sends"),
    CLIENT_KEEP_ALIVES(17, "Client keep-alives"),
    SENDER_FLOW_CONTROL_LIMITS(18, "Sender flow control limits applied"),
    UNBLOCKED_PUBLICATIONS(19, "Unblocked Publications"),
    UNBLOCKED_COMMANDS(20, "Unblocked Control Commands"),
    POSSIBLE_TTL_ASYMMETRY(21, "Possible TTL Asymmetry"),
    CONTROLLABLE_IDLE_STRATEGY(22, "ControllableIdleStrategy status"),
    LOSS_GAP_FILLS(23, "Loss gap fills");

    public static final int SYSTEM_COUNTER_TYPE_ID = 0;
    private static final Int2ObjectHashMap<SystemCounterDescriptor> DESCRIPTOR_BY_ID_MAP;
    private final int id;
    private final String label;

    public static SystemCounterDescriptor get(int id) {
        return (SystemCounterDescriptor)((Object)DESCRIPTOR_BY_ID_MAP.get(id));
    }

    private SystemCounterDescriptor(int id, String label) {
        this.id = id;
        this.label = label;
    }

    public int id() {
        return this.id;
    }

    public String label() {
        return this.label;
    }

    public AtomicCounter newCounter(CountersManager countersManager) {
        return countersManager.newCounter(this.label, 0, buffer -> buffer.putInt(0, this.id));
    }

    static {
        DESCRIPTOR_BY_ID_MAP = new Int2ObjectHashMap();
        for (SystemCounterDescriptor descriptor : SystemCounterDescriptor.values()) {
            if (null == DESCRIPTOR_BY_ID_MAP.put(descriptor.id, (Object)descriptor)) continue;
            throw new IllegalStateException("Descriptor id already in use: " + descriptor.id);
        }
    }
}

