/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.io;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyMessage;

public class Hessian2Output
extends com.caucho.hessian4.io.Hessian2Output
implements Constants {
    public Hessian2Output(OutputStream out) {
        super(out);
        this.setCloseStreamOnClose(true);
    }

    public void writeReply(HessianRPCReplyMessage message) throws IOException {
        this.writeVersion();
        this.startEnvelope("H");
        this.writeHeaders(message);
        if (message.getFault() == null) {
            this.startReply();
            this.writeObject(message.getValue());
            this.completeReply();
        } else {
            Throwable fault = message.getFault();
            if (fault instanceof InvocationTargetException) {
                InvocationTargetException invi = (InvocationTargetException)fault;
                Throwable inviFault = invi.getTargetException();
                if (inviFault != null) {
                    this.writeFault(inviFault.getClass().getSimpleName(), inviFault.getMessage(), inviFault);
                } else {
                    this.writeFault(fault.getClass().getSimpleName(), fault.getMessage(), fault);
                }
            } else {
                this.writeFault(fault.getClass().getSimpleName(), fault.getMessage(), fault);
            }
        }
        this.completeEnvelope();
    }

    public void call(HessianRPCCallMessage message) throws IOException {
        String method = message.getMethod();
        Object[] args = message.getArgs();
        if (args == null) {
            args = new Object[]{};
        }
        Map<Object, Object> headers = message.getHeaders();
        int length = args != null ? args.length : 0;
        this.writeVersion();
        this.startEnvelope("H");
        this.writeHeaders(message.getHeaders());
        this.startCall(method, args.length);
        for (int i = 0; i < length; ++i) {
            this.writeObject(args[i]);
        }
        this.completeCall();
        this.completeEnvelope();
    }

    private void writeHeaders(Map headers) {
        try {
            this.writeInt(headers.size());
            for (Map.Entry entry : headers.entrySet()) {
                this.writeInt((Integer)entry.getKey());
                this.writeObject(entry.getValue());
            }
        }
        catch (Exception ex) {
            Constants.ahessianLogger.warn("", (Throwable)ex);
        }
    }

    private void writeHeaders(HessianRPCReplyMessage message) {
        try {
            this.writeInt(message.getHeadersCount());
            if (message.getCallbackArgs() != null) {
                this.writeInt(CALLBACK_ARGS_HEADER_KEY);
                this.writeObject(message.getCallbackArgs());
            }
            if (message.getCallbackDone() != null) {
                this.writeInt(CALLBACK_DONE_HEADER_KEY);
                this.writeObject(message.getCallbackDone());
            }
            if (message.getCallbackId() != null) {
                this.writeInt(CALLBACK_ID_HEADER_KEY);
                this.writeObject(message.getCallbackId());
            }
            if (message.getCallbackMethod() != null) {
                this.writeInt(CALLBACK_METHOD_HEADER_KEY);
                this.writeObject(message.getCallbackMethod());
            }
            if (message.getCallId() != null) {
                this.writeInt(CALL_ID_HEADER_KEY);
                this.writeObject(message.getCallId());
            }
            if (message.getCallbackCallId() != null) {
                this.writeInt(CALLBACK_CALL_ID_HEADER_KEY);
                this.writeObject(message.getCallbackCallId());
            }
            if (message.getCompleted() != null) {
                this.writeInt(COMPLETED_HEADER_KEY);
                this.writeObject(message.getCompleted());
            }
            if (message.getGroup() != null) {
                this.writeInt(GROUP_HEADER_KEY);
                this.writeObject(message.getGroup());
            }
        }
        catch (Exception ex) {
            Constants.ahessianLogger.warn("", (Throwable)ex);
        }
    }
}

