/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.discovery;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.tasker.BlockBuilders;
import com.xebialabs.deployit.engine.tasker.PhaseContainer;
import com.xebialabs.deployit.engine.tasker.TaskInspectionContext;
import com.xebialabs.deployit.engine.tasker.TaskSpecification;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.service.discovery.DiscoveryContext;
import com.xebialabs.deployit.service.discovery.DiscoveryResult;
import com.xebialabs.deployit.service.discovery.DiscoveryResults;
import com.xebialabs.deployit.service.discovery.DiscoveryTrigger;
import com.xebialabs.deployit.task.TaskMetadata;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.WorkdirCleanerTrigger;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class DiscoveryService {
    public TaskSpecification prepareDiscovery(ConfigurationItem ci, WorkDir workDir) {
        DiscoveryContext inspectionContext = new DiscoveryContext();
        inspectionContext.discovered(ci);
        String description = "Inspection of " + ci.getId();
        PhaseContainer stepBlock = BlockBuilders.steps((String)description, null, (List)Lists.newArrayList()).build();
        TaskSpecification spec = new TaskSpecification(description, Permissions.getAuthentication(), workDir, stepBlock, (TaskInspectionContext)inspectionContext, false);
        spec.getListeners().add(new WorkdirCleanerTrigger(workDir));
        spec.getListeners().add(new DiscoveryTrigger(inspectionContext));
        TaskMetadata.putMetadata((TaskSpecification)spec, (String)"taskType", (String)TaskType.INSPECTION.name());
        return spec;
    }

    public DiscoveryResult getDiscoveryResults(String taskId) {
        DiscoveryResult retrieve = DiscoveryResults.retrieve(taskId);
        Preconditions.checkArgument((retrieve != null ? 1 : 0) != 0, (String)"Could not find any results associated with the id [%s]", (Object)taskId);
        return retrieve;
    }
}

