/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.UserPrincipal;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.selectors.FileSelector;

public class OwnedBySelector
implements FileSelector {
    private String owner;

    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public boolean isSelected(File basedir, String filename, File file) {
        if (this.owner == null) {
            throw new BuildException("the owner attribute is required");
        }
        if (file != null) {
            try {
                UserPrincipal user = Files.getOwner(file.toPath(), new LinkOption[0]);
                return user != null && this.owner.equals(user.getName());
            }
            catch (IOException | UnsupportedOperationException exception) {
                // empty catch block
            }
        }
        return false;
    }
}

