/*
 * Decompiled with CFR 0.152.
 */
package kamon.trace;

import java.util.concurrent.atomic.AtomicLong;
import kamon.trace.Sampler;
import kamon.util.NanoTimestamp$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0001\u0002\u0001\u000f\ta1\t\\8dWN\u000bW\u000e\u001d7fe*\u00111\u0001B\u0001\u0006iJ\f7-\u001a\u0006\u0002\u000b\u0005)1.Y7p]\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003\u000fM\u000bW\u000e\u001d7fe\"A1\u0003\u0001B\u0001B\u0003%A#\u0001\nqCV\u001cX-\u00138OC:|7/Z2p]\u0012\u001c\bCA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u0011)H/\u001b7\n\u0005e1\"\u0001\u0004(b]>Le\u000e^3sm\u0006d\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001e=A\u0011q\u0002\u0001\u0005\u0006'i\u0001\r\u0001\u0006\u0005\bA\u0001\u0011\r\u0011\"\u0003\"\u0003\u0015!\u0018.\\3s+\u0005\u0011\u0003CA\u0012,\u001b\u0005!#BA\u0013'\u0003\u0019\tGo\\7jG*\u0011q\u0005K\u0001\u000bG>t7-\u001e:sK:$(BA\f*\u0015\u0005Q\u0013\u0001\u00026bm\u0006L!\u0001\f\u0013\u0003\u0015\u0005#x.\\5d\u0019>tw\r\u0003\u0004/\u0001\u0001\u0006IAI\u0001\u0007i&lWM\u001d\u0011\t\u000bA\u0002A\u0011A\u0019\u0002\u0017MDw.\u001e7e)J\f7-Z\u000b\u0002eA\u0011\u0011bM\u0005\u0003i)\u0011qAQ8pY\u0016\fg\u000eC\u00037\u0001\u0011\u0005q'\u0001\u0007tQ>,H\u000e\u001a*fa>\u0014H\u000f\u0006\u00023q!)\u0011(\u000ea\u0001)\u0005\u0001BO]1dK\u0016c\u0017\r]:fIRKW.\u001a")
public class ClockSampler
implements Sampler {
    private final long pauseInNanoseconds;
    private final AtomicLong timer;

    private AtomicLong timer() {
        return this.timer;
    }

    @Override
    public boolean shouldTrace() {
        long now = NanoTimestamp$.MODULE$.now();
        long lastTimer = this.timer().get();
        return lastTimer + this.pauseInNanoseconds < now ? this.timer().compareAndSet(lastTimer, now) : false;
    }

    @Override
    public boolean shouldReport(long traceElapsedTime) {
        return true;
    }

    public ClockSampler(long pauseInNanoseconds) {
        this.pauseInNanoseconds = pauseInNanoseconds;
        Predef$.MODULE$.require(pauseInNanoseconds > 0L, (Function0 & java.io.Serializable & Serializable)() -> "kamon.trace.clock-sampler.pause cannot be <= 0");
        this.timer = new AtomicLong(0L);
    }
}

