/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.os.posix;

import com.sun.jna.FromNativeConverter;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.io.CyclicBufferFileInputStream;
import org.rzo.yajsw.io.CyclicBufferFilePrintStream;
import org.rzo.yajsw.os.AbstractProcess;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.os.posix.PosixSpawnMain;
import org.rzo.yajsw.os.posix.PosixUtils;
import org.rzo.yajsw.util.DaemonThreadFactory;

public class PosixProcess
extends AbstractProcess {
    protected int[] _inPipe = new int[2];
    protected int[] _outPipe = new int[2];
    protected int[] _errPipe = new int[2];
    public IntByReference status = new IntByReference();
    int _exitCodeKill = -1;
    protected static final Executor executor = Executors.newCachedThreadPool(new DaemonThreadFactory("posix.process.terminate"));
    protected boolean lock = true;
    protected volatile boolean _terminated = false;
    protected PosixUtils _utils = new PosixUtils();
    boolean _stopWaiter = false;
    String[] _env = null;
    int stdout = -1;
    int stderr = -1;
    int stdin = -1;
    Pointer posix_spawn_file_actions;
    Pointer posix_spawnattr;
    long _currentTotalCPU = -1L;
    long _oldTotalCPU = -1L;
    long _lastCPUReadTime = Long.MAX_VALUE;

    @Override
    public void destroy() {
        if (this._outputStream != null) {
            try {
                this._outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this._inputStream != null) {
            try {
                this._inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this._errorStream != null) {
            try {
                this._errorStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        CLibrary.INSTANCE.close(this._inPipe[1]);
        CLibrary.INSTANCE.close(this._outPipe[0]);
        CLibrary.INSTANCE.close(this._errPipe[0]);
        CLibrary.INSTANCE.close(this._inPipe[0]);
        CLibrary.INSTANCE.close(this._outPipe[1]);
        CLibrary.INSTANCE.close(this._errPipe[1]);
        if (this.posix_spawnattr != null) {
            CLibrary.INSTANCE.posix_spawnattr_destroy(this.posix_spawnattr);
        }
        if (this.posix_spawn_file_actions != null) {
            CLibrary.INSTANCE.posix_spawn_file_actions_destroy(this.posix_spawn_file_actions);
        }
        if (Platform.isLinux()) {
            if (this.posix_spawn_file_actions != null) {
                Native.free(Pointer.nativeValue((Pointer)this.posix_spawn_file_actions));
            }
            if (this.posix_spawnattr != null) {
                Native.free(Pointer.nativeValue((Pointer)this.posix_spawnattr));
            }
        }
        this.posix_spawnattr = null;
        this.posix_spawn_file_actions = null;
    }

    @Override
    public Collection getChildren() {
        return null;
    }

    @Override
    public int getCurrentPageFaults() {
        return 0;
    }

    @Override
    public long getCurrentPhysicalMemory() {
        return 0L;
    }

    @Override
    public long getCurrentVirtualMemory() {
        long result;
        block4: {
            result = -1L;
            if (!this.isRunning()) {
                return result;
            }
            String stat2 = this._utils.readFile("/proc/" + this._pid + "/stat");
            if (this.status != null) {
                try {
                    String sp = "(?:[^\\s]+[\\s]+){22}(\\d+).+";
                    Pattern p = Pattern.compile(sp, 32);
                    Matcher m = p.matcher(stat2);
                    m.find();
                    result = Long.parseLong(m.group(1).trim());
                }
                catch (Exception ex) {
                    if (this._logger == null) break block4;
                    this._logger.info("Error in getCurrentVirtualMemory() " + ex.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public boolean isRunning() {
        if (this._pid < 1) {
            return false;
        }
        return this._exitCode < 0;
    }

    @Override
    public int getExitCode() {
        if (this._exitCodeKill >= 0) {
            return this._exitCodeKill;
        }
        return this._exitCode;
    }

    @Override
    public boolean kill(int code) {
        if (this._logger != null) {
            this._logger.info("killing " + this._pid);
        }
        int count = 0;
        while (this._exitCode < 0 && count < 3) {
            int r;
            ++count;
            if (this._logger != null) {
                this._logger.info("send kill sig");
            }
            if ((r = CLibrary.INSTANCE.kill(this._pid, 9)) == 0) {
                this._exitCodeKill = code;
                return true;
            }
            if (this._logger != null) {
                this._logger.fine("error calling kill: " + r);
            }
            if (this._exitCode >= 0) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
        return false;
    }

    @Override
    public boolean killTree(int code) {
        return false;
    }

    @Override
    public boolean start() {
        if (this._arrCmd == null && this._cmd == null) {
            return false;
        }
        if (this._arrCmd == null) {
            this._arrCmd = this._cmd.split(" ");
            this.log("exec: " + this._cmd);
        } else {
            String cmd = "";
            for (String c : this._arrCmd) {
                if (c == null) continue;
                if (c != null && c.indexOf(32) > -1 && c.indexOf(34) == -1) {
                    c = "\"" + c + "\"";
                }
                cmd = cmd + c + " ";
            }
            this.log("exec:" + cmd);
        }
        if (this.stdout == -1) {
            this.stdout = this.getStdOutNo();
            this.stderr = this.getStdErrNo();
            this.stdin = this.getStdInNo();
        }
        if (this._environment.size() > 0) {
            this._env = new String[this._environment.size()];
            int i = 0;
            for (String[] entry : this._environment) {
                this._env[i++] = entry[0] + "=" + entry[1];
            }
        } else {
            this._env = null;
        }
        int pid = 0;
        this._exitCode = -2;
        String title = this._title == null ? "yajsw" : this._title;
        this._terminated = false;
        if (this._visible) {
            this.setCommand(String.format("xterm -hold -sb -T %1$s -e %2$s", title, this.getCommand()));
        }
        if (this._visible) {
            this._pipeStreams = false;
        }
        CLibrary.INSTANCE.pipe(this._inPipe);
        CLibrary.INSTANCE.pipe(this._outPipe);
        CLibrary.INSTANCE.pipe(this._errPipe);
        String forkLogName = "forkLog" + System.currentTimeMillis() + ".log";
        if (this._useSpawn) {
            return this.doSpawn();
        }
        pid = CLibrary.INSTANCE.fork();
        if (pid == 0) {
            if (this._umask != -1) {
                PosixProcess.umask(this._umask);
            }
            System.out.println("fork 0");
            if (this.getWorkingDir() != null && CLibrary.INSTANCE.chdir(this.getWorkingDir()) != 0) {
                this.log("could not set working dir");
            }
            System.out.println("fork 1");
            if (this._priority == -1) {
                if (CLibrary.INSTANCE.nice(1) == -1) {
                    this.log("could not set priority ");
                }
            } else if (this._priority == -2) {
                if (CLibrary.INSTANCE.nice(2) == -1) {
                    this.log("could not set priority ");
                }
            } else if (this._priority == 1) {
                if (CLibrary.INSTANCE.nice(-1) == -1) {
                    this.log("could not set priority ");
                }
            } else if (this._priority == 2 && CLibrary.INSTANCE.nice(-2) == -1) {
                this.log("could not set priority ");
            }
            if (this.getUser() != null) {
                this.switchUser(this.getUser(), this.getPassword());
            }
            System.out.println("fork 2");
            CLibrary.INSTANCE.close(this._inPipe[1]);
            this.moveDescriptor(this._inPipe[0], this.stdin);
            CLibrary.INSTANCE.close(this._outPipe[0]);
            this.moveDescriptor(this._outPipe[1], this.stdout);
            CLibrary.INSTANCE.close(this._errPipe[0]);
            this.moveDescriptor(this._errPipe[1], this.stderr);
            try {
                CLibrary.INSTANCE.umask(0);
                if (CLibrary.INSTANCE.setsid() < 0) {
                    CLibrary.INSTANCE.exit(-1);
                }
                int res = this._env != null ? CLibrary.INSTANCE.execvpe(this._arrCmd[0], this._arrCmd, this._env) : CLibrary.INSTANCE.execvp(this._arrCmd[0], this._arrCmd);
                int err = Native.getLastError();
                this.log("error in execv: errno " + err + " " + CLibrary.INSTANCE.strerror(err));
                this.log("exec res " + res);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.lock = false;
        } else {
            if (pid > 0) {
                this._pid = pid;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.doPostStart();
                return true;
            }
            if (pid < 0) {
                if (this._logger != null) {
                    this._logger.info("failed to fork: " + pid);
                }
                return false;
            }
        }
        return false;
    }

    private void doPostStart() {
        block18: {
            if (this._teeName != null && this._tmpPath != null) {
                block17: {
                    File f = new File(this._tmpPath);
                    try {
                        if (!f.exists()) {
                            f.mkdir();
                        }
                    }
                    catch (Exception ex) {
                        if (this._logger != null) {
                            this._logger.throwing(PosixProcess.class.getName(), "start", ex);
                        }
                        Thread.currentThread().interrupt();
                    }
                    try {
                        this._inputStream = new CyclicBufferFileInputStream(this.createRWfile(this._tmpPath, "out_" + this._teeName));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        this._errorStream = new CyclicBufferFileInputStream(this.createRWfile(this._tmpPath, "err_" + this._teeName));
                    }
                    catch (Exception e) {
                        if (this._logger == null) break block17;
                        this._logger.throwing(PosixProcess.class.getName(), "start", e);
                    }
                }
                try {
                    this._outputStream = new CyclicBufferFilePrintStream(this.createRWfile(this._tmpPath, "in_" + this._teeName));
                }
                catch (Exception e) {
                    if (this._logger == null) break block18;
                    this._logger.throwing(PosixProcess.class.getName(), "start", e);
                }
            }
        }
        System.out.println("post start " + this._pipeStreams + " " + this._teeName);
        if (this._pipeStreams && this._teeName == null) {
            System.out.println("setting fd");
            this.writefd(this.in_fd, this._inPipe[1]);
            this.writefd(this.out_fd, this._outPipe[0]);
            this.writefd(this.err_fd, this._errPipe[0]);
            this._outputStream = new BufferedOutputStream(new FileOutputStream(this.in_fd));
            this._inputStream = new BufferedInputStream(new FileInputStream(this.out_fd));
            this._errorStream = new BufferedInputStream(new FileInputStream(this.err_fd));
            CLibrary.INSTANCE.close(this._inPipe[0]);
            CLibrary.INSTANCE.close(this._outPipe[1]);
            CLibrary.INSTANCE.close(this._errPipe[1]);
        }
        if (this._cpuAffinity != -99L) {
            LongByReference affinity = new LongByReference();
            affinity.setValue(this._cpuAffinity);
            if (CLibrary.INSTANCE.sched_setaffinity(this._pid, 4, affinity) == -1) {
                this.log("error setting affinity");
            } else if (this._debug) {
                this.log("Affinity set to: " + Long.toBinaryString(this._cpuAffinity));
            }
        }
        this._stopWaiter = true;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                int r = 0;
                while (r != PosixProcess.this._pid && r != -1) {
                    r = CLibrary.INSTANCE.waitpid(PosixProcess.this._pid, PosixProcess.this.status, 0);
                    if (PosixProcess.this._logger == null) continue;
                    PosixProcess.this._logger.info("waitpid " + r + " " + PosixProcess.this.status.getValue());
                }
                if (r == PosixProcess.this._pid) {
                    int code = PosixProcess.this.status.getValue();
                    PosixProcess.this._exitCode = PosixProcess.this.WEXITSTATUS(code);
                    PosixProcess.this._exitSignal = PosixProcess.this.WTERMSIG(code);
                }
                if (PosixProcess.this._logger != null) {
                    PosixProcess.this._logger.info("exit code posix process: " + PosixProcess.this.status.getValue() + " application(status/signal): " + PosixProcess.this._exitCode + "/" + PosixProcess.this._exitSignal);
                }
                PosixProcess.this._terminated = true;
            }
        });
        if (this._logger != null) {
            this._logger.info("started process " + this._pid);
        }
    }

    private boolean doSpawn() {
        int result;
        IntByReference refpid = new IntByReference();
        this.posix_spawn_file_actions = this.getSpawnPipes();
        this.posix_spawnattr = this.getSpawnAttr();
        String[] spawnCmd = this.getSpawnCmdLine();
        for (int i = 0; i < spawnCmd.length; ++i) {
            String c = spawnCmd[i];
            if (!c.startsWith("\"")) continue;
            spawnCmd[i] = c = c.replaceAll("\"", "");
        }
        if (this._debug) {
            System.out.println("spawnCmd: ");
            for (String c : spawnCmd) {
                System.out.print(c);
                System.out.print(" ");
            }
            System.out.println();
        }
        if ((result = CLibrary.INSTANCE.posix_spawnp(refpid, spawnCmd[0], this.posix_spawn_file_actions, this.posix_spawnattr, spawnCmd, this._env)) == 0) {
            this._pid = refpid.getValue();
            this.log("posix_spawn pid " + this._pid);
            this.doPostStart();
        } else {
            this.log("posix spawn error: " + result);
        }
        return result == 0;
    }

    private String getDOption(String key, String value) {
        return "-D" + key + "=" + value;
    }

    private String getCurrentJava() {
        int firstSpace;
        int myPid = OperatingSystem.instance().processManagerInstance().currentProcessId();
        Process myProcess = OperatingSystem.instance().processManagerInstance().getProcess(myPid);
        String cmd = myProcess.getCommand();
        String jvm = null;
        jvm = cmd.startsWith("\"") ? cmd.substring(0, cmd.indexOf("\" ") + 1) : ((firstSpace = cmd.indexOf(" ")) > -1 ? cmd.substring(0, firstSpace) : cmd);
        return jvm;
    }

    private boolean checkPath(String path) {
        int ix = path.indexOf("!");
        if (ix == -1) {
            this.log("<yajsw>/lib/core/jna/jna-xxx.jar not found, please check classpath. aborting wrapper !");
            return false;
        }
        return true;
    }

    private String getStartClasspath() {
        String wrapperJar = WrapperLoader.getWrapperJar();
        File wrapperHome = new File(wrapperJar).getParentFile();
        File jnaFile = new File(this.getJNAJar());
        try {
            return wrapperJar + ":" + jnaFile.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getJNAJar() {
        String cn = FromNativeConverter.class.getCanonicalName();
        String rn = cn.replace('.', '/') + ".class";
        String path = ".";
        try {
            path = FromNativeConverter.class.getClassLoader().getResource(rn).getPath();
            if (!this.checkPath(path)) {
                return null;
            }
            path = path.substring(0, path.indexOf("!"));
            path = new URI(path).getPath();
            path.replaceAll("%20", " ");
            return path;
        }
        catch (Exception e1) {
            this.log("could not find jna jar", e1);
            return null;
        }
    }

    private String[] getXEnv() {
        List<String[]> env = this.getEnvironment();
        if (env != null && !env.isEmpty()) {
            String[] result = new String[env.size()];
            int i = 0;
            for (String[] x : env) {
                result[i] = x[0] + "=" + x[1];
                if (this._debug) {
                    this.log("posix spawn setting env var " + result[i]);
                }
                ++i;
            }
            return result;
        }
        return null;
    }

    private String[] getSpawnCmdLine() {
        String opt;
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(this.getCurrentJava());
        String tmpDir = this._tmpPath;
        if (tmpDir == null) {
            tmpDir = System.getProperty("jna_tmpdir", null);
        }
        if (tmpDir != null && !cmdList.contains(opt = this.getDOption("jna_tmpdir", tmpDir))) {
            cmdList.add(opt);
        }
        cmdList.add("-classpath");
        cmdList.add(this.getStartClasspath());
        if (this._pipeStreams) {
            cmdList.add("-Dwrapperx.pipeStreams=true");
        }
        if (this._user != null) {
            cmdList.add("-Dwrapperx.user=" + this._user);
        }
        if (this._umask != -1) {
            cmdList.add("-Dwrapperx.umask=" + this._umask);
        }
        if (this._priority == -1) {
            cmdList.add("-Dwrapperx.nice=1");
        } else if (this._priority == -2) {
            cmdList.add("-Dwrapperx.nice=2");
        } else if (this._priority == 1) {
            cmdList.add("-Dwrapperx.nice=-1");
        } else if (this._priority == 2) {
            cmdList.add("-Dwrapperx.nice=-2");
        }
        if (this.getWorkingDir() != null && this.getWorkingDir().length() > 0) {
            String wdir = this.getWorkingDir();
            wdir = wdir.replaceAll("\"", "");
            cmdList.add("-Dwrapperx.workingdir=" + wdir);
        }
        String[] xenv = this.getXEnv();
        cmdList.add(PosixSpawnMain.class.getName());
        for (int i = 0; i < this._arrCmd.length; ++i) {
            cmdList.add(this._arrCmd[i]);
        }
        String[] cmd = new String[cmdList.size()];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cmd.length; ++i) {
            cmd[i] = (String)cmdList.get(i);
            if (!this._debug) continue;
            sb.append(cmd[i] + " ");
        }
        if (this._debug) {
            this.log("spawn exec: " + sb.toString());
        }
        return cmd;
    }

    private Pointer getSpawnAttr() {
        Memory result = null;
        if (Platform.isLinux()) {
            long peer = Native.malloc(340L);
            result = new Pointer(peer);
        } else {
            result = new Memory((long)Pointer.SIZE);
        }
        try {
            int rc = CLibrary.INSTANCE.posix_spawnattr_init((Pointer)result);
            this.checkReturnCode(rc, "Internal call to posix_spawnattr_init() failed");
            short flags = 0;
            if (Platform.isLinux() && this._linuxUseVfork) {
                flags = 64;
            } else if (Platform.isMac()) {
                flags = 0;
            }
            rc = CLibrary.INSTANCE.posix_spawnattr_setflags((Pointer)result, flags);
            this.checkReturnCode(rc, "Internal call to posix_spawnattr_setflags() failed");
        }
        catch (Exception ex) {
            this.log("error in getSpawnAttr ", ex);
            return null;
        }
        return result;
    }

    private Pointer getSpawnPipes() {
        int rc = 0;
        Memory result = null;
        if (Platform.isLinux()) {
            long peer = Native.malloc(80L);
            result = new Pointer(peer);
        } else {
            result = new Memory((long)Pointer.SIZE);
        }
        try {
            rc = CLibrary.INSTANCE.posix_spawn_file_actions_init((Pointer)result);
            this.checkReturnCode(rc, "Internal call to posix_spawn_file_actions_init() failed");
            rc = CLibrary.INSTANCE.posix_spawn_file_actions_addclose((Pointer)result, this._inPipe[1]);
            this.checkReturnCode(rc, "inPipe1: Internal call to posix_spawn_file_actions_addclose() failed");
            rc = CLibrary.INSTANCE.posix_spawn_file_actions_adddup2((Pointer)result, this._inPipe[0], this.stdin);
            this.checkReturnCode(rc, "inPipe: Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = CLibrary.INSTANCE.posix_spawn_file_actions_addclose((Pointer)result, this._inPipe[0]);
            this.checkReturnCode(rc, "inPipe: Internal call to posix_spawn_file_actions_addclose() failed");
            rc = CLibrary.INSTANCE.posix_spawn_file_actions_addclose((Pointer)result, this._outPipe[0]);
            this.checkReturnCode(rc, "outPipe0: Internal call to posix_spawn_file_actions_addclose() failed");
            rc = CLibrary.INSTANCE.posix_spawn_file_actions_adddup2((Pointer)result, this._outPipe[1], this.stdout);
            this.checkReturnCode(rc, "outPipe: Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = CLibrary.INSTANCE.posix_spawn_file_actions_addclose((Pointer)result, this._outPipe[1]);
            this.checkReturnCode(rc, "outPipe: Internal call to posix_spawn_file_actions_addclose() failed");
            rc = CLibrary.INSTANCE.posix_spawn_file_actions_addclose((Pointer)result, this._errPipe[0]);
            this.checkReturnCode(rc, "errPipe0: Internal call to posix_spawn_file_actions_addclose() failed");
            rc = CLibrary.INSTANCE.posix_spawn_file_actions_adddup2((Pointer)result, this._errPipe[1], this.stderr);
            this.checkReturnCode(rc, "errPipe: Internal call to posix_spawn_file_actions_adddup2() failed");
            rc = CLibrary.INSTANCE.posix_spawn_file_actions_addclose((Pointer)result, this._errPipe[1]);
            this.checkReturnCode(rc, "errPipe: Internal call to posix_spawn_file_actions_addclose() failed");
            return result;
        }
        catch (RuntimeException e) {
            this.log("Error in posix_spawn", e);
            CLibrary.INSTANCE.posix_spawn_file_actions_destroy(this.posix_spawn_file_actions);
            this.initFailureCleanup(this._inPipe, this._outPipe, this._errPipe);
            throw e;
        }
    }

    private void initFailureCleanup(int[] in, int[] out, int[] err) {
        HashSet<Integer> unique = new HashSet<Integer>();
        if (in != null) {
            unique.add(in[0]);
            unique.add(in[1]);
        }
        if (out != null) {
            unique.add(out[0]);
            unique.add(out[1]);
        }
        if (err != null) {
            unique.add(err[0]);
            unique.add(err[1]);
        }
        Iterator iterator = unique.iterator();
        while (iterator.hasNext()) {
            int fildes = (Integer)iterator.next();
            if (fildes == 0) continue;
            CLibrary.INSTANCE.close(fildes);
        }
    }

    private void checkReturnCode(int rc, String string) {
        if (rc != 0) {
            this.log(string);
        }
    }

    public int WIFEXITED(int code) {
        return code & 0xFF;
    }

    public int WTERMSIG(int code) {
        return code & 0x7F;
    }

    public int WEXITSTATUS(int code) {
        return code >> 8 & 0xFF;
    }

    protected File createRWfile(String path, String fname) throws IOException {
        File result = new File(path, fname);
        result.deleteOnExit();
        return result;
    }

    @Override
    public boolean stop(int timeout, int code) {
        if (this._logger != null) {
            this._logger.info("killing " + this._pid);
        }
        if (!this.isRunning()) {
            return true;
        }
        int r = CLibrary.INSTANCE.kill(this._pid, 15);
        this.waitFor(timeout);
        int count = 0;
        while (this.isRunning() && count++ < 4) {
            CLibrary.INSTANCE.kill(this._pid, 9);
            if (!this.isRunning()) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                if (this._logger != null) {
                    this._logger.throwing(PosixProcess.class.getName(), "stop", e);
                }
                Thread.currentThread().interrupt();
            }
        }
        return !this.isRunning();
    }

    protected void moveDescriptor(int fd_from, int fd_to) {
        if (fd_from != fd_to) {
            CLibrary.INSTANCE.dup2(fd_from, fd_to);
            CLibrary.INSTANCE.close(fd_from);
        }
    }

    int closeDescriptors(int[] avoid) {
        int i;
        for (i = 10; i < 54; ++i) {
            CLibrary.INSTANCE.close(i);
        }
        for (i = 56; i < 76; ++i) {
            CLibrary.INSTANCE.close(i);
        }
        return 1;
    }

    @Override
    public void waitFor() {
        this.waitFor(Long.MAX_VALUE);
    }

    @Override
    public void waitFor(long timeout) {
        long start = System.currentTimeMillis();
        File f = new File("/proc/" + this._pid);
        while (System.currentTimeMillis() - start < timeout) {
            if (!this.isRunning() || !f.exists()) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                if (this._logger != null) {
                    this._logger.throwing(PosixProcess.class.getName(), "waitFor", e);
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        PosixProcess[] p = new PosixProcess[1];
        boolean pipe = true;
        for (int i = 0; i < p.length; ++i) {
            p[i] = new PosixProcess();
            p[i].setVisible(false);
            p[i].setDebug(true);
            p[i].setUseSpawn(true);
            p[i].setCommand(new String[]{"ping", "127.0.0.1"});
            p[i].setPipeStreams(pipe, false);
            p[i].setLinuxUseVfork(true);
        }
        boolean doit = true;
        int k = 0;
        while (doit) {
            int i;
            doit = k++ < 3;
            for (i = 0; i < p.length; ++i) {
                p[i].start();
                try {
                    Thread.yield();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                if (!pipe) continue;
                final PosixProcess pp = p[i];
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        InputStreamReader isr = new InputStreamReader(pp.getInputStream());
                        BufferedReader br = new BufferedReader(isr);
                        String line = "?";
                        int k = 0;
                        try {
                            while ((line = br.readLine()) != null) {
                                System.out.println(new Date() + " " + line);
                                ++k;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return;
                        }
                    }
                }).start();
            }
            p[0].waitFor(30000L);
            System.out.println("KILL");
            for (i = 0; i < p.length; ++i) {
                p[i].kill(999);
                System.out.println("exit code " + p[i].getExitCode());
                p[i].destroy();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void writefd(FileDescriptor fd, int pointer) {
        try {
            Field handleField = FileDescriptor.class.getDeclaredField("fd");
            handleField.setAccessible(true);
            Field peerField = Pointer.class.getDeclaredField("peer");
            peerField.setAccessible(true);
            long value = pointer;
            handleField.setInt(fd, (int)value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean reconnectStreams() {
        if (this._teeName != null) {
            try {
                this._inputStream = new CyclicBufferFileInputStream(new File(this._tmpPath, "out_" + this._teeName));
                this._errorStream = new CyclicBufferFileInputStream(new File(this._tmpPath, "err_" + this._teeName));
                this._outputStream = new CyclicBufferFilePrintStream(new File(this._tmpPath, "in_" + this._teeName));
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    private String getCommandInternal() {
        String result = this._utils.readFileQuoted("/proc/" + this.getPid() + "/cmdline");
        if (result == null || result.length() == 0) {
            result = "?";
        }
        return result;
    }

    private List<String[]> getEnvironmentInternal() {
        String result = this._utils.readFile("/proc/" + this.getPid() + "/environ");
        return this.parseEnvironment(result);
    }

    private List<String[]> parseEnvironment(String env) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (env == null || "".equals(env)) {
            return result;
        }
        String sp = "(\\S+)=([^=.]+)( |$)";
        Pattern p = Pattern.compile(sp, 32);
        Matcher m = p.matcher(env);
        while (m.find()) {
            String[] str = m.group().trim().split("=", 2);
            if (str.length != 2) continue;
            result.add(new String[]{str[0], str[1]});
        }
        return result;
    }

    protected String getWorkingDirInternal() {
        String result = null;
        File f = new File("/proc/" + this.getPid() + "/cwd");
        try {
            result = f.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public String getWorkingDir() {
        return this._workingDir;
    }

    public static Process getProcess(int pid) {
        PosixProcess result = null;
        File f = new File("/proc/" + pid);
        if (f.exists()) {
            result = (PosixProcess)OperatingSystem.instance().processManagerInstance().createProcess();
            result._pid = pid;
            result._user = result.getUserInternal();
            result._cmd = result.getCommandInternal();
            result._workingDir = result.getWorkingDirInternal();
            result._environment = result.getEnvironmentInternal();
        }
        return result;
    }

    public static int currentProcessId() {
        return CLibrary.INSTANCE.getpid();
    }

    public String currentUser() {
        int euid = CLibrary.INSTANCE.geteuid();
        Pointer p = CLibrary.INSTANCE.getpwuid(euid);
        if (p == null) {
            this.log("could not get current user");
        }
        return new CLibrary.passwd(p).getName();
    }

    public String currentGroup() {
        int egid = CLibrary.INSTANCE.getegid();
        Pointer pg = CLibrary.INSTANCE.getgrgid(egid);
        if (pg == null) {
            this.log("could not get current group");
            return null;
        }
        return new CLibrary.group(pg).getName();
    }

    public String defaultGroup(String user) {
        Pointer p = CLibrary.INSTANCE.getpwnam(user);
        if (p == null) {
            this.log("could not get user " + user);
            return null;
        }
        int gid = new CLibrary.passwd(p).getGid();
        Pointer pg = CLibrary.INSTANCE.getgrgid(gid);
        if (pg == null) {
            this.log("could not get default group for user " + user);
            return null;
        }
        return new CLibrary.group(pg).getName();
    }

    public void switchUser(String name, String password) {
        Pointer p;
        String group2;
        if (name == null || "".equals(name)) {
            return;
        }
        String[] x = name.split("\\\\");
        String user = x.length == 1 ? x[0] : x[1];
        String string = group2 = x.length == 1 ? null : x[0];
        if (group2 == null) {
            group2 = this.defaultGroup(user);
        }
        String currentUser = this.currentUser();
        String currentGroup = this.currentGroup();
        this.log("switch group " + currentGroup + " -> " + group2);
        if (currentGroup != null && !currentGroup.equals(group2)) {
            int res;
            p = CLibrary.INSTANCE.getgrnam(group2);
            CLibrary.group g = new CLibrary.group(p);
            int newGid = g.getGid();
            String nam = g.getName();
            if (newGid == 0) {
                this.log("could not get group " + group2);
            }
            if ((res = CLibrary.INSTANCE.setregid(newGid, newGid)) != 0) {
                this.log("could not change to group " + group2);
            } else {
                try {
                    res = CLibrary.INSTANCE.initgroups(user, newGid);
                    if (res != 0) {
                        this.log("could not set supplement group for user " + group2 + "/" + user);
                    }
                }
                catch (Throwable ex) {
                    this.log("error invoking initgroups " + ex.getMessage());
                }
            }
        }
        this.log("switch user " + currentUser + " -> " + user);
        if (currentUser != null && !currentUser.equals(user)) {
            int res;
            p = CLibrary.INSTANCE.getpwnam(user);
            int newUid = new CLibrary.passwd(p).getUid();
            if (newUid == 0) {
                this.log("could not get user " + user);
            }
            if ((res = CLibrary.INSTANCE.setreuid(newUid, newUid)) != 0) {
                this.log("could not change to user " + user);
            }
        }
        if (!user.equals(currentUser = this.currentUser())) {
            this.log("could not set user. current user: " + currentUser);
        }
        if (!group2.equals(currentGroup = this.currentGroup())) {
            this.log("could not set group. current group: " + currentGroup);
        }
    }

    public String getUserInternal() {
        String status = this._utils.readFile("/proc/" + this._pid + "/status");
        if (status != null) {
            try {
                String sp = ".*[U|u]id:\\s*(\\d+)\\s*(\\d+)\\s*(\\d+)\\s*(\\d+).*";
                Pattern p = Pattern.compile(sp, 32);
                Matcher m = p.matcher(status);
                m.find();
                int ruid = Integer.parseInt(m.group(1));
                Pointer po = CLibrary.INSTANCE.getpwuid(ruid);
                if (po == null) {
                    System.out.println("could not get user");
                }
                return new CLibrary.passwd(po).getName().trim();
            }
            catch (Exception ex) {
                this.log("Error in getUser() " + ex.getMessage());
            }
        }
        return "";
    }

    @Override
    public String getUser() {
        return this._user;
    }

    public String getStdInName() {
        return "stdin";
    }

    public String getStdOutName() {
        return "stdout";
    }

    public String getStdErrName() {
        return "stderr";
    }

    public int getStdOutNo() {
        try {
            return CLibrary.INSTANCE.fileno(NativeLibrary.getInstance((String)"c").getFunction(this.getStdOutName()).getPointer(0L));
        }
        catch (Throwable ex) {
            this.log("error getting stdout no -> return default. " + ex.getMessage());
            return 1;
        }
    }

    public int getStdErrNo() {
        try {
            return CLibrary.INSTANCE.fileno(NativeLibrary.getInstance((String)"c").getFunction(this.getStdErrName()).getPointer(0L));
        }
        catch (Throwable ex) {
            this.log("error getting stderr no -> return default. " + ex.getMessage());
            return 2;
        }
    }

    public int getStdInNo() {
        try {
            return CLibrary.INSTANCE.fileno(NativeLibrary.getInstance((String)"c").getFunction(this.getStdInName()).getPointer(0L));
        }
        catch (Throwable ex) {
            this.log("error getting stdin no -> return default. " + ex.getMessage());
            return 0;
        }
    }

    @Override
    public int getCurrentHandles() {
        if (!this.isRunning()) {
            return -1;
        }
        File f = new File("/proc/" + this._pid + "/fd");
        if (!f.exists() || !f.isDirectory()) {
            return -1;
        }
        return f.list().length;
    }

    @Override
    public int getCurrentThreads() {
        int result;
        block4: {
            result = -1;
            if (!this.isRunning()) {
                return result;
            }
            String status = this._utils.readFile("/proc/" + this._pid + "/status");
            if (status != null) {
                try {
                    String sp = ".*[T|t]hreads:\\s*(\\d+).*";
                    Pattern p = Pattern.compile(sp, 32);
                    Matcher m = p.matcher(status);
                    m.find();
                    result = Integer.parseInt(m.group(1));
                }
                catch (Exception ex) {
                    if (this._logger == null) break block4;
                    this._logger.info("Error in getCurrentThreads() " + ex.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public int getCurrentCpu() {
        int result;
        block5: {
            result = -1;
            if (!this.isRunning()) {
                return result;
            }
            String stat2 = this._utils.readFile("/proc/" + this._pid + "/stat");
            if (this.status != null) {
                try {
                    String sp = "(?:[^\\s]+[\\s]+){13}(\\d+)\\s+(\\d+).+";
                    Pattern p = Pattern.compile(sp, 32);
                    Matcher m = p.matcher(stat2);
                    m.find();
                    int ucpu = Integer.parseInt(m.group(1).trim());
                    int scpu = Integer.parseInt(m.group(2).trim());
                    this._oldTotalCPU = this._currentTotalCPU;
                    this._currentTotalCPU = ucpu + scpu;
                    double elapsed = (double)(System.currentTimeMillis() - this._lastCPUReadTime) / 1000.0;
                    double used = this._currentTotalCPU - this._oldTotalCPU;
                    if (elapsed > 0.0) {
                        result = (int)(used / elapsed);
                    }
                    this._lastCPUReadTime = System.currentTimeMillis();
                }
                catch (Exception ex) {
                    if (this._logger == null) break block5;
                    this._logger.info("Error in getCurrentCPU() " + ex.getMessage());
                }
            }
        }
        return result;
    }

    @Override
    public boolean isTerminated() {
        return this._terminated;
    }

    @Override
    public boolean changeWorkingDir(String name) {
        boolean result;
        String dir;
        File f = new File(name);
        if (!f.exists() || !f.isDirectory()) {
            this.log("changeWorkingDirectory failed. file not found " + name);
            return false;
        }
        try {
            dir = f.getCanonicalPath();
        }
        catch (IOException e) {
            if (this._logger != null) {
                this._logger.throwing(PosixProcess.class.getName(), "setWorkingDirectory", e);
            }
            return false;
        }
        boolean bl = result = CLibrary.INSTANCE.chdir(name) == 0;
        if (result) {
            System.setProperty("user.dir", dir);
        }
        return result;
    }

    public void setTerminated(boolean terminated) {
        this._terminated = terminated;
    }

    @Override
    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this._utils.setLog(logger);
    }

    public static int umask(int mask) {
        int result = CLibrary.INSTANCE.umask(mask);
        return result;
    }

    public long getUptime() {
        try {
            CLibrary.Sysinfo info = new CLibrary.Sysinfo();
            if (0 != CLibrary.INSTANCE.sysinfo(info)) {
                if (this._logger != null) {
                    this._logger.severe("error getting uptime: " + Native.getLastError());
                }
                return 0L;
            }
            return info.uptime.longValue();
        }
        catch (Exception ex) {
            if (this._logger != null) {
                this._logger.severe("error getting uptime: " + ex);
            }
            return 0L;
        }
    }

    public static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = Native.loadLibrary(CLibrary.class);
        public static final short POSIX_SPAWN_START_SUSPENDED = 128;
        public static final short POSIX_SPAWN_CLOEXEC_DEFAULT = 16384;
        public static final int SIGTERM = 15;
        public static final int SIGKILL = 9;
        public static final int ESRCH = 3;
        public static final int WNOHANG = 1;
        public static final int WUNTRACED = 2;
        public static final int S_IFIFO = 4096;
        public static final int S_IFCHR = 8192;
        public static final int S_IFDIR = 16384;
        public static final int S_IFBLK = 24576;
        public static final int S_IFREG = 32768;
        public static final int S_IFLNK = 40960;
        public static final int S_IFSOCK = 49152;
        public static final int S_IFMT = 61440;
        public static final int S_ISUID = 2048;
        public static final int S_ISGID = 1024;
        public static final int S_ISVTX = 512;
        public static final int S_IRUSR = 256;
        public static final int S_IWUSR = 128;
        public static final int S_IXUSR = 64;
        public static final int S_IRGRP = 32;
        public static final int S_IWGRP = 16;
        public static final int S_IXGRP = 8;
        public static final int S_IROTH = 4;
        public static final int S_IWOTH = 2;
        public static final int S_IXOTH = 1;
        public static final int ALL_READ = 292;
        public static final int ALL_WRITE = 146;
        public static final int S_IXUGO = 73;
        public static final int F_GETFL = 3;
        public static final int F_SETFL = 4;
        public static final int O_NONBLOCK = Platform.isMac() ? 4 : 2048;

        public int fork();

        public void exit(int var1);

        public String strerror(int var1);

        public short readlink(String var1, Memory var2, short var3);

        public int execvp(String var1, String[] var2);

        public int execvpe(String var1, String[] var2, String[] var3);

        public int posix_spawnp(IntByReference var1, String var2, Pointer var3, Pointer var4, String[] var5, String[] var6);

        public int posix_spawnattr_init(Pointer var1);

        public int posix_spawnattr_destroy(Pointer var1);

        public int posix_spawnattr_setflags(Pointer var1, short var2);

        public int posix_spawn_file_actions_init(Pointer var1);

        public int posix_spawn_file_actions_destroy(Pointer var1);

        public int posix_spawn_file_actions_addclose(Pointer var1, int var2);

        public int posix_spawn_file_actions_adddup2(Pointer var1, int var2, int var3);

        public int fcntl(int var1, int var2);

        public int fcntl(int var1, int var2, long var3);

        public int pipe(int[] var1);

        public int dup2(int var1, int var2);

        public int close(Pointer var1);

        public int close(int var1);

        public int umask(int var1);

        public int setsid();

        public Pointer freopen(String var1, String var2, int var3);

        public int kill(int var1, int var2);

        public int waitpid(int var1, IntByReference var2, int var3);

        public int chdir(String var1);

        public Pointer getcwd(Memory var1, short var2);

        public int fputc(int var1, Pointer var2);

        public Pointer fdopen(Pointer var1, String var2);

        public int fileno(Pointer var1);

        public Pointer opendir(String var1);

        public dirent64 readdir64(Pointer var1);

        public int closedir(Pointer var1);

        public int nice(int var1);

        public int sched_setaffinity(int var1, int var2, LongByReference var3);

        public int getpid();

        public int symlink(String var1, String var2);

        public Pointer getpwnam(String var1);

        public int geteuid();

        public Pointer getpwuid(int var1);

        public int setreuid(int var1, int var2);

        public int initgroups(String var1, int var2);

        public Pointer getgrgid(int var1);

        public int getegid();

        public Pointer getgrnam(String var1);

        public int setregid(int var1, int var2);

        public int chmod(String var1, int var2);

        public int fstat(int var1, Pointer var2);

        public int sysinfo(Sysinfo var1);

        public static final class Sysinfo
        extends Structure {
            public NativeLong uptime;
            public NativeLong[] loads = new NativeLong[3];
            public NativeLong totalram;
            public NativeLong freeram;
            public NativeLong sharedram;
            public NativeLong bufferram;
            public NativeLong totalswap;
            public NativeLong freeswap;
            public short procs;
            public NativeLong totalhigh;
            public NativeLong freehigh;
            public int mem_unit;
            public byte[] _f = new byte[8];

            protected List<String> getFieldOrder() {
                return Arrays.asList("uptime", "loads", "totalram", "freeram", "sharedram", "bufferram", "totalswap", "freeswap", "procs", "totalhigh", "freehigh", "mem_unit", "_f");
            }
        }

        public static class stat
        extends Structure {
            public long st_dev;
            public short __pad1;
            public int st_ino;
            public int st_mode;
            public int st_nlink;
            public int st_uid;
            public int st_gid;
            public long st_rdev;
            public short __pad2;
            public int st_size;
            public int st_blksize;
            public int st_blocks;
            public int st_atime;
            public int st_atimensec;
            public int st_mtime;
            public int st_mtimensec;
            public int st_ctime;
            public int st_ctimensec;
            public int __unused4;
            public int __unused5;

            protected List getFieldOrder() {
                return Arrays.asList("st_dev", "__pad1", "st_ino", "st_mode", "st_nlink", "st_uid", "st_gid", "st_rdev", "__pad2", "st_size", "st_blksize", "st_blocks", "st_atime", "st_atimensec", "st_mtime", "st_mtimensec", "st_ctime", "st_ctimensec", "__unused4", "__unused5");
            }

            public boolean isSocket() {
                return (this.st_mode & 0xF000) == 49152;
            }
        }

        public static class stat64
        extends Structure {
            public long st_dev;
            public long st_ino;
            public long st_nlink;
            public int st_mode;
            public int st_uid;
            public int st_gid;
            public long st_rdev;
            public long st_size;
            public long st_blksize;
            public long st_blocks;
            public long st_atime;
            public long st_atimensec;
            public long st_mtime;
            public long st_mtimensec;
            public long st_ctime;
            public long st_ctimensec;
            public long __unused4;
            public long __unused5;
            public long __unused6;

            protected List getFieldOrder() {
                return Arrays.asList("st_dev", "st_ino", "st_nlink", "st_mode", "st_uid", "st_gid", "st_rdev", "st_size", "st_blksize", "st_blocks", "st_atime", "st_atimensec", "st_mtime", "st_mtimensec", "st_ctime", "st_ctimensec", "__unused4", "__unused5", "__unused6");
            }

            public boolean isSocket() {
                return (this.st_mode & 0xF000) == 49152;
            }
        }

        public static class group
        extends Structure {
            public String gr_name = null;
            public String gr_password = null;
            public int gr_gid = 0;
            public Pointer gr_mem = null;

            public group(Pointer p) {
                if (p != null) {
                    this.useMemory(p);
                    this.read();
                }
            }

            protected List getFieldOrder() {
                return Arrays.asList("gr_name", "gr_password", "gr_gid", "gr_mem");
            }

            public String getName() {
                return this.gr_name;
            }

            public int getGid() {
                return this.gr_gid;
            }
        }

        public static class passwd
        extends Structure {
            public String pw_name;
            public String pw_passwd;
            public int pw_uid;
            public int pw_gid;
            public String pw_gecos;
            public String pw_dir;
            public String pw_shell;

            public passwd(Pointer p) {
                if (p != null) {
                    this.useMemory(p);
                    this.read();
                }
            }

            protected List getFieldOrder() {
                return Arrays.asList("pw_name", "pw_passwd", "pw_uid", "pw_gid", "pw_gecos", "pw_dir", "pw_shell");
            }

            public String getName() {
                return this.pw_name;
            }

            public int getUid() {
                return this.pw_uid;
            }

            public int getGid() {
                return this.pw_gid;
            }
        }

        public static class dirent
        extends Structure {
            public int d_ino;
            public int d_off;
            public short d_reclen;
            public String d_name;

            protected List getFieldOrder() {
                return Arrays.asList("d_ino", "d_off", "d_reclen", "d_name");
            }
        }

        public static class dirent64
        extends Structure {
            public long d_ino;
            public long d_off;
            public short d_reclen;
            public char d_type;
            public char[] d_name = new char[256];

            protected List getFieldOrder() {
                return Arrays.asList("d_ino", "d_off", "d_reclen", "d_type", "d_name");
            }

            public String getName() {
                return this.getPointer().getString(19L);
            }
        }
    }
}

