/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.heartbeat;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.heartbeat.IntervalTimer;
import org.rzo.netty.ahessian.heartbeat.TimedOutAction;

public class HeartbeatHandlerInbound
extends ChannelInboundHandlerAdapter {
    volatile AtomicLong _lastCalled = new AtomicLong();
    volatile ChannelHandlerContext _ctx;
    final IntervalTimer _intervalTimer;
    final String _name;
    TimedOutAction _action;

    public HeartbeatHandlerInbound(String name, Timer timer, final long timeout) {
        this._name = name;
        TimerTask task = new TimerTask(){

            public void run(Timeout nTimeout) throws Exception {
                if (HeartbeatHandlerInbound.this.getLastCalled() + timeout <= System.currentTimeMillis() && HeartbeatHandlerInbound.this.isConnected()) {
                    try {
                        HeartbeatHandlerInbound.this._action.timedOut(HeartbeatHandlerInbound.this._ctx);
                    }
                    catch (Exception e) {
                        Constants.ahessianLogger.warn("", (Throwable)e);
                    }
                }
            }
        };
        this._intervalTimer = new IntervalTimer(timer, task, timeout);
    }

    long getLastCalled() {
        return this._lastCalled.get();
    }

    boolean isConnected() {
        return this._ctx != null && this._ctx.channel().isActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this._ctx = null;
        this._intervalTimer.stop();
        ctx.fireChannelInactive();
    }

    protected void ping() {
        this._lastCalled.set(System.currentTimeMillis());
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.ping();
        this._ctx = ctx;
        this._intervalTimer.setName(this._name + ":" + this._ctx.channel().hashCode());
        Constants.ahessianLogger.info("AbstractHeartBeatHandler scheduler started: " + this._intervalTimer.getInterval());
        this._intervalTimer.start();
        ctx.fireChannelActive();
    }

    public void setAction(TimedOutAction action) {
        this._action = action;
    }
}

