/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.assertion;

import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.dbunit.assertion.DbUnitAssertBase;
import org.dbunit.assertion.FailureHandler;
import org.dbunit.assertion.comparer.value.ValueComparers;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.UnknownDataType;
import org.dbunit.dataset.filter.DefaultColumnFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUnitAssert
extends DbUnitAssertBase {
    private static final Logger logger = LoggerFactory.getLogger(DbUnitAssert.class);

    public void assertEqualsIgnoreCols(IDataSet expectedDataset, IDataSet actualDataset, String tableName, String[] ignoreCols) throws DatabaseUnitException {
        logger.debug("assertEqualsIgnoreCols(expectedDataset={}, actualDataset={}, tableName={}, ignoreCols={}) - start", new Object[]{expectedDataset, actualDataset, tableName, ignoreCols});
        this.assertEqualsIgnoreCols(expectedDataset.getTable(tableName), actualDataset.getTable(tableName), ignoreCols);
    }

    public void assertEqualsIgnoreCols(ITable expectedTable, ITable actualTable, String[] ignoreCols) throws DatabaseUnitException {
        logger.debug("assertEqualsIgnoreCols(expectedTable={}, actualTable={}, ignoreCols={}) - start", new Object[]{expectedTable, actualTable, ignoreCols});
        ITable expectedTableFiltered = DefaultColumnFilter.excludedColumnsTable(expectedTable, ignoreCols);
        ITable actualTableFiltered = DefaultColumnFilter.excludedColumnsTable(actualTable, ignoreCols);
        this.assertEquals(expectedTableFiltered, actualTableFiltered);
    }

    public void assertEqualsByQuery(IDataSet expectedDataset, IDatabaseConnection connection, String sqlQuery, String tableName, String[] ignoreCols) throws DatabaseUnitException, SQLException {
        logger.debug("assertEqualsByQuery(expectedDataset={}, connection={}, tableName={}, sqlQuery={}, ignoreCols={}) - start", new Object[]{expectedDataset, connection, tableName, sqlQuery, ignoreCols});
        ITable expectedTable = expectedDataset.getTable(tableName);
        this.assertEqualsByQuery(expectedTable, connection, tableName, sqlQuery, ignoreCols);
    }

    public void assertEqualsByQuery(ITable expectedTable, IDatabaseConnection connection, String tableName, String sqlQuery, String[] ignoreCols) throws DatabaseUnitException, SQLException {
        logger.debug("assertEqualsByQuery(expectedTable={}, connection={}, tableName={}, sqlQuery={}, ignoreCols={}) - start", new Object[]{expectedTable, connection, tableName, sqlQuery, ignoreCols});
        ITable expected = DefaultColumnFilter.excludedColumnsTable(expectedTable, ignoreCols);
        ITable queriedTable = connection.createQueryTable(tableName, sqlQuery);
        ITable actual = DefaultColumnFilter.excludedColumnsTable(queriedTable, ignoreCols);
        this.assertEquals(expected, actual);
    }

    public void assertEquals(IDataSet expectedDataSet, IDataSet actualDataSet) throws DatabaseUnitException {
        logger.debug("assertEquals(expectedDataSet={}, actualDataSet={}) - start", (Object)expectedDataSet, (Object)actualDataSet);
        this.assertEquals(expectedDataSet, actualDataSet, null);
    }

    public void assertEquals(IDataSet expectedDataSet, IDataSet actualDataSet, FailureHandler failureHandler) throws DatabaseUnitException {
        this.assertWithValueComparer(expectedDataSet, actualDataSet, failureHandler, null, null);
    }

    protected void compareTables(IDataSet expectedDataSet, IDataSet actualDataSet, String[] expectedNames, FailureHandler failureHandler) throws DatabaseUnitException {
        this.compareTables(expectedDataSet, actualDataSet, expectedNames, failureHandler, null, null);
    }

    public void assertEquals(ITable expectedTable, ITable actualTable) throws DatabaseUnitException {
        logger.debug("assertEquals(expectedTable={}, actualTable={}) - start", (Object)expectedTable, (Object)actualTable);
        this.assertEquals(expectedTable, actualTable, (Column[])null);
    }

    public void assertEquals(ITable expectedTable, ITable actualTable, Column[] additionalColumnInfo) throws DatabaseUnitException {
        logger.debug("assertEquals(expectedTable={}, actualTable={}, additionalColumnInfo={}) - start", new Object[]{expectedTable, actualTable, additionalColumnInfo});
        FailureHandler failureHandler = null;
        if (additionalColumnInfo != null) {
            failureHandler = this.getDefaultFailureHandler(additionalColumnInfo);
        }
        this.assertEquals(expectedTable, actualTable, failureHandler);
    }

    public void assertEquals(ITable expectedTable, ITable actualTable, FailureHandler failureHandler) throws DatabaseUnitException {
        this.assertWithValueComparer(expectedTable, actualTable, failureHandler, ValueComparers.isActualEqualToExpectedWithEmptyFailMessage, null);
    }

    public static class ComparisonColumn {
        private static final Logger logger = LoggerFactory.getLogger(ComparisonColumn.class);
        private String columnName;
        private DataType dataType;

        public ComparisonColumn(String tableName, Column expectedColumn, Column actualColumn, FailureHandler failureHandler) {
            this.columnName = expectedColumn.getColumnName();
            this.dataType = this.getComparisonDataType(tableName, expectedColumn, actualColumn, failureHandler);
        }

        public String getColumnName() {
            return this.columnName;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        private DataType getComparisonDataType(String tableName, Column expectedColumn, Column actualColumn, FailureHandler failureHandler) {
            logger.debug("getComparisonDataType(tableName={}, expectedColumn={}, actualColumn={}, failureHandler={}) - start", new Object[]{tableName, expectedColumn, actualColumn, failureHandler});
            DataType expectedDataType = expectedColumn.getDataType();
            DataType actualDataType = actualColumn.getDataType();
            if (!expectedDataType.getClass().isInstance(actualDataType)) {
                if (expectedDataType instanceof UnknownDataType) {
                    return actualDataType;
                }
                if (actualDataType instanceof UnknownDataType) {
                    return expectedDataType;
                }
                String msg = "Incompatible data types: (table=" + tableName + ", col=" + expectedColumn.getColumnName() + ")";
                throw failureHandler.createFailure(msg, String.valueOf(expectedDataType), String.valueOf(actualDataType));
            }
            return expectedDataType;
        }
    }
}

