/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.model;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.exception.CommandExecutionException;

public class CheckSettingsConfig {
    private List<AbstractConfigurableRule> rules;

    public CheckSettingsConfig() {
    }

    public CheckSettingsConfig(List<AbstractConfigurableRule> list) {
        this.rules = list;
    }

    public List<AbstractConfigurableRule> getRules() {
        return this.rules;
    }

    public AbstractConfigurableRule getRuleById(UUID uUID) {
        for (AbstractConfigurableRule abstractConfigurableRule : this.rules) {
            if (!abstractConfigurableRule.getId().equals(uUID)) continue;
            return abstractConfigurableRule;
        }
        return null;
    }

    public List<AbstractConfigurableRule> getRulesWithMatchingParent(UUID uUID) {
        ArrayList<AbstractConfigurableRule> arrayList = new ArrayList<AbstractConfigurableRule>();
        for (AbstractConfigurableRule abstractConfigurableRule : this.rules) {
            if (!abstractConfigurableRule.getId().equals(uUID) && (!(abstractConfigurableRule instanceof DynamicRule) || !uUID.equals(((DynamicRule)abstractConfigurableRule).getParentRuleId()))) continue;
            arrayList.add(abstractConfigurableRule);
        }
        return arrayList;
    }

    public List<AbstractConfigurableRule> getExecutableRulesByRuleId(UUID uUID) {
        return this.rules.stream().filter(abstractConfigurableRule -> abstractConfigurableRule.getId().equals(uUID) || abstractConfigurableRule instanceof DynamicRule && uUID.equals(((DynamicRule)abstractConfigurableRule).getParentRuleId())).sorted(Comparator.comparing(abstractConfigurableRule -> ((DynamicRule)abstractConfigurableRule).getShortName())).collect(Collectors.toList());
    }

    public DynamicRule getDynamicRuleByShortName(String list) {
        list = this.rules.stream().filter(arg_0 -> CheckSettingsConfig.lambda$getDynamicRuleByShortName$2((String)((Object)list), arg_0)).collect(Collectors.toList());
        if (list.size() > 0) {
            return (DynamicRule)list.get(0);
        }
        return null;
    }

    public DynamicRule getDynamicConfigurableRuleByShortName(String string, String string2) {
        DynamicRule dynamicRule = this.getDynamicRuleByShortName(string);
        if (dynamicRule == null) {
            if (!AbstractChecksCommandStep.findRuleByShortName(string).isConfigurable()) {
                throw new CommandExecutionException(System.lineSeparator() + System.lineSeparator() + "Check '" + string + "' " + string2 + "." + System.lineSeparator() + "Run 'liquibase checks show' to see a list of all available checks and customization options for checks.");
            }
            throw new CommandExecutionException("Check appears to be configurable, but cannot be located in the check settings configuration file.");
        }
        return dynamicRule;
    }

    public void setRules(List<AbstractConfigurableRule> list) {
        this.rules = list;
    }

    public static CheckSettingsConfig generateDefaultConfigFromRules(List<AbstractLiquibaseRule> object) {
        ArrayList<AbstractConfigurableRule> arrayList = new ArrayList<AbstractConfigurableRule>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            AbstractLiquibaseRule abstractLiquibaseRule = (AbstractLiquibaseRule)object.next();
            arrayList.add(AbstractConfigurableRule.fromRuleImplementation(abstractLiquibaseRule));
        }
        return new CheckSettingsConfig(arrayList);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (CheckSettingsConfig)object;
        return Objects.equals(this.rules, ((CheckSettingsConfig)object).rules);
    }

    public int hashCode() {
        return Objects.hash(this.rules);
    }

    private static /* synthetic */ boolean lambda$getDynamicRuleByShortName$2(String string, AbstractConfigurableRule abstractConfigurableRule) {
        return abstractConfigurableRule instanceof DynamicRule && ((DynamicRule)abstractConfigurableRule).getShortName().equalsIgnoreCase(string);
    }
}

