/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.CmdLineArgument;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.ssh.SshElevatedPasswordHandlingStream;
import com.xebialabs.overthere.ssh.SshElevatedUserFile;
import com.xebialabs.overthere.ssh.SshProcess;
import com.xebialabs.overthere.ssh.SshScpConnection;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.InputStream;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SshElevatedUserConnection
extends SshScpConnection {
    public static final String NOELEVATION_PSEUDO_COMMAND = "nosudo";
    public static final String OVERRIDE_ALLOCATE_PTY = "vt220:80:24:0:0";
    protected String elevatedUsername;
    protected String elevatedPassword;
    protected String elevatedPasswordPromptRegex;
    protected String elevationCommandPrefix;
    protected boolean quoteCommand;
    protected boolean preserveAttributesOnCopyFromTempFile;
    protected boolean preserveAttributesOnCopyToTempFile;
    protected boolean overrideUmask;
    protected String copyFromTempFileCommand;
    protected String copyToTempFileCommand;
    protected String overrideUmaskCommand;
    protected String tempMkdirCommand;
    protected String tempMkdirsCommand;
    private Logger logger = LoggerFactory.getLogger(SshElevatedUserConnection.class);

    protected SshElevatedUserConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper);
    }

    protected static void checkElevatedPasswordPromptRegex(SshElevatedUserConnection connection, String optionKey, Logger logger) {
        OverthereUtils.checkArgument(!connection.elevatedPasswordPromptRegex.endsWith("*"), optionKey + " should not end in a wildcard", new Object[0]);
        OverthereUtils.checkArgument(!connection.elevatedPasswordPromptRegex.endsWith("?"), optionKey + " should not end in a wildcard", new Object[0]);
        if (!connection.allocateDefaultPty && connection.allocatePty == null) {
            logger.warn("An {} connection requires a pty, allocating a pty with spec [vt220:80:24:0:0].", (Object)connection.protocolAndConnectionType);
            connection.allocatePty = OVERRIDE_ALLOCATE_PTY;
        }
    }

    @Override
    protected SshProcess createProcess(Session session, CmdLine commandLine) throws TransportException, ConnectionException {
        if (this.elevatedPasswordPromptRegex == null) {
            return super.createProcess(session, commandLine);
        }
        return new SshProcess(this, this.os, session, commandLine){

            @Override
            public InputStream getStdout() {
                return new SshElevatedPasswordHandlingStream(super.getStdout(), this.getStdin(), SshElevatedUserConnection.this.elevatedPassword, SshElevatedUserConnection.this.elevatedPasswordPromptRegex);
            }
        };
    }

    @Override
    protected CmdLine processCommandLine(CmdLine cmd) {
        CmdLine processedCmd;
        this.logger.trace("Checking whether to prefix command line with su/sudo: {}", (Object)cmd);
        if (this.startsWithPseudoCommand(cmd, NOELEVATION_PSEUDO_COMMAND)) {
            this.logger.trace("Not prefixing command line with su/sudo because the nosudo pseudo command was present, but the pseudo command will be stripped");
            processedCmd = super.processCommandLine(SshElevatedUserConnection.stripPrefixedPseudoCommand(cmd));
        } else if (this.quoteCommand) {
            this.logger.trace("Quoting command line and prefixing it with su/sudo");
            processedCmd = this.prefixWithElevationCommand(super.processCommandLine(cmd));
        } else {
            this.logger.trace("Prefixing command line with su/sudo");
            boolean nocd = this.startsWithPseudoCommand(cmd, "nocd");
            processedCmd = nocd ? SshElevatedUserConnection.stripPrefixedPseudoCommand(cmd) : cmd;
            processedCmd = this.prefixWithElevationCommand(processedCmd);
            if (nocd) {
                processedCmd = SshElevatedUserConnection.prefixWithPseudoCommand(processedCmd, "nocd");
            }
            processedCmd = super.processCommandLine(processedCmd);
        }
        this.logger.trace("Processed command line for su/sudo                  : {}", (Object)processedCmd);
        return processedCmd;
    }

    CmdLine prefixWithElevationCommand(CmdLine commandLine) {
        CmdLine commandLineWithSudo = new CmdLine();
        if (this.quoteCommand) {
            commandLineWithSudo.addTemplatedFragment(this.elevationCommandPrefix, this.elevatedUsername);
            commandLineWithSudo.addNested(commandLine);
        } else {
            boolean shouldAddElevationCommand = true;
            for (CmdLineArgument a : commandLine.getArguments()) {
                if (shouldAddElevationCommand && !a.toString(this.os, false).equals("cd")) {
                    commandLineWithSudo.addTemplatedFragment(this.elevationCommandPrefix, this.elevatedUsername);
                }
                shouldAddElevationCommand = false;
                commandLineWithSudo.add(a);
                if (!a.toString(this.os, false).equals("|") && !a.toString(this.os, false).equals(";")) continue;
                shouldAddElevationCommand = true;
            }
        }
        return commandLineWithSudo;
    }

    @Override
    public OverthereFile getFile(String hostPath) throws RuntimeIOException {
        return new SshElevatedUserFile(this, hostPath, false);
    }

    @Override
    public OverthereFile getFile(OverthereFile parent, String child) throws RuntimeIOException {
        this.checkParentFile(parent);
        return new SshElevatedUserFile(this, OverthereUtils.constructPath(parent, child), ((SshElevatedUserFile)parent).isTempFile());
    }

    @Override
    protected OverthereFile getFileForTempFile(OverthereFile parent, String name) {
        this.checkParentFile(parent);
        return new SshElevatedUserFile(this, OverthereUtils.constructPath(parent, name), true);
    }

    @Override
    public String toString() {
        return this.protocolAndConnectionType + "://" + this.username + ":" + this.elevatedUsername + "@" + this.host + ":" + this.port;
    }
}

