/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.jetty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexRestCompatibilityServletRequest
extends HttpServletRequestWrapper {
    public static final String X_HEADER_PREFIX = "X-Header-";
    private final String methodOverrideHeader;
    private transient String method;
    private static Logger logger = LoggerFactory.getLogger(FlexRestCompatibilityServletRequest.class);

    public FlexRestCompatibilityServletRequest(HttpServletRequest request, String methodOverrideHeader) {
        super(request);
        this.methodOverrideHeader = methodOverrideHeader;
    }

    public String getMethod() {
        if (this.method == null) {
            this.method = this.resolveMethod();
        }
        return this.method;
    }

    protected String resolveMethod() {
        String method;
        String headerValue = this.getHeader(this.methodOverrideHeader);
        if (headerValue != null) {
            method = headerValue;
            logger.debug("Overriding " + super.getMethod() + " request to be a " + method + " request because a " + this.methodOverrideHeader + " header was present");
        } else {
            method = super.getMethod();
            logger.debug("Not overriding a " + method + " request");
        }
        return method;
    }

    public String getHeader(String name) {
        String header = this.getHeaderFromParameters(name);
        if (header != null) {
            logger.debug("Header {} resolved from request parameters", (Object)name);
        } else {
            header = super.getHeader(name);
        }
        return header;
    }

    private String getHeaderFromParameters(String name) {
        String headerAsParam = X_HEADER_PREFIX + name;
        return this.getParameter(headerAsParam);
    }

    public String getContentType() {
        String contentType = this.getHeaderFromParameters("Content-Type");
        if (contentType == null) {
            contentType = super.getContentType();
        }
        return contentType;
    }

    public Enumeration<String> getHeaders(String name) {
        ArrayList headers = Collections.list(super.getHeaders(name));
        String headerFromParam = this.getHeaderFromParameters(name);
        if (headerFromParam != null) {
            logger.debug("Header {} resolved from request parameters", (Object)name);
            headers.add(headerFromParam);
        }
        return Collections.enumeration(headers);
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList headers = Collections.list(super.getHeaderNames());
        Enumeration params = this.getParameterNames();
        while (params.hasMoreElements()) {
            String headerInParam;
            String param = (String)params.nextElement();
            if (!param.startsWith(X_HEADER_PREFIX) || headers.contains(headerInParam = param.substring(X_HEADER_PREFIX.length()))) continue;
            logger.debug("Header {} resolved from request parameters", (Object)headerInParam);
            headers.add(headerInParam);
        }
        return Collections.enumeration(headers);
    }
}

