/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.basic;

import com.datical.liquibase.ext.checks.basic.AbstractNotAllowedToContainRule;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.ModifyDataTypeChange;
import liquibase.util.StringUtil;

public class WarnOnDataTypeModification
extends AbstractNotAllowedToContainRule {
    private static Pattern pattern1 = Pattern.compile(".*alter([\\s]*)table([\\s]*|[\\[]*).*modify([\\s]*|[\\[]*).*", 40);
    private static Pattern pattern2 = Pattern.compile(".*alter([\\s]*)table([\\s]*|[\\[]*).*alter([\\s]*)column([\\s]*|[\\[]*).*", 40);

    @Override
    public List<Pattern> getReservedPhrase() {
        return new ArrayList<Pattern>();
    }

    @Override
    public String getFailureMessage() {
        return "Liquibase recommends that changesets which result in modification of a column\u2019s data type are reviewed carefully to prevent the unintentional loss of data.  Review this changeset to confirm that the referenced table is being dropped safely ";
    }

    @Override
    public SeverityEnum getSeverity() {
        return SeverityEnum.MAJOR;
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getDescription() {
        return "This check warns a user when a change will result in modification of a data type so they can ensure that modifying the data type won't lead to unintentional loss of data";
    }

    @Override
    public String getName() {
        return "Warn when 'MODIFY <column>' detected";
    }

    @Override
    public String getShortName() {
        return "ModifyDataTypeWarn";
    }

    @Override
    public int getPriority() {
        return 50;
    }

    @Override
    public List<DynamicRuleParameterEnum> getParameters() {
        return null;
    }

    @Override
    public List<Class<? extends Change>> getOtherCompatibleChangeTypes() {
        return Collections.singletonList(ModifyDataTypeChange.class);
    }

    @Override
    public boolean doCheck(AbstractSQLChange object) {
        if (StringUtil.isEmpty(((AbstractSQLChange)object).getSql())) {
            return false;
        }
        object = StringUtil.stripComments(((AbstractSQLChange)object).getSql()).toLowerCase();
        Matcher matcher = pattern1.matcher((CharSequence)object);
        object = pattern2.matcher((CharSequence)object);
        return matcher.matches() || ((Matcher)object).matches();
    }

    @Override
    public boolean doCheck(Change change) {
        return change instanceof ModifyDataTypeChange;
    }
}

