/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.net.InetAddress;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.web.server.Ssl;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="management.server", ignoreUnknownFields=true)
public class ManagementServerProperties {
    private Integer port;
    private InetAddress address;
    private String basePath = "";
    private final Servlet servlet = new Servlet();
    @NestedConfigurationProperty
    private Ssl ssl;

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        this.address = address;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = this.cleanBasePath(basePath);
    }

    public Ssl getSsl() {
        return this.ssl;
    }

    public void setSsl(Ssl ssl) {
        this.ssl = ssl;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    private String cleanBasePath(String basePath) {
        String candidate = StringUtils.trimWhitespace((String)basePath);
        if (StringUtils.hasText((String)candidate)) {
            if (!candidate.startsWith("/")) {
                candidate = "/" + candidate;
            }
            if (candidate.endsWith("/")) {
                candidate = candidate.substring(0, candidate.length() - 1);
            }
        }
        return candidate;
    }

    public static class Servlet {
        private String contextPath = "";

        @Deprecated
        @DeprecatedConfigurationProperty(replacement="management.server.base-path")
        public String getContextPath() {
            return this.contextPath;
        }

        @Deprecated
        public void setContextPath(String contextPath) {
            Assert.notNull((Object)contextPath, (String)"ContextPath must not be null");
            this.contextPath = this.cleanContextPath(contextPath);
        }

        private String cleanContextPath(String contextPath) {
            if (StringUtils.hasText((String)contextPath) && contextPath.endsWith("/")) {
                return contextPath.substring(0, contextPath.length() - 1);
            }
            return contextPath;
        }
    }
}

