/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing.caches;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.config.PersistedKeyValuePair;
import org.apache.activemq.artemis.core.server.routing.caches.Cache;
import org.jboss.logging.Logger;

public class LocalCache
implements Cache,
RemovalListener<String, String> {
    private static final Logger logger = Logger.getLogger(LocalCache.class);
    private String id;
    private boolean persisted;
    private int timeout;
    private StorageManager storageManager;
    private com.google.common.cache.Cache<String, String> cache;
    private Map<String, PersistedKeyValuePair> persistedCacheEntries;
    private volatile boolean running;

    public String getId() {
        return this.id;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public LocalCache(String id, boolean persisted, int timeout, StorageManager storageManager) {
        this.id = id;
        this.persisted = persisted;
        this.timeout = timeout;
        this.storageManager = storageManager;
        this.cache = timeout == 0 ? CacheBuilder.newBuilder().build() : CacheBuilder.newBuilder().removalListener((RemovalListener)this).expireAfterAccess((long)timeout, TimeUnit.MILLISECONDS).build();
    }

    @Override
    public void start() {
        if (this.persisted) {
            this.persistedCacheEntries = this.storageManager.getPersistedKeyValuePairs(this.id);
            if (this.persistedCacheEntries != null) {
                for (Map.Entry<String, PersistedKeyValuePair> cacheEntry : this.persistedCacheEntries.entrySet()) {
                    this.cache.put((Object)cacheEntry.getKey(), (Object)cacheEntry.getValue().getValue());
                    logger.info((Object)cacheEntry.toString());
                }
            }
        }
        this.running = true;
    }

    @Override
    public void stop() {
        this.cache.cleanUp();
        if (this.persistedCacheEntries != null) {
            this.persistedCacheEntries.clear();
        }
        this.running = false;
    }

    @Override
    public String get(String key) {
        return (String)this.cache.getIfPresent((Object)key);
    }

    @Override
    public void put(String key, String nodeId) {
        PersistedKeyValuePair persistedKeyValuePair;
        if (this.persisted && ((persistedKeyValuePair = this.persistedCacheEntries.get(key)) == null || !Objects.equals(nodeId, persistedKeyValuePair.getValue()))) {
            persistedKeyValuePair = new PersistedKeyValuePair(this.id, key, nodeId);
            try {
                this.storageManager.storeKeyValuePair(persistedKeyValuePair);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.persistedCacheEntries.put(key, persistedKeyValuePair);
        }
        this.cache.put((Object)key, (Object)nodeId);
    }

    public void onRemoval(RemovalNotification<String, String> notification) {
        PersistedKeyValuePair persistedKeyValuePair;
        if (this.running && this.persisted && (persistedKeyValuePair = this.persistedCacheEntries.remove(notification.getKey())) != null) {
            try {
                this.storageManager.deleteKeyValuePair(persistedKeyValuePair.getMapId(), persistedKeyValuePair.getKey());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

