/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper;

import java.util.Map;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.MultiPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.SinglePropertyMapper;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;

public class MultiDynamicComponentMapper
extends MultiPropertyMapper {
    private PropertyData dynamicComponentData;

    public MultiDynamicComponentMapper(PropertyData dynamicComponentData) {
        this.dynamicComponentData = dynamicComponentData;
    }

    @Override
    public void addComposite(PropertyData propertyData, PropertyMapper propertyMapper) {
        super.addComposite(propertyData, propertyMapper);
        propertyMapper.markAsDynamicComponentMap();
    }

    @Override
    public void add(PropertyData propertyData) {
        SinglePropertyMapper single = new SinglePropertyMapper();
        single.add(propertyData);
        this.addComposite(propertyData, single);
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        boolean ret = false;
        for (Map.Entry entry : this.properties.entrySet()) {
            PropertyData propertyData = (PropertyData)entry.getKey();
            PropertyMapper propertyMapper = (PropertyMapper)entry.getValue();
            if (newObj == null && oldObj == null) {
                return false;
            }
            Object newValue = newObj == null ? null : this.getValue(newObj, propertyData);
            Object oldValue = oldObj == null ? null : this.getValue(oldObj, propertyData);
            ret |= propertyMapper.mapToMapFromEntity(session, data, newValue, oldValue);
        }
        return ret;
    }

    private Object getValue(Object newObj, PropertyData propertyData) {
        return ((Map)newObj).get(propertyData.getBeanName());
    }

    @Override
    public boolean map(SessionImplementor session, Map<String, Object> data, String[] propertyNames, Object[] newState, Object[] oldState) {
        boolean ret = false;
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            Map<String, PropertyData> propertyDatas = this.getPropertyDatas();
            if (!propertyDatas.containsKey(propertyName)) continue;
            PropertyMapper propertyMapper = (PropertyMapper)this.properties.get(propertyDatas.get(propertyName));
            Object newObj = this.getAtIndexOrNull(newState, i);
            Object oldObj = this.getAtIndexOrNull(oldState, i);
            ret |= propertyMapper.mapToMapFromEntity(session, data, newObj, oldObj);
            propertyMapper.mapModifiedFlagsToMapFromEntity(session, data, newObj, oldObj);
        }
        return ret;
    }

    @Override
    public void mapModifiedFlagsToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        for (Map.Entry entry : this.properties.entrySet()) {
            PropertyData propertyData = (PropertyData)entry.getKey();
            PropertyMapper propertyMapper = (PropertyMapper)entry.getValue();
            if (newObj == null && oldObj == null) {
                return;
            }
            Object newValue = newObj == null ? null : this.getValue(newObj, propertyData);
            Object oldValue = oldObj == null ? null : this.getValue(oldObj, propertyData);
            propertyMapper.mapModifiedFlagsToMapFromEntity(session, data, newValue, oldValue);
        }
    }

    @Override
    public void mapToEntityFromMap(EnversService enversService, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        for (PropertyMapper mapper : this.properties.values()) {
            mapper.mapToEntityFromMap(enversService, obj, data, primaryKey, versionsReader, revision);
        }
    }
}

