/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.context.annotation.AdviceMode;
import org.springframework.context.annotation.AdviceModeImportSelector;
import org.springframework.context.annotation.AutoProxyRegistrar;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.NonNull;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.method.configuration.Jsr250MethodSecurityConfiguration;
import org.springframework.security.config.annotation.method.configuration.PrePostMethodSecurityConfiguration;
import org.springframework.security.config.annotation.method.configuration.SecuredMethodSecurityConfiguration;

final class MethodSecuritySelector
implements ImportSelector {
    private final ImportSelector autoProxy = new AutoProxyRegistrarSelector();

    MethodSecuritySelector() {
    }

    public String[] selectImports(@NonNull AnnotationMetadata importMetadata) {
        if (!importMetadata.hasAnnotation(EnableMethodSecurity.class.getName())) {
            return new String[0];
        }
        EnableMethodSecurity annotation = (EnableMethodSecurity)importMetadata.getAnnotations().get(EnableMethodSecurity.class).synthesize();
        ArrayList<String> imports = new ArrayList<String>(Arrays.asList(this.autoProxy.selectImports(importMetadata)));
        if (annotation.prePostEnabled()) {
            imports.add(PrePostMethodSecurityConfiguration.class.getName());
        }
        if (annotation.securedEnabled()) {
            imports.add(SecuredMethodSecurityConfiguration.class.getName());
        }
        if (annotation.jsr250Enabled()) {
            imports.add(Jsr250MethodSecurityConfiguration.class.getName());
        }
        return imports.toArray(new String[0]);
    }

    private static final class AutoProxyRegistrarSelector
    extends AdviceModeImportSelector<EnableMethodSecurity> {
        private static final String[] IMPORTS = new String[]{AutoProxyRegistrar.class.getName()};

        private AutoProxyRegistrarSelector() {
        }

        protected String[] selectImports(@NonNull AdviceMode adviceMode) {
            if (adviceMode == AdviceMode.PROXY) {
                return IMPORTS;
            }
            throw new IllegalStateException("AdviceMode '" + adviceMode + "' is not supported");
        }
    }
}

