/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.session.IndexResolver;
import org.springframework.session.Session;

public class DelegatingIndexResolver<S extends Session>
implements IndexResolver<S> {
    private final List<IndexResolver<S>> delegates;

    public DelegatingIndexResolver(List<IndexResolver<S>> delegates) {
        this.delegates = Collections.unmodifiableList(delegates);
    }

    @SafeVarargs
    public DelegatingIndexResolver(IndexResolver<S> ... delegates) {
        this(Arrays.asList(delegates));
    }

    @Override
    public Map<String, String> resolveIndexesFor(S session) {
        HashMap<String, String> indexes = new HashMap<String, String>();
        for (IndexResolver<S> delegate : this.delegates) {
            indexes.putAll(delegate.resolveIndexesFor(session));
        }
        return indexes;
    }
}

