/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.util.BitSet;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.operation.AbstractBatchOperation;
import org.dbunit.operation.OperationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertOperation
extends AbstractBatchOperation {
    private static final Logger logger = LoggerFactory.getLogger(InsertOperation.class);

    InsertOperation() {
    }

    @Override
    public OperationData getOperationData(ITableMetaData metaData, BitSet ignoreMapping, IDatabaseConnection connection) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("getOperationData(metaData={}, ignoreMapping={}, connection={}) - start", new Object[]{metaData, ignoreMapping, connection});
        }
        Column[] columns = metaData.getColumns();
        StringBuffer sqlBuffer = new StringBuffer(128);
        sqlBuffer.append("insert into ");
        sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
        sqlBuffer.append(" (");
        String columnSeparator = "";
        int i = 0;
        while (i < columns.length) {
            if (!ignoreMapping.get(i)) {
                String columnName = this.getQualifiedName(null, columns[i].getColumnName(), connection);
                sqlBuffer.append(columnSeparator);
                sqlBuffer.append(columnName);
                columnSeparator = ", ";
            }
            ++i;
        }
        sqlBuffer.append(") values (");
        String valueSeparator = "";
        int i2 = 0;
        while (i2 < columns.length) {
            if (!ignoreMapping.get(i2)) {
                sqlBuffer.append(valueSeparator);
                sqlBuffer.append("?");
                valueSeparator = ", ";
            }
            ++i2;
        }
        sqlBuffer.append(")");
        return new OperationData(sqlBuffer.toString(), columns);
    }

    @Override
    protected BitSet getIgnoreMapping(ITable table, int row) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("getIgnoreMapping(table={}, row={}) - start", (Object)table, (Object)String.valueOf(row));
        }
        Column[] columns = table.getTableMetaData().getColumns();
        BitSet ignoreMapping = new BitSet();
        int i = 0;
        while (i < columns.length) {
            Column column = columns[i];
            Object value = table.getValue(row, column.getColumnName());
            if (value == ITable.NO_VALUE || value == null && column.isNotNullable() && column.hasDefaultValue()) {
                ignoreMapping.set(i);
            }
            ++i;
        }
        return ignoreMapping;
    }

    @Override
    protected boolean equalsIgnoreMapping(BitSet ignoreMapping, ITable table, int row) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("equalsIgnoreMapping(ignoreMapping={}, table={}, row={}) - start", new Object[]{ignoreMapping, table, String.valueOf(row)});
        }
        Column[] columns = table.getTableMetaData().getColumns();
        int i = 0;
        while (i < columns.length) {
            boolean bit = ignoreMapping.get(i);
            Object value = table.getValue(row, columns[i].getColumnName());
            if (bit && value != ITable.NO_VALUE || !bit && value == ITable.NO_VALUE) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

