/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util.csv;

import java.io.IOException;
import java.io.Reader;
import liquibase.repackaged.com.opencsv.CSVReaderBuilder;
import liquibase.repackaged.com.opencsv.RFC4180ParserBuilder;
import liquibase.repackaged.com.opencsv.exceptions.CsvValidationException;

public class CSVReader
implements AutoCloseable {
    private final liquibase.repackaged.com.opencsv.CSVReader delegate;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';

    public CSVReader(Reader reader) {
        this(reader, ',', '\"');
    }

    public CSVReader(Reader reader, char separator, char quotchar) {
        this.delegate = new CSVReaderBuilder(reader).withCSVParser(new RFC4180ParserBuilder().withSeparator(separator).withQuoteChar(quotchar).build()).build();
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    public String[] readNext() throws IOException {
        try {
            return this.delegate.readNext();
        }
        catch (CsvValidationException e2) {
            throw new IOException(e2.getMessage(), e2);
        }
    }
}

