/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.lang.Nullable;

@WebEndpoint(id="prometheus")
public class PrometheusScrapeEndpoint {
    private final CollectorRegistry collectorRegistry;

    public PrometheusScrapeEndpoint(CollectorRegistry collectorRegistry) {
        this.collectorRegistry = collectorRegistry;
    }

    @ReadOperation(produces={"text/plain; version=0.0.4; charset=utf-8"})
    public String scrape(@Nullable Set<String> includedNames) {
        try {
            StringWriter writer = new StringWriter();
            Enumeration samples = includedNames != null ? this.collectorRegistry.filteredMetricFamilySamples(includedNames) : this.collectorRegistry.metricFamilySamples();
            TextFormat.write004((Writer)writer, (Enumeration)samples);
            return ((Object)writer).toString();
        }
        catch (IOException ex) {
            throw new RuntimeException("Writing metrics failed", ex);
        }
    }
}

