/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.context.refresh;

import java.util.Arrays;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.cloud.bootstrap.BootstrapApplicationListener;
import org.springframework.cloud.bootstrap.BootstrapConfigFileApplicationListener;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class LegacyContextRefresher
extends ContextRefresher {
    public LegacyContextRefresher(ConfigurableApplicationContext context, RefreshScope scope) {
        super(context, scope);
    }

    @Override
    protected void updateEnvironment() {
        this.addConfigFilesToEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigurableApplicationContext addConfigFilesToEnvironment() {
        ConfigurableApplicationContext capture = null;
        try {
            StandardEnvironment environment = this.copyEnvironment(this.getContext().getEnvironment());
            SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{ContextRefresher.Empty.class}).properties(new String[]{"spring.cloud.bootstrap.enabled=true"}).bannerMode(Banner.Mode.OFF).web(WebApplicationType.NONE).environment((ConfigurableEnvironment)environment);
            builder.application().setListeners(Arrays.asList(new ApplicationListener[]{new BootstrapApplicationListener(), new BootstrapConfigFileApplicationListener()}));
            capture = builder.run(new String[0]);
            if (environment.getPropertySources().contains("refreshArgs")) {
                environment.getPropertySources().remove("refreshArgs");
            }
            MutablePropertySources target = this.getContext().getEnvironment().getPropertySources();
            String targetName = null;
            for (PropertySource source : environment.getPropertySources()) {
                String name = source.getName();
                if (target.contains(name)) {
                    targetName = name;
                }
                if (this.standardSources.contains(name)) continue;
                if (target.contains(name)) {
                    target.replace(name, source);
                    continue;
                }
                if (targetName != null) {
                    target.addAfter(targetName, source);
                    targetName = name;
                    continue;
                }
                target.addFirst(source);
                targetName = name;
            }
        }
        finally {
            for (ConfigurableApplicationContext closeable = capture; closeable != null; closeable = (ConfigurableApplicationContext)closeable.getParent()) {
                try {
                    closeable.close();
                }
                catch (Exception exception) {}
                if (!(closeable.getParent() instanceof ConfigurableApplicationContext)) break;
            }
        }
        return capture;
    }
}

