/*
 * Decompiled with CFR 0.152.
 */
package ai.digital.deploy.permissions.service.impl;

import ai.digital.deploy.permissions.jpa.ReadOnlyTransactionalPermissionService;
import ai.digital.deploy.permissions.jpa.TransactionalPermissionService;
import ai.digital.deploy.permissions.model.GlobalPermission;
import ai.digital.deploy.permissions.model.GlobalPermission$;
import ai.digital.deploy.permissions.model.Role;
import ai.digital.deploy.permissions.model.RolePrincipal;
import ai.digital.deploy.permissions.repository.GlobalPermissionRepository;
import ai.digital.deploy.permissions.service.GlobalPermissionService;
import ai.digital.deploy.permissions.service.RoleNameNotFoundServiceException;
import ai.digital.deploy.permissions.service.RolePrincipalService;
import ai.digital.deploy.permissions.service.RoleService;
import ai.digital.deploy.permissions.service.impl.package$;
import java.io.Serializable;
import java.util.UUID;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@Service
@TransactionalPermissionService
@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001\u0002\n\u0014\u0001\u0001B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aa\u0007\u0001B\u0001B\u0003%q\u0007C\u0003;\u0001\u0011\u00051\bC\u0003B\u0001\u0011\u0005#\tC\u0003n\u0001\u0011\u0005c\u000eC\u0003r\u0001\u0011\u0005#\u000fC\u0003y\u0001\u0011\u0005\u0013\u0010C\u0003{\u0001\u0011\u00053\u0010\u0003\u0004{\u0001\u0011\u0005\u0013q\u0001\u0005\u0007u\u0002!\t%!\u0004\t\u000f\u0005U\u0001\u0001\"\u0011\u0002\u0018!9\u0011q\u0004\u0001\u0005B\u0005\u0005\u0002bBA\u0017\u0001\u0011\u0005\u0013q\u0006\u0005\b\u0003\u000f\u0002A\u0011IA%\u0011\u001d\t9\u0006\u0001C!\u00033Bq!a\u0016\u0001\t\u0003\nIGA\u000eHY>\u0014\u0017\r\u001c)fe6L7o]5p]N+'O^5dK&k\u0007\u000f\u001c\u0006\u0003)U\tA![7qY*\u0011acF\u0001\bg\u0016\u0014h/[2f\u0015\tA\u0012$A\u0006qKJl\u0017n]:j_:\u001c(B\u0001\u000e\u001c\u0003\u0019!W\r\u001d7ps*\u0011A$H\u0001\bI&<\u0017\u000e^1m\u0015\u0005q\u0012AA1j\u0007\u0001\u00192\u0001A\u0011(!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fMB\u0011\u0001&K\u0007\u0002+%\u0011!&\u0006\u0002\u0018\u000f2|'-\u00197QKJl\u0017n]:j_:\u001cVM\u001d<jG\u0016\f!d\u001a7pE\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8SKB|7/\u001b;pef\u0004\"!\f\u0019\u000e\u00039R!aL\f\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u00022]\tQr\t\\8cC2\u0004VM]7jgNLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0006Y!o\u001c7f'\u0016\u0014h/[2f!\tAC'\u0003\u00026+\tY!k\u001c7f'\u0016\u0014h/[2f\u0003Q\u0011x\u000e\\3Qe&t7-\u001b9bYN+'O^5dKB\u0011\u0001\u0006O\u0005\u0003sU\u0011ACU8mKB\u0013\u0018N\\2ja\u0006d7+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0003=}}\u0002\u0005CA\u001f\u0001\u001b\u0005\u0019\u0002\"B\u0016\u0005\u0001\u0004a\u0003\"\u0002\u001a\u0005\u0001\u0004\u0019\u0004\"\u0002\u001c\u0005\u0001\u00049\u0014aA1eIR\u00191)Y6\u0011\t\u0011cuJ\u0015\b\u0003\u000b*s!AR%\u000e\u0003\u001dS!\u0001S\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0013BA&$\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0014(\u0003\r\u0015KG\u000f[3s\u0015\tY5\u0005\u0005\u0002)!&\u0011\u0011+\u0006\u0002!%>dWMT1nK:{GOR8v]\u0012\u001cVM\u001d<jG\u0016,\u0005pY3qi&|g\u000e\u0005\u0003#'V[\u0016B\u0001+$\u0005\u0019!V\u000f\u001d7feA\u0011a+W\u0007\u0002/*\u0011\u0001lF\u0001\u0006[>$W\r\\\u0005\u00035^\u0013AAU8mKB\u0019A\t\u00180\n\u0005us%\u0001\u0002'jgR\u0004\"AV0\n\u0005\u0001<&\u0001E$m_\n\fG\u000eU3s[&\u001c8/[8o\u0011\u0015\u0011W\u00011\u0001d\u0003!\u0011x\u000e\\3OC6,\u0007C\u00013i\u001d\t)g\r\u0005\u0002GG%\u0011qmI\u0001\u0007!J,G-\u001a4\n\u0005%T'AB*ue&twM\u0003\u0002hG!)\u0001$\u0002a\u0001YB\u0019A\tX2\u0002\rI,Wn\u001c<f)\r\u0019u\u000e\u001d\u0005\u0006E\u001a\u0001\ra\u0019\u0005\u00061\u0019\u0001\r\u0001\\\u0001\u000ee\u0016lwN^3G_J\u0014v\u000e\\3\u0015\u0005M4\bC\u0001\u0012u\u0013\t)8E\u0001\u0003V]&$\b\"B<\b\u0001\u0004)\u0016\u0001\u0002:pY\u0016\f\u0011B]3n_Z,\u0017\t\u001c7\u0015\u0003M\fAA]3bIR\t1\f\u000b\u0002\n{B\u0019a0a\u0001\u000e\u0003}T1!!\u0001\u0018\u0003\rQ\u0007/Y\u0005\u0004\u0003\u000by(A\n*fC\u0012|e\u000e\\=Ue\u0006t7/Y2uS>t\u0017\r\u001c)fe6L7o]5p]N+'O^5dKR\u00191,!\u0003\t\u000b\tT\u0001\u0019A2)\u0005)iHcA.\u0002\u0010!1\u0011\u0011C\u0006A\u00021\f\u0011B]8mK:\u000bW.Z:)\u0005-i\u0018!\u0005:fC\u0012\u0014\u0015PU8mKB\u000bG\u000f^3s]R\u00191,!\u0007\t\r\u0005mA\u00021\u0001d\u0003-\u0011x\u000e\\3QCR$XM\u001d8)\u00051i\u0018\u0001B3eSR$raQA\u0012\u0003K\tI\u0003C\u0003c\u001b\u0001\u00071\r\u0003\u0004\u0002(5\u0001\r\u0001\\\u0001\u0011a\u0016\u0014X.[:tS>t7\u000fV8BI\u0012Da!a\u000b\u000e\u0001\u0004a\u0017a\u00059fe6L7o]5p]N$v\u000eR3mKR,\u0017!H4fi\u001ecwNY1m!\u0016\u0014X.[:tS>t7OR8s%>dW-\u00133\u0015\u00071\f\t\u0004C\u0004\u000249\u0001\r!!\u000e\u0002\rI|G.Z%e!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\tA!\u001e;jY*\u0011\u0011qH\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002D\u0005e\"\u0001B+V\u0013\u0012C#AD?\u0002A\u001d,Go\u00127pE\u0006d\u0007+\u001a:nSN\u001c\u0018n\u001c8t\r>\u0014\bK]5oG&\u0004\u0018\r\u001c\u000b\u0005\u0003\u0017\n\t\u0006\u0005\u0003e\u0003\u001b\u001a\u0017bAA(U\n\u00191+\u001a;\t\r\u0005Ms\u00021\u0001d\u0003%\u0001(/\u001b8dSB\fG\u000e\u000b\u0002\u0010{\u0006y1\r[3dWB+'/\\5tg&|g\u000e\u0006\u0004\u0002\\\u0005\u0005\u00141\r\t\u0004E\u0005u\u0013bAA0G\t9!i\\8mK\u0006t\u0007\"\u0002\r\u0011\u0001\u0004a\u0007BBA3!\u0001\u0007A.\u0001\u0005bY2\u0014v\u000e\\3tQ\t\u0001R\u0010\u0006\u0005\u0002\\\u0005-\u0014QNA8\u0011\u0015A\u0012\u00031\u0001m\u0011\u0019\t)'\u0005a\u0001Y\"1\u0011\u0011O\tA\u00021\f!\u0002\u001d:j]\u000eL\u0007/\u00197tQ\t\tR\u0010K\u0002\u0001\u0003o\u00022A`A=\u0013\r\tYh \u0002\u001f)J\fgn]1di&|g.\u00197QKJl\u0017n]:j_:\u001cVM\u001d<jG\u0016D3\u0001AA@!\u0011\t\t)a$\u000e\u0005\u0005\r%\u0002BAC\u0003\u000f\u000b!b\u001d;fe\u0016|G/\u001f9f\u0015\u0011\tI)a#\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T!!!$\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0012\u0006\r%aB*feZL7-\u001a")
public class GlobalPermissionServiceImpl
implements GlobalPermissionService {
    private final GlobalPermissionRepository globalPermissionRepository;
    private final RoleService roleService;
    private final RolePrincipalService rolePrincipalService;

    @Override
    public Either<RoleNameNotFoundServiceException, Tuple2<Role, List<GlobalPermission>>> add(String roleName, List<String> permissions) {
        return (Either)this.roleService.read(roleName).map((Function1 & Serializable)role -> {
            Tuple2 tuple2 = $this.globalPermissionRepository.get((Role)role).partition((Function1 & Serializable)gp -> BoxesRunTime.boxToBoolean((boolean)permissions.contains((Object)gp.permissionName())));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List exists = (List)tuple2._1();
            List toDelete = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)exists, (Object)toDelete);
            Tuple2 tuple23 = tuple22;
            List exists2 = (List)tuple23._1();
            List toDelete2 = (List)tuple23._2();
            List toSave = permissions.filterNot((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)GlobalPermissionServiceImpl.$anonfun$add$3(exists2, p))).map((Function1 & Serializable)p -> GlobalPermission$.MODULE$.apply((Role)role, (String)p));
            $this.globalPermissionRepository.remove((List<GlobalPermission>)toDelete2);
            return scala.package$.MODULE$.Right().apply((Object)new Tuple2(role, exists2.$plus$plus($this.globalPermissionRepository.add((List<GlobalPermission>)toSave))));
        }).getOrElse((Function0 & Serializable)() -> scala.package$.MODULE$.Left().apply((Object)new RoleNameNotFoundServiceException(roleName)));
    }

    @Override
    public Either<RoleNameNotFoundServiceException, Tuple2<Role, List<GlobalPermission>>> remove(String roleName, List<String> permissions) {
        return (Either)this.roleService.read(roleName).map((Function1 & Serializable)role -> {
            Tuple2 tuple2 = $this.globalPermissionRepository.get((Role)role).partition((Function1 & Serializable)gp -> BoxesRunTime.boxToBoolean((boolean)permissions.contains((Object)gp.permissionName())));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List toDelete = (List)tuple2._1();
            List gp2 = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)toDelete, (Object)gp2);
            Tuple2 tuple23 = tuple22;
            List toDelete2 = (List)tuple23._1();
            List gp3 = (List)tuple23._2();
            $this.globalPermissionRepository.remove((List<GlobalPermission>)toDelete2);
            return scala.package$.MODULE$.Right().apply((Object)new Tuple2(role, (Object)gp3));
        }).getOrElse((Function0 & Serializable)() -> scala.package$.MODULE$.Left().apply((Object)new RoleNameNotFoundServiceException(roleName)));
    }

    @Override
    public void removeForRole(Role role) {
        this.globalPermissionRepository.removeForRole(role);
    }

    @Override
    public void removeAll() {
        this.globalPermissionRepository.removeAll();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<GlobalPermission> read() {
        return this.globalPermissionRepository.get();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<GlobalPermission> read(String roleName) {
        return this.globalPermissionRepository.get(roleName);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<GlobalPermission> read(List<String> roleNames) {
        return this.globalPermissionRepository.get(roleNames);
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<GlobalPermission> readByRolePattern(String rolePattern) {
        return (List)package$.MODULE$.wrapNullablePatternSearch(rolePattern, (Function1 & Serializable)p -> $this.globalPermissionRepository.listByRoleNamePattern((String)p), (Function0 & Serializable)() -> $this.globalPermissionRepository.get());
    }

    @Override
    public Either<RoleNameNotFoundServiceException, Tuple2<Role, List<GlobalPermission>>> edit(String roleName, List<String> permissionsToAdd, List<String> permissionsToDelete) {
        return (Either)this.roleService.read(roleName).map((Function1 & Serializable)role -> {
            List<GlobalPermission> permissions = $this.globalPermissionRepository.get((Role)role);
            Tuple2 tuple2 = permissions.partition((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)permissionsToDelete.contains((Object)p.permissionName())));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List toDelete = (List)tuple2._1();
            List exists = (List)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)toDelete, (Object)exists);
            Tuple2 tuple23 = tuple22;
            List toDelete2 = (List)tuple23._1();
            List exists2 = (List)tuple23._2();
            $this.globalPermissionRepository.remove((List<GlobalPermission>)toDelete2);
            List toAdd = permissionsToAdd.map((Function1 & Serializable)p -> GlobalPermission$.MODULE$.apply((Role)role, (String)p));
            return scala.package$.MODULE$.Right().apply((Object)new Tuple2(role, exists2.$plus$plus($this.globalPermissionRepository.add((List<GlobalPermission>)toAdd))));
        }).getOrElse((Function0 & Serializable)() -> scala.package$.MODULE$.Left().apply((Object)new RoleNameNotFoundServiceException(roleName)));
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public List<String> getGlobalPermissionsForRoleId(UUID roleId) {
        List<GlobalPermission> permissions = this.globalPermissionRepository.get(roleId);
        return permissions.map((Function1 & Serializable)x$5 -> x$5.permissionName());
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public Set<String> getGlobalPermissionsForPrincipal(String principal) {
        List<RolePrincipal> result = this.rolePrincipalService.readByPrincipal(principal);
        List roles = result.map((Function1 & Serializable)x$6 -> x$6.role().name());
        return this.globalPermissionRepository.get((List<String>)roles).map((Function1 & Serializable)data -> data.permissionName()).toSet();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public boolean checkPermission(List<String> permissions, List<String> allRoles) {
        return this.globalPermissionRepository.getByPermissionsAndRoles(permissions, (Set<String>)allRoles.toSet()).nonEmpty();
    }

    @Override
    @ReadOnlyTransactionalPermissionService
    public boolean checkPermission(List<String> permissions, List<String> allRoles, List<String> principals) {
        Set principalRoleIds = this.rolePrincipalService.readAll(principals).map((Function1 & Serializable)x$7 -> x$7.role().name()).toSet();
        return this.globalPermissionRepository.getByPermissionsAndRoles(permissions, (Set<String>)((Set)principalRoleIds.$plus$plus(allRoles))).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$add$3(List exists$1, String p) {
        return exists$1.map((Function1 & Serializable)x$2 -> x$2.permissionName()).contains((Object)p);
    }

    public GlobalPermissionServiceImpl(GlobalPermissionRepository globalPermissionRepository, RoleService roleService, RolePrincipalService rolePrincipalService) {
        this.globalPermissionRepository = globalPermissionRepository;
        this.roleService = roleService;
        this.rolePrincipalService = rolePrincipalService;
    }
}

