/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.ExtendableCriterion;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;

public class AggregatedAuditExpression
implements AuditCriterion,
ExtendableCriterion {
    private String alias;
    private PropertyNameGetter propertyNameGetter;
    private AggregatedMode mode;
    private boolean correlate;
    private List<AuditCriterion> criterions;

    public AggregatedAuditExpression(String alias, PropertyNameGetter propertyNameGetter, AggregatedMode mode) {
        this.alias = alias;
        this.propertyNameGetter = propertyNameGetter;
        this.mode = mode;
        this.criterions = new ArrayList<AuditCriterion>();
    }

    @Override
    public AggregatedAuditExpression add(AuditCriterion criterion) {
        this.criterions.add(criterion);
        return this;
    }

    @Override
    public void addToQuery(EnversService enversService, AuditReaderImplementor versionsReader, Map<String, String> aliasToEntityNameMap, String baseAlias, QueryBuilder qb, Parameters parameters) {
        String effectiveAlias = this.alias == null ? baseAlias : this.alias;
        String entityName = aliasToEntityNameMap.get(effectiveAlias);
        String propertyName = CriteriaTools.determinePropertyName(enversService, versionsReader, entityName, this.propertyNameGetter);
        CriteriaTools.checkPropertyNotARelation(enversService, entityName, propertyName);
        Parameters subParams = parameters.addSubParameters("and");
        String auditEntityName = enversService.getAuditEntitiesConfiguration().getAuditEntityName(entityName);
        String subQueryAlias = qb.generateAlias();
        QueryBuilder subQb = qb.newSubQueryBuilder(auditEntityName, subQueryAlias);
        aliasToEntityNameMap.put(subQueryAlias, entityName);
        for (AuditCriterion versionsCriteria : this.criterions) {
            versionsCriteria.addToQuery(enversService, versionsReader, aliasToEntityNameMap, effectiveAlias, qb, subParams);
            versionsCriteria.addToQuery(enversService, versionsReader, aliasToEntityNameMap, subQueryAlias, subQb, subQb.getRootParameters());
        }
        switch (this.mode) {
            case MIN: {
                subQb.addProjection("min", subQb.getAlias(), propertyName, false);
                break;
            }
            case MAX: {
                subQb.addProjection("max", subQb.getAlias(), propertyName, false);
            }
        }
        if (this.correlate) {
            String originalIdPropertyName = enversService.getAuditEntitiesConfiguration().getOriginalIdPropName();
            enversService.getEntitiesConfigurations().get(entityName).getIdMapper().addIdsEqualToQuery(subQb.getRootParameters(), subQb.getRootAlias() + "." + originalIdPropertyName, effectiveAlias + "." + originalIdPropertyName);
        }
        subParams.addWhere(effectiveAlias, propertyName, "=", subQb);
    }

    public AggregatedAuditExpression computeAggregationInInstanceContext() {
        this.correlate = true;
        return this;
    }

    public static enum AggregatedMode {
        MAX,
        MIN;

    }
}

