/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.RuleBasedCollator;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.CollationElementsInterface;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.Like;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.shared.common.error.StandardException;

final class WorkHorseForCollatorDatatypes {
    private RuleBasedCollator collatorForCharacterDatatypes;
    private SQLChar stringData;

    WorkHorseForCollatorDatatypes(RuleBasedCollator ruleBasedCollator, SQLChar sQLChar) {
        this.collatorForCharacterDatatypes = ruleBasedCollator;
        this.stringData = sQLChar;
    }

    int stringCompare(SQLChar sQLChar, SQLChar sQLChar2) throws StandardException {
        CollationKey collationKey = sQLChar.getCollationKey();
        CollationKey collationKey2 = sQLChar2.getCollationKey();
        if (collationKey == null || collationKey2 == null) {
            if (collationKey != null) {
                return -1;
            }
            if (collationKey2 != null) {
                return 1;
            }
            return 0;
        }
        return collationKey.compareTo(collationKey2);
    }

    BooleanDataValue like(DataValueDescriptor dataValueDescriptor) throws StandardException {
        Boolean bl = Like.like(this.stringData.getCharArray(), this.stringData.getLength(), ((SQLChar)dataValueDescriptor).getCharArray(), dataValueDescriptor.getLength(), null, 0, this.collatorForCharacterDatatypes);
        return SQLBoolean.truthValue((DataValueDescriptor)this.stringData, dataValueDescriptor, bl);
    }

    BooleanDataValue like(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        if (dataValueDescriptor2.isNull()) {
            throw StandardException.newException("22501", new Object[0]);
        }
        CollationElementsInterface collationElementsInterface = (CollationElementsInterface)((Object)dataValueDescriptor2);
        if (dataValueDescriptor2.getLength() != 1 || !collationElementsInterface.hasSingleCollationElement()) {
            throw StandardException.newException("22019", collationElementsInterface.toString());
        }
        Boolean bl = Like.like(this.stringData.getCharArray(), this.stringData.getLength(), ((SQLChar)dataValueDescriptor).getCharArray(), dataValueDescriptor.getLength(), ((SQLChar)dataValueDescriptor2).getCharArray(), dataValueDescriptor2.getLength(), this.collatorForCharacterDatatypes);
        return SQLBoolean.truthValue((DataValueDescriptor)this.stringData, dataValueDescriptor, bl);
    }

    RuleBasedCollator getCollatorForCollation() {
        return this.collatorForCharacterDatatypes;
    }

    boolean hasSingleCollationElement() throws StandardException {
        if (this.stringData.isNull()) {
            return false;
        }
        CollationElementIterator collationElementIterator = this.collatorForCharacterDatatypes.getCollationElementIterator(this.stringData.getString());
        return collationElementIterator.next() != -1 && collationElementIterator.next() == -1;
    }
}

