/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingManager;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.util.FilteringIterator;
import java.net.URI;
import java.util.Iterator;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class FsFilteringManager
extends FsDecoratingManager<FsManager> {
    private final URI prefix;

    public FsFilteringManager(FsManager manager, FsMountPoint prefix) {
        super(manager);
        this.prefix = prefix.toHierarchicalUri();
    }

    @Override
    public int getSize() {
        int size = 0;
        for (FsController<?> controller : this) {
            ++size;
        }
        return size;
    }

    @Override
    public Iterator<FsController<?>> iterator() {
        return new FilteredControllerIterator();
    }

    private final class FilteredControllerIterator
    extends FilteringIterator<FsController<?>> {
        final String ps;
        final String pp;
        final int ppl;
        final boolean pps;

        FilteredControllerIterator() {
            super(FsFilteringManager.this.delegate.iterator());
            this.ps = FsFilteringManager.this.prefix.getScheme();
            this.pp = FsFilteringManager.this.prefix.getPath();
            this.ppl = this.pp.length();
            this.pps = '/' == this.pp.charAt(this.ppl - 1);
        }

        @Override
        protected boolean accept(FsController<?> controller) {
            String mpp;
            assert (null != controller) : "null elements are not allowed in this collection!";
            URI mp = ((FsModel)controller.getModel()).getMountPoint().toHierarchicalUri();
            return mp.getScheme().equals(this.ps) && (mpp = mp.getPath()).startsWith(this.pp) && (this.pps || mpp.length() == this.ppl || '/' == mpp.charAt(this.ppl));
        }
    }
}

