/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.sql.SQLException;
import java.util.Arrays;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeOperation
extends DatabaseOperation {
    private static final Logger logger = LoggerFactory.getLogger(CompositeOperation.class);
    private final DatabaseOperation[] _actions;

    public CompositeOperation(DatabaseOperation action1, DatabaseOperation action2) {
        this._actions = new DatabaseOperation[]{action1, action2};
    }

    public CompositeOperation(DatabaseOperation[] actions) {
        this._actions = actions;
    }

    @Override
    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        logger.debug("execute(connection={}, , dataSet={}) - start", (Object)connection, (Object)dataSet);
        int i = 0;
        while (i < this._actions.length) {
            DatabaseOperation action = this._actions[i];
            action.execute(connection, dataSet);
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("_actions=").append(this._actions == null ? "null" : Arrays.asList(this._actions).toString());
        sb.append("]");
        return sb.toString();
    }
}

