/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.activemq.artemis.spi.core.security.jaas.AuditLoginModule;
import org.apache.activemq.artemis.spi.core.security.jaas.PropertiesLoader;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;
import org.apache.activemq.artemis.utils.HashProcessor;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.jboss.logging.Logger;

public class PropertiesLoginModule
extends PropertiesLoader
implements AuditLoginModule {
    private static final Logger logger = Logger.getLogger(PropertiesLoginModule.class);
    public static final String USER_FILE_PROP_NAME = "org.apache.activemq.jaas.properties.user";
    public static final String ROLE_FILE_PROP_NAME = "org.apache.activemq.jaas.properties.role";
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Properties users;
    private Map<String, Set<String>> roles;
    private String user;
    private final Set<Principal> principals = new HashSet<Principal>();
    private boolean loginSucceeded;
    private HashProcessor hashProcessor;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.loginSucceeded = false;
        this.init(options);
        this.users = this.load(USER_FILE_PROP_NAME, "user", options).getProps();
        this.roles = this.load(ROLE_FILE_PROP_NAME, "role", options).invertedPropertiesValuesMap();
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        this.user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        if (this.user == null) {
            throw new FailedLoginException("User is null");
        }
        String password = this.users.getProperty(this.user);
        if (password == null) {
            throw new FailedLoginException("User does not exist: " + this.user);
        }
        try {
            this.hashProcessor = PasswordMaskingUtil.getHashProcessor((String)password);
        }
        catch (Exception e) {
            throw new FailedLoginException("Failed to get hash processor");
        }
        if (!this.hashProcessor.compare(tmpPassword, password)) {
            throw new FailedLoginException("Password does not match for user: " + this.user);
        }
        this.loginSucceeded = true;
        if (this.debug) {
            logger.debug((Object)("login " + this.user));
        }
        return this.loginSucceeded;
    }

    @Override
    public boolean commit() throws LoginException {
        boolean result = this.loginSucceeded;
        Set<UserPrincipal> authenticatedUsers = this.subject.getPrincipals(UserPrincipal.class);
        if (result) {
            UserPrincipal userPrincipal = new UserPrincipal(this.user);
            this.principals.add(userPrincipal);
            authenticatedUsers.add(userPrincipal);
        }
        for (UserPrincipal userPrincipal : authenticatedUsers) {
            Set<String> matchedRoles = this.roles.get(userPrincipal.getName());
            if (matchedRoles == null) continue;
            for (String entry : matchedRoles) {
                this.principals.add(new RolePrincipal(entry));
            }
        }
        this.subject.getPrincipals().addAll(this.principals);
        this.clear();
        if (this.debug) {
            logger.debug((Object)("commit, result: " + result));
        }
        return result;
    }

    @Override
    public boolean abort() throws LoginException {
        this.registerFailureForAudit(this.user);
        this.clear();
        if (this.debug) {
            logger.debug((Object)"abort");
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        this.clear();
        if (this.debug) {
            logger.debug((Object)"logout");
        }
        return true;
    }

    private void clear() {
        this.user = null;
        this.loginSucceeded = false;
    }
}

