/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere;

import com.xebialabs.overthere.RuntimeIOException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public enum OperatingSystemFamily {
    WINDOWS('\\', ';', "\r\n", "&&", ".bat", "C:\\windows\\temp", "UTF-8"),
    UNIX('/', ':', "\n", ";", ".sh", "/tmp", "UTF-8"),
    ZOS('/', ':', "\n", ";", ".sh", "/tmp", "Cp1047");

    private final String fileSeparator;
    private final char fileSeparatorChar;
    private final String pathSeparator;
    private final char pathSeparatorChar;
    private final String lineSeparator;
    private final String commandSeparator;
    private final String scriptExtension;
    private final String defaultTemporaryDirectoryPath;
    private final String defaultCharacterSet;

    private OperatingSystemFamily(char fileSeparatorChar, char pathSeparatorChar, String lineSeparator, String commandSepator, String scriptExtension, String defaultTemporaryDirectoryPath, String defaultCharacterSet) {
        this.scriptExtension = scriptExtension;
        this.lineSeparator = lineSeparator;
        this.defaultTemporaryDirectoryPath = defaultTemporaryDirectoryPath;
        this.fileSeparator = String.valueOf(fileSeparatorChar);
        this.fileSeparatorChar = fileSeparatorChar;
        this.pathSeparator = String.valueOf(pathSeparatorChar);
        this.pathSeparatorChar = pathSeparatorChar;
        this.commandSeparator = commandSepator;
        this.defaultCharacterSet = defaultCharacterSet;
    }

    public static OperatingSystemFamily getLocalHostOperatingSystemFamily() {
        return System.getProperty("os.name").startsWith("Windows") ? WINDOWS : UNIX;
    }

    public String convertText(String text) {
        if (text == null) {
            return null;
        }
        String lineSep = this.getLineSeparator();
        try {
            String line;
            StringBuilder converted = new StringBuilder();
            BufferedReader r = new BufferedReader(new StringReader(text));
            while ((line = r.readLine()) != null) {
                converted.append(line).append(lineSep);
            }
            return converted.toString();
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Unable to read String", exc);
        }
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public char getFileSeparatorChar() {
        return this.fileSeparatorChar;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public char getPathSeparatorChar() {
        return this.pathSeparatorChar;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public String getCommandSeparator() {
        return this.commandSeparator;
    }

    public String getScriptExtension() {
        return this.scriptExtension;
    }

    public String getDefaultTemporaryDirectoryPath() {
        return this.defaultTemporaryDirectoryPath;
    }

    public String getDefaultCharacterSet() {
        return this.defaultCharacterSet;
    }
}

