/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.balancing;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.balancing.policies.Policy;
import org.apache.activemq.artemis.core.server.balancing.pools.Pool;
import org.apache.activemq.artemis.core.server.balancing.targets.Target;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetKey;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetKeyResolver;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetResult;
import org.apache.activemq.artemis.core.server.balancing.transformer.KeyTransformer;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.jboss.logging.Logger;

public class BrokerBalancer
implements ActiveMQComponent {
    private static final Logger logger = Logger.getLogger(BrokerBalancer.class);
    public static final String CLIENT_ID_PREFIX = "$.artemis.internal.balancer.client.";
    private final String name;
    private final TargetKey targetKey;
    private final TargetKeyResolver targetKeyResolver;
    private final TargetResult localTarget;
    private volatile Pattern localTargetFilter;
    private final Pool pool;
    private final Policy policy;
    private final KeyTransformer transformer;
    private final Cache<String, TargetResult> cache;
    private volatile boolean started = false;

    public String getName() {
        return this.name;
    }

    public TargetKey getTargetKey() {
        return this.targetKey;
    }

    public Target getLocalTarget() {
        return this.localTarget.getTarget();
    }

    public String getLocalTargetFilter() {
        return this.localTargetFilter != null ? this.localTargetFilter.pattern() : null;
    }

    public Pool getPool() {
        return this.pool;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public Cache<String, TargetResult> getCache() {
        return this.cache;
    }

    public boolean isStarted() {
        return this.started;
    }

    public BrokerBalancer(String name, TargetKey targetKey, String targetKeyFilter, Target localTarget, String localTargetFilter, Pool pool, Policy policy, KeyTransformer transformer, int cacheTimeout) {
        this.name = name;
        this.targetKey = targetKey;
        this.transformer = transformer;
        this.targetKeyResolver = new TargetKeyResolver(targetKey, targetKeyFilter);
        this.localTarget = new TargetResult(localTarget);
        this.localTargetFilter = localTargetFilter != null ? Pattern.compile(localTargetFilter) : null;
        this.pool = pool;
        this.policy = policy;
        this.cache = cacheTimeout == -1 ? CacheBuilder.newBuilder().build() : (cacheTimeout > 0 ? CacheBuilder.newBuilder().expireAfterAccess((long)cacheTimeout, TimeUnit.MILLISECONDS).build() : null);
    }

    public void start() throws Exception {
        if (this.pool != null) {
            this.pool.start();
        }
        this.started = true;
    }

    public void stop() throws Exception {
        this.started = false;
        if (this.pool != null) {
            this.pool.stop();
        }
    }

    public TargetResult getTarget(Connection connection, String clientID, String username) {
        if (clientID != null && clientID.startsWith(CLIENT_ID_PREFIX)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The clientID [" + clientID + "] starts with BrokerBalancer.CLIENT_ID_PREFIX"));
            }
            return this.localTarget;
        }
        return this.getTarget(this.targetKeyResolver.resolve(connection, clientID, username));
    }

    public TargetResult getTarget(String key) {
        if (this.localTargetFilter != null && this.localTargetFilter.matcher(this.transform(key)).matches()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The " + this.targetKey + "[" + key + "] matches the localTargetFilter " + this.localTargetFilter.pattern()));
            }
            return this.localTarget;
        }
        if (this.pool == null) {
            return TargetResult.REFUSED_USE_ANOTHER_RESULT;
        }
        TargetResult result = null;
        if (this.cache != null) {
            result = (TargetResult)this.cache.getIfPresent((Object)key);
        }
        if (result != null) {
            if (this.pool.isTargetReady(result.getTarget())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The cache returns [" + result.getTarget() + "] ready for " + this.targetKey + "[" + key + "]"));
                }
                return result;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The cache returns [" + result.getTarget() + "] not ready for " + this.targetKey + "[" + key + "]"));
            }
        }
        List<Target> targets = this.pool.getTargets();
        Target target = this.policy.selectTarget(targets, key);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("The policy selects [" + target + "] from " + targets + " for " + this.targetKey + "[" + key + "]"));
        }
        if (target != null) {
            result = new TargetResult(target);
            if (this.cache != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Caching " + this.targetKey + "[" + key + "] for [" + target + "]"));
                }
                this.cache.put((Object)key, (Object)result);
            }
        }
        return result != null ? result : TargetResult.REFUSED_UNAVAILABLE_RESULT;
    }

    public void setLocalTargetFilter(String regExp) {
        this.localTargetFilter = regExp == null || regExp.trim().isEmpty() ? null : Pattern.compile(regExp);
    }

    public TargetKeyResolver getTargetKeyResolver() {
        return this.targetKeyResolver;
    }

    private String transform(String key) {
        String result = key;
        if (this.transformer != null) {
            result = this.transformer.transform(key);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Key: " + key + ", transformed to " + result));
            }
        }
        return result;
    }
}

