/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.balancing;

import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.balancing.BrokerBalancer;
import org.apache.activemq.artemis.core.server.balancing.RedirectContext;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetResult;
import org.apache.activemq.artemis.spi.core.remoting.Connection;

public abstract class RedirectHandler<T extends RedirectContext> {
    private final ActiveMQServer server;

    public ActiveMQServer getServer() {
        return this.server;
    }

    protected RedirectHandler(ActiveMQServer server) {
        this.server = server;
    }

    protected abstract void cannotRedirect(T var1) throws Exception;

    protected abstract void redirectTo(T var1) throws Exception;

    protected boolean redirect(T context) throws Exception {
        Connection transportConnection = ((RedirectContext)context).getConnection().getTransportConnection();
        BrokerBalancer brokerBalancer = this.getServer().getBalancerManager().getBalancer(transportConnection.getRedirectTo());
        if (brokerBalancer == null) {
            ActiveMQServerLogger.LOGGER.brokerBalancerNotFound(transportConnection.getRedirectTo());
            this.cannotRedirect(context);
            return true;
        }
        ((RedirectContext)context).setResult(brokerBalancer.getTarget(transportConnection, ((RedirectContext)context).getClientID(), ((RedirectContext)context).getUsername()));
        if (TargetResult.Status.OK != ((RedirectContext)context).getResult().getStatus()) {
            ActiveMQServerLogger.LOGGER.cannotRedirectClientConnection(transportConnection);
            this.cannotRedirect(context);
            return true;
        }
        ActiveMQServerLogger.LOGGER.redirectClientConnection(transportConnection, ((RedirectContext)context).getTarget());
        if (!((RedirectContext)context).getTarget().isLocal()) {
            this.redirectTo(context);
            return true;
        }
        return false;
    }
}

