/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.BitSet;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.statement.IPreparedBatchStatement;
import org.dbunit.database.statement.SimplePreparedStatement;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoPrimaryKeyException;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.operation.AbstractBatchOperation;
import org.dbunit.operation.AbstractOperation;
import org.dbunit.operation.DatabaseOperation;
import org.dbunit.operation.InsertOperation;
import org.dbunit.operation.OperationData;
import org.dbunit.operation.UpdateOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshOperation
extends AbstractOperation {
    private static final Logger logger = LoggerFactory.getLogger(RefreshOperation.class);
    private final InsertOperation _insertOperation = (InsertOperation)DatabaseOperation.INSERT;
    private final UpdateOperation _updateOperation = (UpdateOperation)DatabaseOperation.UPDATE;

    RefreshOperation() {
    }

    private boolean isEmpty(ITable table) throws DataSetException {
        return AbstractBatchOperation.isEmpty(table);
    }

    @Override
    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        logger.debug("execute(connection={}, dataSet) - start", (Object)connection);
        ITableIterator iterator = dataSet.iterator();
        while (iterator.next()) {
            ITable table = iterator.getTable();
            String tableName = table.getTableMetaData().getTableName();
            logger.trace("execute: processing table='{}'", (Object)tableName);
            if (this.isEmpty(table)) continue;
            ITableMetaData metaData = RefreshOperation.getOperationMetaData(connection, table.getTableMetaData());
            RowOperation updateRowOperation = this.createUpdateOperation(connection, metaData);
            InsertRowOperation insertRowOperation = new InsertRowOperation(connection, metaData);
            try {
                int i = 0;
                while (true) {
                    if (!updateRowOperation.execute(table, i)) {
                        ((RowOperation)insertRowOperation).execute(table, i);
                    }
                    ++i;
                }
            }
            catch (RowOutOfBoundsException i) {
                updateRowOperation.close();
                insertRowOperation.close();
            }
            catch (SQLException e) {
                try {
                    String msg = "Exception processing table name='" + tableName + "'";
                    throw new DatabaseUnitException(msg, e);
                }
                catch (Throwable throwable) {
                    updateRowOperation.close();
                    insertRowOperation.close();
                    throw throwable;
                }
            }
        }
    }

    private RowOperation createUpdateOperation(IDatabaseConnection connection, ITableMetaData metaData) throws DataSetException, SQLException {
        logger.debug("createUpdateOperation(connection={}, metaData={}) - start", (Object)connection, (Object)metaData);
        if (metaData.getColumns().length > metaData.getPrimaryKeys().length) {
            return new UpdateRowOperation(connection, metaData);
        }
        return new RowExistOperation(connection, metaData);
    }

    private class InsertRowOperation
    extends RowOperation {
        private final Logger logger;
        private IDatabaseConnection _connection;
        private ITableMetaData _metaData;

        public InsertRowOperation(IDatabaseConnection connection, ITableMetaData metaData) throws DataSetException, SQLException {
            this.logger = LoggerFactory.getLogger(InsertRowOperation.class);
            this._connection = connection;
            this._metaData = metaData;
        }

        @Override
        public boolean execute(ITable table, int row) throws DataSetException, SQLException {
            this.logger.debug("execute(table={}, row={}) - start", (Object)table, (Object)String.valueOf(row));
            if (this._ignoreMapping == null || !RefreshOperation.this._insertOperation.equalsIgnoreMapping(this._ignoreMapping, table, row)) {
                if (this._statement != null) {
                    this._statement.close();
                }
                this._ignoreMapping = RefreshOperation.this._insertOperation.getIgnoreMapping(table, row);
                this._operationData = RefreshOperation.this._insertOperation.getOperationData(this._metaData, this._ignoreMapping, this._connection);
                this._statement = new SimplePreparedStatement(this._operationData.getSql(), this._connection.getConnection());
            }
            return super.execute(table, row);
        }
    }

    private class RowExistOperation
    extends RowOperation {
        private final Logger logger;
        PreparedStatement _countStatement;

        public RowExistOperation(IDatabaseConnection connection, ITableMetaData metaData) throws DataSetException, SQLException {
            this.logger = LoggerFactory.getLogger(RowExistOperation.class);
            this._operationData = this.getSelectCountData(metaData, connection);
            this._countStatement = connection.getConnection().prepareStatement(this._operationData.getSql());
        }

        private OperationData getSelectCountData(ITableMetaData metaData, IDatabaseConnection connection) throws DataSetException {
            this.logger.debug("getSelectCountData(metaData={}, connection={}) - start", (Object)metaData, (Object)connection);
            Column[] primaryKeys = metaData.getPrimaryKeys();
            if (primaryKeys.length == 0) {
                throw new NoPrimaryKeyException(metaData.getTableName());
            }
            StringBuffer sqlBuffer = new StringBuffer(128);
            sqlBuffer.append("select COUNT(*) from ");
            sqlBuffer.append(RefreshOperation.this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
            sqlBuffer.append(" where ");
            int i = 0;
            while (i < primaryKeys.length) {
                Column column = primaryKeys[i];
                if (i > 0) {
                    sqlBuffer.append(" and ");
                }
                sqlBuffer.append(RefreshOperation.this.getQualifiedName(null, column.getColumnName(), connection));
                sqlBuffer.append(" = ?");
                ++i;
            }
            return new OperationData(sqlBuffer.toString(), primaryKeys);
        }

        @Override
        public boolean execute(ITable table, int row) throws DataSetException, SQLException {
            this.logger.debug("execute(table={}, row={}) - start", (Object)table, (Object)String.valueOf(row));
            Column[] columns = this._operationData.getColumns();
            int i = 0;
            while (i < columns.length) {
                Object value = table.getValue(row, columns[i].getColumnName());
                DataType dataType = columns[i].getDataType();
                dataType.setSqlValue(value, i + 1, this._countStatement);
                ++i;
            }
            try (ResultSet resultSet = this._countStatement.executeQuery();){
                resultSet.next();
                boolean bl = resultSet.getInt(1) > 0;
                return bl;
            }
        }

        @Override
        public void close() throws SQLException {
            this.logger.debug("close() - start");
            this._countStatement.close();
        }
    }

    class RowOperation {
        private final Logger logger = LoggerFactory.getLogger(RowOperation.class);
        protected IPreparedBatchStatement _statement;
        protected OperationData _operationData;
        protected BitSet _ignoreMapping;

        RowOperation() {
        }

        public boolean execute(ITable table, int row) throws DataSetException, SQLException {
            this.logger.debug("execute(table={}, row={}) - start", (Object)table, (Object)String.valueOf(row));
            Column[] columns = this._operationData.getColumns();
            int i = 0;
            while (i < columns.length) {
                if (this._ignoreMapping == null || !this._ignoreMapping.get(i)) {
                    Object value = table.getValue(row, columns[i].getColumnName());
                    this._statement.addValue(value, columns[i].getDataType());
                }
                ++i;
            }
            this._statement.addBatch();
            int result = this._statement.executeBatch();
            this._statement.clearBatch();
            return result == 1;
        }

        public void close() throws SQLException {
            this.logger.debug("close() - start");
            if (this._statement != null) {
                this._statement.close();
            }
        }
    }

    private class UpdateRowOperation
    extends RowOperation {
        PreparedStatement _countStatement;

        public UpdateRowOperation(IDatabaseConnection connection, ITableMetaData metaData) throws DataSetException, SQLException {
            this._operationData = RefreshOperation.this._updateOperation.getOperationData(metaData, null, connection);
            this._statement = new SimplePreparedStatement(this._operationData.getSql(), connection.getConnection());
        }
    }
}

