/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.xebialabs.deployit.core.rest.api.reports.ExcelElements$;
import com.xebialabs.deployit.core.rest.api.reports.ExcelStyle$;
import com.xebialabs.deployit.report.audit.AuditPermissionRoleRow;
import com.xebialabs.deployit.report.audit.RolePrincipalPermissionRow;
import com.xebialabs.deployit.security.Permissions;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class AuditReportUtility$ {
    public static final AuditReportUtility$ MODULE$ = new AuditReportUtility$();
    private static final DateTimeFormatter AUDIT_DATE_FORMAT_FILE_REPORT = DateTimeFormat.forPattern((String)"MMMM d, yyyy HH:mm a");

    private DateTimeFormatter AUDIT_DATE_FORMAT_FILE_REPORT() {
        return AUDIT_DATE_FORMAT_FILE_REPORT;
    }

    public Workbook createAuditReport(List<RolePrincipalPermissionRow> globalAuditReport, List<AuditPermissionRoleRow> folderAuditReport, String serverName, String versionNumber) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        this.createTemplateTab(workbook, serverName, versionNumber);
        this.createGlobalAuditReportTab(workbook, globalAuditReport);
        this.createFolderAuditReportTab(workbook, folderAuditReport);
        return workbook;
    }

    private void createTemplateTab(XSSFWorkbook workbook, String serverName, String versionNumber) {
        String userName = Permissions.getAuthenticatedUserName();
        String dateTime = String.format("%s", this.AUDIT_DATE_FORMAT_FILE_REPORT().print((ReadablePartial)LocalDateTime.now()));
        XSSFSheet sheet = workbook.createSheet("Report Info");
        sheet.setDefaultRowHeightInPoints(19.0f);
        sheet.setDisplayGridlines(false);
        URL imageData = this.getClass().getResource("/xl_deploy_logo_green.png");
        ExcelElements$.MODULE$.insertImage(imageData, (Workbook)workbook, (Sheet)sheet);
        CellStyle cellStyle = ExcelStyle$.MODULE$.getCellStyle(workbook);
        CellStyle cellBoldStyle = ExcelStyle$.MODULE$.getBoldCellStyle((Workbook)workbook);
        String[] reportInfo = (String[])((Object[])new String[]{"Generated On", "Generated By", "XL Deploy instance"});
        String[] reportInfoValue = (String[])((Object[])new String[]{dateTime, userName, serverName});
        XSSFRow firstRow = sheet.createRow(0);
        firstRow.createCell(0).setCellValue("XL Deploy User Permissions Report");
        firstRow.getCell(0).setCellStyle(cellStyle);
        ExcelElements$.MODULE$.addCell((Row)firstRow, workbook);
        sheet.createRow(1).createCell(0).setCellValue("");
        XSSFRow row2 = sheet.createRow(2);
        row2.createCell(0).setCellValue("Report Info");
        row2.getCell(0).setCellStyle(cellBoldStyle);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            block0: {
                XSSFRow row = sheet.createRow(i - 1);
                row.createCell(1).setCellValue(reportInfo[i - 3]);
                row.createCell(2).setCellValue(reportInfoValue[i - 3]);
                if (i != 5) break block0;
                XSSFCreationHelper createHelper = workbook.getCreationHelper();
                XSSFHyperlink link = createHelper.createHyperlink(HyperlinkType.URL);
                XSSFFont hLinkFont = workbook.createFont();
                XSSFCellStyle hLinkStyle = workbook.createCellStyle();
                hLinkFont.setUnderline((byte)1);
                hLinkStyle.setFont((Font)hLinkFont);
                link.setAddress(serverName);
                XSSFCell cell = row.getCell(2);
                cell.setCellStyle(ExcelStyle$.MODULE$.getHyperlinkCellStyle((Workbook)workbook));
                cell.setHyperlink((Hyperlink)link);
            }
        });
        sheet.createRow(5).createCell(7).setCellValue(versionNumber);
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])reportInfo)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> sheet.autoSizeColumn(i));
    }

    private void createGlobalAuditReportTab(XSSFWorkbook workbook, List<RolePrincipalPermissionRow> globalAuditReport) {
        XSSFSheet sheet = workbook.createSheet("Global");
        sheet.setDisplayGridlines(false);
        sheet.setDefaultColumnWidth(30);
        String[] globalAuditReportColumn = (String[])((Object[])new String[]{"Roles", "Principals", "Permissions"});
        CellStyle cellStyle = ExcelStyle$.MODULE$.getCellStyle(workbook);
        XSSFRow headerRow = sheet.createRow(0);
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])globalAuditReportColumn)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            XSSFCell cell = headerRow.createCell(i);
            cell.setCellValue(globalAuditReportColumn[i]);
            cell.setCellStyle(cellStyle);
        });
        XSSFCellStyle cellBorderStyle = ExcelStyle$.MODULE$.cellBorderStyle(workbook);
        ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(globalAuditReport).asScala().zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AuditReportUtility$.$anonfun$createGlobalAuditReportTab$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            AuditReportUtility$.$anonfun$createGlobalAuditReportTab$3(sheet, cellBorderStyle, x$1);
            return BoxedUnit.UNIT;
        });
    }

    private void createFolderAuditReportTab(XSSFWorkbook workbook, List<AuditPermissionRoleRow> folderAuditReport) {
        XSSFSheet sheet = workbook.createSheet("Folder");
        sheet.setDisplayGridlines(false);
        sheet.setDefaultColumnWidth(30);
        String[] folderAuditReportColumn = (String[])((Object[])new String[]{"Folder", "Folder Permissions", "Role"});
        CellStyle cellStyle = ExcelStyle$.MODULE$.getCellStyle(workbook);
        XSSFRow headerRow = sheet.createRow(0);
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])folderAuditReportColumn)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            XSSFCell cell = headerRow.createCell(i);
            cell.setCellValue(folderAuditReportColumn[i]);
            cell.setCellStyle(cellStyle);
        });
        XSSFCreationHelper creationHelper = workbook.getCreationHelper();
        XSSFCellStyle cellBorderStyle = ExcelStyle$.MODULE$.cellBorderStyle(workbook);
        ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(folderAuditReport).asScala().zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AuditReportUtility$.$anonfun$createFolderAuditReportTab$2(check$ifrefutable$2))).foreach((Function1 & Serializable)x$3 -> {
            AuditReportUtility$.$anonfun$createFolderAuditReportTab$3(sheet, folderAuditReportColumn, cellBorderStyle, creationHelper, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$createGlobalAuditReportTab$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$createGlobalAuditReportTab$3(XSSFSheet sheet$2, XSSFCellStyle cellBorderStyle$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RolePrincipalPermissionRow p = (RolePrincipalPermissionRow)tuple2._1();
        int index = tuple2._2$mcI$sp();
        XSSFRow row = sheet$2.createRow(index + 1);
        XSSFCell cell = row.createCell(0);
        cell.setCellValue(p.role());
        cell.setCellStyle((CellStyle)cellBorderStyle$1);
        cell = row.createCell(1);
        cell.setCellValue(p.principal());
        cell.setCellStyle((CellStyle)cellBorderStyle$1);
        cell = row.createCell(2);
        cell.setCellValue(p.permission());
        cell.setCellStyle((CellStyle)cellBorderStyle$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$createFolderAuditReportTab$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$createFolderAuditReportTab$3(XSSFSheet sheet$3, String[] folderAuditReportColumn$1, XSSFCellStyle cellBorderStyle$2, XSSFCreationHelper creationHelper$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        AuditPermissionRoleRow f = (AuditPermissionRoleRow)tuple2._1();
        int index = tuple2._2$mcI$sp();
        XSSFRow row = sheet$3.createRow(index + 1);
        ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])folderAuditReportColumn$1)).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> {
            int n = x$2;
            XSSFCell cell = row.createCell(0);
            cell.setCellValue(f.folder());
            cell.setCellStyle((CellStyle)cellBorderStyle$2);
            cell = row.createCell(1);
            cell.setCellValue(f.permission());
            cell.setCellStyle((CellStyle)cellBorderStyle$2);
            cell = row.createCell(2);
            cell.setCellValue(f.role());
            cell.setCellStyle((CellStyle)cellBorderStyle$2);
            XSSFHyperlink link = creationHelper$1.createHyperlink(HyperlinkType.DOCUMENT);
            link.setAddress("'Global'!A1");
            cell.setHyperlink((Hyperlink)link);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private AuditReportUtility$() {
    }
}

