/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.alter;

import java.util.List;
import java.util.Objects;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterSystemOperation;

public class AlterSystemStatement
implements Statement {
    private final AlterSystemOperation operation;
    private final List<String> parameters;

    public AlterSystemStatement(AlterSystemOperation alterSystemOperation, List<String> list) {
        this.operation = Objects.requireNonNull(alterSystemOperation, "The ALTER SYSTEM Operation must not be Null");
        this.parameters = Objects.requireNonNull(list, "The PARAMETERS List must not be null although it can be empty.");
    }

    public AlterSystemOperation getOperation() {
        return this.operation;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    private static void appendParameters(StringBuilder stringBuilder, List<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            stringBuilder.append(" ").append(string);
        }
    }

    public StringBuilder appendTo(StringBuilder stringBuilder) {
        stringBuilder.append("ALTER SYSTEM ").append((Object)this.operation);
        AlterSystemStatement.appendParameters(stringBuilder, this.parameters);
        return stringBuilder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }
}

