/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.commons.shaded.johnzon.core;

import org.apache.activemq.artemis.commons.shaded.johnzon.core.Strings;
import org.apache.activemq.artemis.commons.shaded.json.JsonString;
import org.apache.activemq.artemis.commons.shaded.json.JsonValue;

final class JsonStringImpl
implements JsonString {
    private final String value;
    private String escape;
    private Integer hashCode = null;

    JsonStringImpl(String value) {
        if (value == null) {
            throw new NullPointerException("value must not be null");
        }
        this.value = value;
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public CharSequence getChars() {
        return this.value;
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.STRING;
    }

    @Override
    public String toString() {
        String s = this.escape;
        if (s == null) {
            this.escape = s = '\"' + Strings.escape(this.value) + '\"';
        }
        return s;
    }

    @Override
    public int hashCode() {
        Integer h = this.hashCode;
        if (h == null) {
            this.hashCode = h = Integer.valueOf(this.value.hashCode());
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return JsonString.class.isInstance(obj) && ((JsonString)JsonString.class.cast(obj)).getString().equals(this.value);
    }
}

