/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.xebialabs.deployit.booter.local.utils.Closeables;
import com.xebialabs.deployit.io.OneShotFileBackedOutputStream;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Imploder {
    public static Supplier<InputStream> implode(OverthereFile folder, MessageDigest sha1) throws IOException {
        return Imploder.implode(folder, sha1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Supplier<InputStream> implode(OverthereFile folder, MessageDigest sha1, boolean digestPaths) throws IOException {
        OneShotFileBackedOutputStream outputStream = new OneShotFileBackedOutputStream(0x500000);
        ZipOutputStream zipper = new ZipOutputStream(outputStream);
        try {
            for (OverthereFile file : folder.listFiles()) {
                Imploder.writeEntry(zipper, file, "", sha1, digestPaths);
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)zipper);
        }
        return outputStream.getSupplier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeEntry(ZipOutputStream zipper, OverthereFile file, String path, MessageDigest sha1, boolean digestPaths) throws IOException {
        if (file.isDirectory()) {
            ZipEntry zipEntry = new ZipEntry(path + file.getName() + "/");
            zipper.putNextEntry(zipEntry);
            Imploder.digestEntryPath(sha1, zipEntry, digestPaths);
            Imploder.writeDirectoryContents(zipper, file, path, sha1, digestPaths);
        } else {
            ZipEntry zipEntry = new ZipEntry(path + file.getName());
            zipper.putNextEntry(zipEntry);
            Imploder.digestEntryPath(sha1, zipEntry, digestPaths);
            DigestInputStream inputStream = new DigestInputStream(file.getInputStream(), sha1);
            try {
                OverthereUtils.write((InputStream)inputStream, (OutputStream)zipper);
            }
            finally {
                Closeables.closeQuietly((Closeable)inputStream);
            }
            zipper.closeEntry();
        }
    }

    private static void writeDirectoryContents(ZipOutputStream zipper, OverthereFile folder, String path, MessageDigest sha1, boolean digestPaths) throws IOException {
        if (folder.listFiles() == null) {
            return;
        }
        for (OverthereFile file : folder.listFiles()) {
            Imploder.writeEntry(zipper, file, path + folder.getName() + "/", sha1, digestPaths);
        }
    }

    private static void digestEntryPath(MessageDigest sha1, ZipEntry zipEntry, boolean digestPaths) throws UnsupportedEncodingException {
        if (digestPaths) {
            sha1.update(zipEntry.getName().getBytes(StandardCharsets.UTF_8));
        }
    }
}

