/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api;

import com.xebialabs.deployit.core.rest.secured.AbstractSecuredResource;
import com.xebialabs.deployit.engine.api.QueueService;
import com.xebialabs.deployit.engine.api.dto.QueuedTask;
import com.xebialabs.deployit.engine.api.dto.TaskQueueSummary;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.deployit.engine.tasker.TaskExecutionEngine;
import com.xebialabs.deployit.engine.tasker.repository.PendingTask;
import com.xebialabs.deployit.engine.tasker.repository.PendingTaskRepository;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.deployit.spring.BeanWrapper;
import com.xebialabs.xltype.serialization.util.DateUtil;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Service
@Autowired
@ScalaSignature(bytes="\u0006\u000594AAB\u0004\u0001)!Aq\u0004\u0001B\u0001B\u0003%!\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0005A\tV/Z;f'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002\t\u0013\u0005\u0019\u0011\r]5\u000b\u0005)Y\u0011\u0001\u0002:fgRT!\u0001D\u0007\u0002\t\r|'/\u001a\u0006\u0003\u001d=\t\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003!E\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003I\t1aY8n\u0007\u0001\u0019B\u0001A\u000b\u001cEA\u0011a#G\u0007\u0002/)\u0011\u0001$C\u0001\bg\u0016\u001cWO]3e\u0013\tQrCA\fBEN$(/Y2u'\u0016\u001cWO]3e%\u0016\u001cx.\u001e:dKB\u0011A\u0004I\u0007\u0002;)\u0011\u0001B\b\u0006\u0003?5\ta!\u001a8hS:,\u0017BA\u0011\u001e\u00051\tV/Z;f'\u0016\u0014h/[2f!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0003tY\u001a$$NC\u0001(\u0003!9'/\u001b>{Y\u0016$\u0017BA\u0015%\u0005\u001daunZ4j]\u001e\u00042a\u000b\u00181\u001b\u0005a#BA\u0017\u000e\u0003\u0019\u0019\bO]5oO&\u0011q\u0006\f\u0002\f\u0005\u0016\fgn\u0016:baB,'\u000f\u0005\u00022i5\t!G\u0003\u00024=\u00051A/Y:lKJL!!\u000e\u001a\u0003'Q\u000b7o[#yK\u000e,H/[8o\u000b:<\u0017N\\3\u0002+A,g\u000eZ5oOR\u000b7o\u001b*fa>\u001c\u0018\u000e^8ssB\u0011\u0001hO\u0007\u0002s)\u0011!HM\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u001f:\u0005U\u0001VM\u001c3j]\u001e$\u0016m]6SKB|7/\u001b;pef\fa\u0001P5oSRtDcA B\u0005B\u0011\u0001\tA\u0007\u0002\u000f!)qd\u0001a\u0001U!)ag\u0001a\u0001o\u0005Y\u0011/^3vK\u0012$\u0016m]6t)\u0005)\u0005c\u0001$L\u001b6\tqI\u0003\u0002I\u0013\u0006!Q\u000f^5m\u0015\u0005Q\u0015\u0001\u00026bm\u0006L!\u0001T$\u0003\t1K7\u000f\u001e\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!v\t1\u0001\u001a;p\u0013\t\u0011vJ\u0001\u0006Rk\u0016,X\r\u001a+bg.\f\u0001\u0003^1tWF+X-^3Tk6l\u0017M]=\u0015\u0003U\u0003\"A\u0014,\n\u0005]{%\u0001\u0005+bg.\fV/Z;f'VlW.\u0019:zQ\t\u0001\u0011\f\u0005\u0002[K6\t1L\u0003\u0002];\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005y{\u0016a\u00024bGR|'/\u001f\u0006\u0003A\u0006\fQAY3b]NT!AY2\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001Z\u0001\u0004_J<\u0017B\u00014\\\u0005%\tU\u000f^8xSJ,G\r\u000b\u0002\u0001QB\u0011\u0011\u000e\\\u0007\u0002U*\u00111.Y\u0001\u000bgR,'/Z8usB,\u0017BA7k\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class QueueServiceImpl
extends AbstractSecuredResource
implements QueueService,
Logging {
    private final BeanWrapper<TaskExecutionEngine> engine;
    private final PendingTaskRepository pendingTaskRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        QueueServiceImpl queueServiceImpl = this;
        synchronized (queueServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public java.util.List<QueuedTask> queuedTasks() {
        this.checkPermission(PlatformPermissions.ADMIN);
        Buffer queuedTasks = (Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.pendingTaskRepository.queuedTasks()).asScala().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            PendingTask task = (PendingTask)tuple2._1();
            int index = tuple2._2$mcI$sp();
            String satellitesString = (String)task.metadata().get("satellite_ids");
            List satellites = satellitesString != null && !satellitesString.isBlank() ? Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])satellitesString.split(",")), (Function1 & Serializable)x$1 -> x$1.trim(), ClassTag$.MODULE$.apply(String.class))).toList() : (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
            QueuedTask queuedTask = new QueuedTask(task.id(), (String)task.metadata().get("taskType"), DateUtil.toString((DateTime)task.queuedDate()), index + 1, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)satellites).asJava(), (String)task.metadata().get("environment_id"));
            return queuedTask;
        });
        return CollectionConverters$.MODULE$.BufferHasAsJava(queuedTasks).asJava();
    }

    public TaskQueueSummary taskQueueSummary() {
        this.checkPermission(PlatformPermissions.ADMIN);
        Function1 & Serializable statePredicate = (Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)QueueServiceImpl.$anonfun$taskQueueSummary$1(task));
        int numOfRunningTasks = CollectionConverters$.MODULE$.ListHasAsScala(((TaskExecutionEngine)this.engine.get()).getAllIncompleteTasks(FetchMode.SUMMARY)).asScala().count((Function1)statePredicate);
        Buffer queuedTasks = CollectionConverters$.MODULE$.ListHasAsScala(this.pendingTaskRepository.queuedTasks()).asScala();
        Seconds diffInSeconds = queuedTasks.nonEmpty() ? Seconds.secondsBetween((ReadableInstant)((PendingTask)queuedTasks.headOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).queuedDate(), (ReadableInstant)DateTime.now()) : Seconds.ZERO;
        return new TaskQueueSummary(numOfRunningTasks, queuedTasks.length(), diffInSeconds.getSeconds());
    }

    public static final /* synthetic */ boolean $anonfun$taskQueueSummary$1(TaskWithBlock task) {
        return task.getState() != null && task.getState().isExecutingSteps();
    }

    public QueueServiceImpl(BeanWrapper<TaskExecutionEngine> engine, PendingTaskRepository pendingTaskRepository) {
        this.engine = engine;
        this.pendingTaskRepository = pendingTaskRepository;
        Logging.$init$((Logging)this);
    }
}

