/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class Mem
implements Serializable {
    private static final long serialVersionUID = 10181L;
    long total = 0L;
    long ram = 0L;
    long used = 0L;
    long free = 0L;
    long actualUsed = 0L;
    long actualFree = 0L;
    double usedPercent = 0.0;
    double freePercent = 0.0;

    public native void gather(Sigar var1) throws SigarException;

    static Mem fetch(Sigar sigar) throws SigarException {
        Mem mem = new Mem();
        mem.gather(sigar);
        return mem;
    }

    public long getTotal() {
        return this.total;
    }

    public long getRam() {
        return this.ram;
    }

    public long getUsed() {
        return this.used;
    }

    public long getFree() {
        return this.free;
    }

    public long getActualUsed() {
        return this.actualUsed;
    }

    public long getActualFree() {
        return this.actualFree;
    }

    public double getUsedPercent() {
        return this.usedPercent;
    }

    public double getFreePercent() {
        return this.freePercent;
    }

    void copyTo(Mem copy) {
        copy.total = this.total;
        copy.ram = this.ram;
        copy.used = this.used;
        copy.free = this.free;
        copy.actualUsed = this.actualUsed;
        copy.actualFree = this.actualFree;
        copy.usedPercent = this.usedPercent;
        copy.freePercent = this.freePercent;
    }

    public String toString() {
        return "Mem: " + this.total / 1024L + "K av, " + this.used / 1024L + "K used, " + this.free / 1024L + "K free";
    }

    public Map toMap() {
        String strfreePercent;
        String strusedPercent;
        String stractualFree;
        String stractualUsed;
        String strfree;
        String strused;
        String strram;
        HashMap<String, String> map = new HashMap<String, String>();
        String strtotal = String.valueOf(this.total);
        if (!"-1".equals(strtotal)) {
            map.put("Total", strtotal);
        }
        if (!"-1".equals(strram = String.valueOf(this.ram))) {
            map.put("Ram", strram);
        }
        if (!"-1".equals(strused = String.valueOf(this.used))) {
            map.put("Used", strused);
        }
        if (!"-1".equals(strfree = String.valueOf(this.free))) {
            map.put("Free", strfree);
        }
        if (!"-1".equals(stractualUsed = String.valueOf(this.actualUsed))) {
            map.put("ActualUsed", stractualUsed);
        }
        if (!"-1".equals(stractualFree = String.valueOf(this.actualFree))) {
            map.put("ActualFree", stractualFree);
        }
        if (!"-1".equals(strusedPercent = String.valueOf(this.usedPercent))) {
            map.put("UsedPercent", strusedPercent);
        }
        if (!"-1".equals(strfreePercent = String.valueOf(this.freePercent))) {
            map.put("FreePercent", strfreePercent);
        }
        return map;
    }
}

