/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.ant;

import java.util.ArrayList;
import java.util.List;
import liquibase.CatalogAndSchema;
import liquibase.Liquibase;
import liquibase.exception.LiquibaseException;
import liquibase.integration.ant.BaseLiquibaseTask;
import liquibase.util.StringUtil;
import org.apache.tools.ant.BuildException;

public class DropAllTask
extends BaseLiquibaseTask {
    private String schemas;
    private String catalog;

    @Override
    public void executeWithLiquibaseClassloader() throws BuildException {
        Liquibase liquibase = this.getLiquibase();
        try {
            if (StringUtil.trimToNull(this.schemas) != null) {
                List<String> schemaNames = StringUtil.splitAndTrim(this.schemas, ",");
                ArrayList<CatalogAndSchema> schemas = new ArrayList<CatalogAndSchema>();
                for (String name : schemaNames) {
                    schemas.add(new CatalogAndSchema(this.catalog, name));
                }
                liquibase.dropAll(schemas.toArray(new CatalogAndSchema[schemas.size()]));
            } else {
                liquibase.dropAll();
            }
        }
        catch (LiquibaseException e2) {
            throw new BuildException("Unable to drop all objects from database: " + e2.getMessage(), (Throwable)e2);
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getSchemas() {
        return this.schemas;
    }

    public void setSchemas(String schemas) {
        this.schemas = schemas;
    }
}

