/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.routing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.cluster.DiscoveryGroup;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.routing.CacheConfiguration;
import org.apache.activemq.artemis.core.config.routing.ConnectionRouterConfiguration;
import org.apache.activemq.artemis.core.config.routing.NamedPropertyConfiguration;
import org.apache.activemq.artemis.core.config.routing.PoolConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.routing.ConnectionRouter;
import org.apache.activemq.artemis.core.server.routing.caches.Cache;
import org.apache.activemq.artemis.core.server.routing.caches.LocalCache;
import org.apache.activemq.artemis.core.server.routing.policies.Policy;
import org.apache.activemq.artemis.core.server.routing.policies.PolicyFactory;
import org.apache.activemq.artemis.core.server.routing.policies.PolicyFactoryResolver;
import org.apache.activemq.artemis.core.server.routing.pools.AbstractPool;
import org.apache.activemq.artemis.core.server.routing.pools.ClusterPool;
import org.apache.activemq.artemis.core.server.routing.pools.DiscoveryGroupService;
import org.apache.activemq.artemis.core.server.routing.pools.DiscoveryPool;
import org.apache.activemq.artemis.core.server.routing.pools.Pool;
import org.apache.activemq.artemis.core.server.routing.pools.StaticPool;
import org.apache.activemq.artemis.core.server.routing.targets.ActiveMQTargetFactory;
import org.apache.activemq.artemis.core.server.routing.targets.LocalTarget;
import org.apache.activemq.artemis.core.server.routing.targets.Target;
import org.jboss.logging.Logger;

public final class ConnectionRouterManager
implements ActiveMQComponent {
    private static final Logger logger = Logger.getLogger(ConnectionRouterManager.class);
    public static final String CACHE_ID_PREFIX = "$.BC.";
    private final Configuration config;
    private final ActiveMQServer server;
    private final ScheduledExecutorService scheduledExecutor;
    private volatile boolean started = false;
    private Map<String, ConnectionRouter> connectionRouters = new HashMap<String, ConnectionRouter>();

    public boolean isStarted() {
        return this.started;
    }

    public ConnectionRouterManager(Configuration config, ActiveMQServer server, ScheduledExecutorService scheduledExecutor) {
        this.config = config;
        this.server = server;
        this.scheduledExecutor = scheduledExecutor;
    }

    public void deploy() throws Exception {
        for (ConnectionRouterConfiguration connectionRouterConfig : this.config.getConnectionRouters()) {
            this.deployConnectionRouter(connectionRouterConfig);
        }
    }

    public void deployConnectionRouter(ConnectionRouterConfiguration config) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debugf("Deploying ConnectionRouter " + config.getName(), new Object[0]);
        }
        LocalTarget localTarget = new LocalTarget(null, this.server);
        Cache cache = null;
        CacheConfiguration cacheConfiguration = config.getCacheConfiguration();
        if (cacheConfiguration != null) {
            cache = this.deployCache(cacheConfiguration, config.getName());
        }
        Pool pool = null;
        PoolConfiguration poolConfiguration = config.getPoolConfiguration();
        if (poolConfiguration != null) {
            pool = this.deployPool(config.getPoolConfiguration(), localTarget);
        }
        Policy policy = null;
        NamedPropertyConfiguration policyConfiguration = config.getPolicyConfiguration();
        if (policyConfiguration != null) {
            policy = this.deployPolicy(policyConfiguration, pool);
        }
        ConnectionRouter connectionRouter = new ConnectionRouter(config.getName(), config.getKeyType(), config.getKeyFilter(), localTarget, config.getLocalTargetFilter(), cache, pool, policy);
        this.connectionRouters.put(connectionRouter.getName(), connectionRouter);
        this.server.getManagementService().registerConnectionRouter(connectionRouter);
    }

    private Cache deployCache(CacheConfiguration configuration, String name) throws ClassNotFoundException {
        LocalCache cache = new LocalCache(CACHE_ID_PREFIX + name, configuration.isPersisted(), configuration.getTimeout(), this.server.getStorageManager());
        return cache;
    }

    private Pool deployPool(PoolConfiguration config, Target localTarget) throws Exception {
        AbstractPool pool;
        ActiveMQTargetFactory targetFactory = new ActiveMQTargetFactory();
        targetFactory.setUsername(config.getUsername());
        targetFactory.setPassword(config.getPassword());
        if (config.getClusterConnection() != null) {
            ClusterConnection clusterConnection = this.server.getClusterManager().getClusterConnection(config.getClusterConnection());
            pool = new ClusterPool(targetFactory, this.scheduledExecutor, config.getCheckPeriod(), clusterConnection);
        } else if (config.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration discoveryGroupConfiguration = this.server.getConfiguration().getDiscoveryGroupConfigurations().get(config.getDiscoveryGroupName());
            DiscoveryGroupService discoveryService = new DiscoveryGroupService(new DiscoveryGroup(this.server.getNodeID().toString(), config.getDiscoveryGroupName(), discoveryGroupConfiguration.getRefreshTimeout(), discoveryGroupConfiguration.getBroadcastEndpointFactory(), null));
            pool = new DiscoveryPool(targetFactory, this.scheduledExecutor, config.getCheckPeriod(), discoveryService);
        } else if (config.getStaticConnectors() != null) {
            Map<String, TransportConfiguration> connectorConfigurations = this.server.getConfiguration().getConnectorConfigurations();
            ArrayList<TransportConfiguration> staticConnectors = new ArrayList<TransportConfiguration>();
            for (String staticConnector : config.getStaticConnectors()) {
                TransportConfiguration connector = connectorConfigurations.get(staticConnector);
                if (connector != null) {
                    staticConnectors.add(connector);
                    continue;
                }
                logger.warn((Object)("Static connector not found: " + config.isLocalTargetEnabled()));
            }
            pool = new StaticPool(targetFactory, this.scheduledExecutor, config.getCheckPeriod(), staticConnectors);
        } else {
            throw new IllegalStateException("Pool configuration not valid");
        }
        pool.setUsername(config.getUsername());
        pool.setPassword(config.getPassword());
        pool.setQuorumSize(config.getQuorumSize());
        pool.setQuorumTimeout(config.getQuorumTimeout());
        if (config.isLocalTargetEnabled()) {
            pool.addTarget(localTarget);
        }
        return pool;
    }

    private Policy deployPolicy(NamedPropertyConfiguration policyConfig, Pool pool) throws ClassNotFoundException {
        PolicyFactory policyFactory = PolicyFactoryResolver.getInstance().resolve(policyConfig.getName());
        Policy policy = policyFactory.create();
        policy.init(policyConfig.getProperties());
        if (policy.getTargetProbe() != null) {
            pool.addTargetProbe(policy.getTargetProbe());
        }
        return policy;
    }

    public ConnectionRouter getRouter(String name) {
        return this.connectionRouters.get(name);
    }

    public void start() throws Exception {
        for (ConnectionRouter connectionRouter : this.connectionRouters.values()) {
            connectionRouter.start();
        }
        this.started = true;
    }

    public void stop() throws Exception {
        this.started = false;
        for (ConnectionRouter connectionRouter : this.connectionRouters.values()) {
            connectionRouter.stop();
            this.server.getManagementService().unregisterConnectionRouter(connectionRouter.getName());
        }
    }
}

