/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.util.HashSet;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.ssh.PrivateKeyIsValid;
import org.springframework.cloud.config.server.ssh.SshPropertyValidator;
import org.springframework.util.StringUtils;

public class PrivateKeyValidator
implements ConstraintValidator<PrivateKeyIsValid, MultipleJGitEnvironmentProperties> {
    private static final String GIT_PROPERTY_PREFIX = "spring.cloud.config.server.git.";
    private final SshPropertyValidator sshPropertyValidator = new SshPropertyValidator();

    public void initialize(PrivateKeyIsValid constrainAnnotation) {
    }

    public boolean isValid(MultipleJGitEnvironmentProperties sshUriProperties, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        HashSet<Boolean> validationResults = new HashSet<Boolean>();
        List<JGitEnvironmentProperties> extractedProperties = this.sshPropertyValidator.extractRepoProperties(sshUriProperties);
        for (JGitEnvironmentProperties extractedProperty : extractedProperties) {
            if (!extractedProperty.isIgnoreLocalSshSettings() || !SshPropertyValidator.isSshUri(extractedProperty.getUri())) continue;
            validationResults.add(this.isPrivateKeyPresent(extractedProperty, context) && this.isPrivateKeyFormatCorrect(extractedProperty, context));
        }
        return !validationResults.contains(false);
    }

    private boolean isPrivateKeyPresent(JGitEnvironmentProperties sshUriProperties, ConstraintValidatorContext context) {
        if (!StringUtils.hasText((String)sshUriProperties.getPrivateKey())) {
            context.buildConstraintViolationWithTemplate(String.format("Property '%sprivateKey' must be set when '%signoreLocalSshSettings' is specified", GIT_PROPERTY_PREFIX, GIT_PROPERTY_PREFIX)).addConstraintViolation();
            return false;
        }
        return true;
    }

    private boolean isPrivateKeyFormatCorrect(JGitEnvironmentProperties sshUriProperties, ConstraintValidatorContext context) {
        try {
            KeyPair.load((JSch)new JSch(), (byte[])sshUriProperties.getPrivateKey().getBytes(), null);
            return true;
        }
        catch (JSchException e) {
            context.buildConstraintViolationWithTemplate(String.format("Property '%sprivateKey' is not a valid private key", GIT_PROPERTY_PREFIX)).addConstraintViolation();
            return false;
        }
    }
}

