/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.assertion;

import java.util.Map;
import org.dbunit.DatabaseUnitException;
import org.dbunit.assertion.DbUnitAssertBase;
import org.dbunit.assertion.FailureHandler;
import org.dbunit.assertion.comparer.value.ValueComparer;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;

public class DbUnitValueComparerAssert
extends DbUnitAssertBase {
    public void assertWithValueComparer(IDataSet expectedDataSet, IDataSet actualDataSet) throws DatabaseUnitException {
        ValueComparer defaultValueComparer = this.valueComparerDefaults.getDefaultValueComparer();
        this.assertWithValueComparer(expectedDataSet, actualDataSet, defaultValueComparer);
    }

    public void assertWithValueComparer(IDataSet expectedDataSet, IDataSet actualDataSet, ValueComparer defaultValueComparer) throws DatabaseUnitException {
        Map<String, Map<String, ValueComparer>> tableColumnValueComparers = this.valueComparerDefaults.getDefaultTableColumnValueComparerMap();
        this.assertWithValueComparer(expectedDataSet, actualDataSet, defaultValueComparer, tableColumnValueComparers);
    }

    public void assertWithValueComparer(IDataSet expectedDataSet, IDataSet actualDataSet, ValueComparer defaultValueComparer, Map<String, Map<String, ValueComparer>> tableColumnValueComparers) throws DatabaseUnitException {
        FailureHandler failureHandler = this.getDefaultFailureHandler();
        this.assertWithValueComparer(expectedDataSet, actualDataSet, failureHandler, defaultValueComparer, tableColumnValueComparers);
    }

    public void assertWithValueComparer(ITable expectedTable, ITable actualTable) throws DatabaseUnitException {
        ValueComparer defaultValueComparer = this.valueComparerDefaults.getDefaultValueComparer();
        this.assertWithValueComparer(expectedTable, actualTable, defaultValueComparer);
    }

    public void assertWithValueComparer(ITable expectedTable, ITable actualTable, ValueComparer defaultValueComparer) throws DatabaseUnitException {
        String tableName = expectedTable.getTableMetaData().getTableName();
        Map<String, ValueComparer> columnValueComparers = this.valueComparerDefaults.getDefaultColumnValueComparerMapForTable(tableName);
        this.assertWithValueComparer(expectedTable, actualTable, defaultValueComparer, columnValueComparers);
    }

    public void assertWithValueComparer(ITable expectedTable, ITable actualTable, ValueComparer defaultValueComparer, Map<String, ValueComparer> columnValueComparers) throws DatabaseUnitException {
        FailureHandler failureHandler = this.getDefaultFailureHandler();
        this.assertWithValueComparer(expectedTable, actualTable, failureHandler, defaultValueComparer, columnValueComparers);
    }

    public void assertWithValueComparer(ITable expectedTable, ITable actualTable, Column[] additionalColumnInfo, ValueComparer defaultValueComparer, Map<String, ValueComparer> columnValueComparers) throws DatabaseUnitException {
        FailureHandler failureHandler = this.getDefaultFailureHandler(additionalColumnInfo);
        this.assertWithValueComparer(expectedTable, actualTable, failureHandler, defaultValueComparer, columnValueComparers);
    }
}

