/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.ha;

import java.util.Map;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.server.NetworkHealthCheck;
import org.apache.activemq.artemis.core.server.cluster.ha.HAPolicy;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicaPolicy;
import org.apache.activemq.artemis.core.server.impl.ActiveMQServerImpl;
import org.apache.activemq.artemis.core.server.impl.LiveActivation;
import org.apache.activemq.artemis.core.server.impl.SharedNothingLiveActivation;

public class ReplicatedPolicy
implements HAPolicy<LiveActivation> {
    private boolean checkForLiveServer = ActiveMQDefaultConfiguration.isDefaultCheckForLiveServer();
    private String groupName = null;
    private String clusterName;
    private long initialReplicationSyncTimeout = ActiveMQDefaultConfiguration.getDefaultInitialReplicationSyncTimeout();
    private boolean allowAutoFailBack = ActiveMQDefaultConfiguration.isDefaultAllowAutoFailback();
    private boolean voteOnReplicationFailure;
    private int quorumSize;
    private int voteRetries;
    private long voteRetryWait;
    private long retryReplicationWait;
    private ReplicaPolicy replicaPolicy;
    private final NetworkHealthCheck networkHealthCheck;
    private final int quorumVoteWait;

    public ReplicatedPolicy(NetworkHealthCheck networkHealthCheck, int quorumVoteWait) {
        this.replicaPolicy = new ReplicaPolicy(networkHealthCheck, this, quorumVoteWait);
        this.networkHealthCheck = networkHealthCheck;
        this.quorumVoteWait = quorumVoteWait;
    }

    public ReplicatedPolicy(boolean checkForLiveServer, String groupName, String clusterName, long initialReplicationSyncTimeout, NetworkHealthCheck networkHealthCheck, boolean voteOnReplicationFailure, int quorumSize, int voteRetries, long voteRetryWait, int quorumVoteWait, long retryReplicationWait) {
        this.checkForLiveServer = checkForLiveServer;
        this.groupName = groupName;
        this.clusterName = clusterName;
        this.initialReplicationSyncTimeout = initialReplicationSyncTimeout;
        this.networkHealthCheck = networkHealthCheck;
        this.voteOnReplicationFailure = voteOnReplicationFailure;
        this.quorumSize = quorumSize;
        this.voteRetries = voteRetries;
        this.voteRetryWait = voteRetryWait;
        this.quorumVoteWait = quorumVoteWait;
        this.retryReplicationWait = retryReplicationWait;
    }

    public ReplicatedPolicy(boolean checkForLiveServer, boolean allowAutoFailBack, long initialReplicationSyncTimeout, String groupName, String clusterName, ReplicaPolicy replicaPolicy, NetworkHealthCheck networkHealthCheck, boolean voteOnReplicationFailure, int quorumSize, int voteRetries, long voteRetryWait, int quorumVoteWait) {
        this.checkForLiveServer = checkForLiveServer;
        this.clusterName = clusterName;
        this.groupName = groupName;
        this.allowAutoFailBack = allowAutoFailBack;
        this.initialReplicationSyncTimeout = initialReplicationSyncTimeout;
        this.replicaPolicy = replicaPolicy;
        this.networkHealthCheck = networkHealthCheck;
        this.voteOnReplicationFailure = voteOnReplicationFailure;
        this.quorumSize = quorumSize;
        this.quorumVoteWait = quorumVoteWait;
    }

    public boolean isCheckForLiveServer() {
        return this.checkForLiveServer;
    }

    public void setCheckForLiveServer(boolean checkForLiveServer) {
        this.checkForLiveServer = checkForLiveServer;
    }

    public boolean isAllowAutoFailBack() {
        return this.allowAutoFailBack;
    }

    @Deprecated
    public long getFailbackDelay() {
        return -1L;
    }

    @Deprecated
    public void setFailbackDelay(long failbackDelay) {
    }

    public long getInitialReplicationSyncTimeout() {
        return this.initialReplicationSyncTimeout;
    }

    public void setInitialReplicationSyncTimeout(long initialReplicationSyncTimeout) {
        this.initialReplicationSyncTimeout = initialReplicationSyncTimeout;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public ReplicaPolicy getReplicaPolicy() {
        if (this.replicaPolicy == null) {
            this.replicaPolicy = new ReplicaPolicy(this.networkHealthCheck, this, this.quorumVoteWait);
            this.replicaPolicy.setQuorumSize(this.quorumSize);
            this.replicaPolicy.setVoteOnReplicationFailure(this.voteOnReplicationFailure);
            this.replicaPolicy.setVoteRetries(this.voteRetries);
            this.replicaPolicy.setVoteRetryWait(this.voteRetryWait);
            this.replicaPolicy.setretryReplicationWait(this.retryReplicationWait);
            if (this.clusterName != null && this.clusterName.length() > 0) {
                this.replicaPolicy.setClusterName(this.clusterName);
            }
            if (this.groupName != null && this.groupName.length() > 0) {
                this.replicaPolicy.setGroupName(this.groupName);
            }
        }
        return this.replicaPolicy;
    }

    public void setReplicaPolicy(ReplicaPolicy replicaPolicy) {
        this.replicaPolicy = replicaPolicy;
    }

    @Override
    public String getBackupGroupName() {
        return this.groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String getScaleDownGroupName() {
        return null;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public boolean isSharedStore() {
        return false;
    }

    @Override
    public boolean isBackup() {
        return false;
    }

    @Override
    public boolean canScaleDown() {
        return false;
    }

    @Override
    public String getScaleDownClustername() {
        return null;
    }

    public void setAllowAutoFailBack(boolean allowAutoFailBack) {
        this.allowAutoFailBack = allowAutoFailBack;
    }

    public boolean isVoteOnReplicationFailure() {
        return this.voteOnReplicationFailure;
    }

    @Override
    public LiveActivation createActivation(ActiveMQServerImpl server, boolean wasLive, Map<String, Object> activationParams, IOCriticalErrorListener ioCriticalErrorListener) {
        return new SharedNothingLiveActivation(server, this);
    }

    public int getQuorumSize() {
        return this.quorumSize;
    }

    public void setQuorumSize(int quorumSize) {
        this.quorumSize = quorumSize;
    }

    public int getQuorumVoteWait() {
        return this.quorumVoteWait;
    }

    public long getRetryReplicationWait() {
        return this.retryReplicationWait;
    }
}

